/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.net.DisplayRewardToastMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class XPLevelsReward
extends Reward {
    private int xpLevels;

    public XPLevelsReward(long id, Quest quest, int x) {
        super(id, quest);
        this.xpLevels = x;
    }

    public XPLevelsReward(long id, Quest quest) {
        this(id, quest, 5);
    }

    @Override
    public RewardType getType() {
        return RewardTypes.XP_LEVELS;
    }

    @Override
    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putInt("xp_levels", this.xpLevels);
    }

    @Override
    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.xpLevels = nbt.getInt("xp_levels");
    }

    @Override
    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeVarInt(this.xpLevels);
    }

    @Override
    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.xpLevels = buffer.readVarInt();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addInt("xp_levels", this.xpLevels, v -> {
            this.xpLevels = v;
        }, 1, 1, Integer.MAX_VALUE).setNameKey("ftbquests.reward.ftbquests.xp_levels");
    }

    @Override
    public void claim(ServerPlayer player, boolean notify) {
        player.giveExperienceLevels(this.xpLevels);
        if (notify) {
            MutableComponent text = Component.translatable((String)"ftbquests.reward.ftbquests.xp_levels").append(": ").append((Component)Component.literal((String)("+" + this.xpLevels)).withStyle(ChatFormatting.GREEN));
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new DisplayRewardToastMessage(this.id, (Component)text, (Icon)Color4I.empty(), this.disableRewardScreenBlur));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.translatable((String)"ftbquests.reward.ftbquests.xp_levels").append(": ").append((Component)Component.literal((String)("+" + this.xpLevels)).withStyle(ChatFormatting.GREEN));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getButtonText() {
        return "+" + this.xpLevels;
    }
}

