/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import com.mojang.serialization.DynamicOps;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.ConfigIconItemStack;
import dev.ftb.mods.ftbquests.integration.RecipeModHelper;
import dev.ftb.mods.ftbquests.item.CustomIconItem;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.net.SyncTranslationMessageToServer;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import dev.ftb.mods.ftbquests.quest.translation.TranslationKey;
import dev.ftb.mods.ftbquests.registry.ModDataComponents;
import dev.ftb.mods.ftbquests.registry.ModItems;
import dev.ftb.mods.ftbquests.util.NetUtils;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import dev.ftb.mods.ftbquests.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QuestObjectBase
implements Comparable<QuestObjectBase> {
    private static final Pattern TAG_PATTERN = Pattern.compile("^[a-z0-9_]*$");
    private static Tristate sendNotifications = Tristate.DEFAULT;
    public final long id;
    protected boolean invalid = false;
    private ItemStack rawIcon = ItemStack.EMPTY;
    private List<String> tags = new ArrayList<String>(0);
    private Icon cachedIcon = null;
    private Component cachedTitle = null;
    private Set<String> cachedTags = null;
    protected EnumMap<TranslationKey, String> protoTranslations = new EnumMap(TranslationKey.class);

    public QuestObjectBase(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public static boolean isNull(@Nullable QuestObjectBase object) {
        return object == null || object.invalid;
    }

    public static long getID(@Nullable QuestObjectBase object) {
        return QuestObjectBase.isNull(object) ? 0L : object.id;
    }

    public static String getCodeString(long id) {
        return String.format("%016X", id);
    }

    public static String getCodeString(@Nullable QuestObjectBase object) {
        return QuestObjectBase.getCodeString(QuestObjectBase.getID(object));
    }

    public static boolean shouldSendNotifications() {
        return sendNotifications.get(true);
    }

    public static ItemStack itemOrMissingFromNBT(Tag tag, HolderLookup.Provider provider) {
        CompoundTag compoundTag = QuestObjectBase.processItemTagData(tag);
        return compoundTag.isEmpty() ? ItemStack.EMPTY : ItemStack.parse((HolderLookup.Provider)provider, (Tag)compoundTag).orElse(QuestObjectBase.createMissing(compoundTag));
    }

    public static ItemStack singleItemOrMissingFromNBT(Tag tag, HolderLookup.Provider provider) {
        CompoundTag compoundTag = QuestObjectBase.processItemTagData(tag);
        return compoundTag.isEmpty() ? ItemStack.EMPTY : ItemStack.SINGLE_ITEM_CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compoundTag).result().orElse(QuestObjectBase.createMissing(compoundTag));
    }

    private static CompoundTag processItemTagData(Tag tag) {
        if (tag instanceof StringTag) {
            StringTag s = (StringTag)tag;
            return (CompoundTag)Util.make((Object)new CompoundTag(), t -> t.putString("id", s.getAsString()));
        }
        if (tag instanceof CompoundTag) {
            CompoundTag c = (CompoundTag)tag;
            if (c.contains("Count") || c.contains("tag")) {
                return (CompoundTag)Util.make((Object)new CompoundTag(), t -> {
                    t.putString("id", c.getString("id"));
                    int count = c.getInt("Count");
                    if (count != 0) {
                        t.putInt("count", count);
                    }
                });
            }
            return c;
        }
        return new CompoundTag();
    }

    private static ItemStack createMissing(CompoundTag tag) {
        String id = tag.getString("id");
        int count = Math.max(1, tag.getInt("count"));
        String text = count == 1 ? id : count + "x " + id;
        return (ItemStack)Util.make((Object)new ItemStack((ItemLike)ModItems.MISSING_ITEM.get()), stack -> stack.set((DataComponentType)ModDataComponents.MISSING_ITEM_DESC.get(), (Object)text));
    }

    public final boolean isValid() {
        return !this.invalid;
    }

    public final void setRawIcon(ItemStack rawIcon) {
        this.rawIcon = rawIcon;
    }

    public String getRawTitle() {
        if (!this.getQuestFile().isServerSide() && this.protoTranslations.containsKey((Object)TranslationKey.TITLE)) {
            return this.protoTranslations.get((Object)TranslationKey.TITLE);
        }
        return this.getQuestFile().getTranslationManager().getStringTranslation(this, this.getQuestFile().getLocale(), TranslationKey.TITLE).orElse("");
    }

    public void setRawTitle(String rawTitle) {
        this.setTranslatableValue(TranslationKey.TITLE, rawTitle);
        this.cachedTitle = null;
    }

    protected final void setTranslatableValue(TranslationKey translationKey, String value) {
        if (this.id != 0L) {
            String locale = this.getQuestFile().getLocale();
            this.getQuestFile().getTranslationManager().addTranslation(this, locale, translationKey, value);
            if (!this.getQuestFile().isServerSide()) {
                NetworkManager.sendToServer((CustomPacketPayload)SyncTranslationMessageToServer.create(this, locale, translationKey, value));
            }
        } else if (!this.getQuestFile().isServerSide()) {
            this.protoTranslations.put(translationKey, value);
        }
    }

    protected final void setTranslatableValue(TranslationKey translationKey, List<String> value) {
        if (this.id != 0L) {
            String locale = this.getQuestFile().getLocale();
            this.getQuestFile().getTranslationManager().addTranslation(this, locale, translationKey, value);
            if (!this.getQuestFile().isServerSide()) {
                NetworkManager.sendToServer((CustomPacketPayload)SyncTranslationMessageToServer.create(this, locale, translationKey, value));
            }
        }
    }

    public final String getProtoTranslation(TranslationKey key) {
        return this.protoTranslations.getOrDefault((Object)key, "");
    }

    public final void modifyTranslatableListValue(TranslationKey translationKey, Consumer<List<String>> setter) {
        if (translationKey.isListVal()) {
            List mutable = this.getQuestFile().getTranslationManager().getStringListTranslation(this, this.getQuestFile().getLocale(), translationKey).map(ArrayList::new).orElse(new ArrayList());
            setter.accept(mutable);
            this.setTranslatableValue(translationKey, List.copyOf(mutable));
        }
    }

    public static long parseCodeString(String id) {
        if (id.isEmpty() || id.equals("-")) {
            return 0L;
        }
        try {
            return Long.parseLong(id.charAt(0) == '#' ? id.substring(1) : id, 16);
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static Optional<Long> parseHexId(String id) {
        try {
            return Optional.of(Long.parseLong(id, 16));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static Optional<String> titleToID(String s) {
        s = s.replace(' ', '_').replaceAll("\\W", "").toLowerCase().trim();
        while (s.startsWith("_")) {
            s = s.substring(1);
        }
        while (s.endsWith("_")) {
            s = s.substring(0, s.length() - 1);
        }
        return s.isEmpty() ? Optional.empty() : Optional.of(s);
    }

    public final String getCodeString() {
        return QuestObjectBase.getCodeString(this.id);
    }

    public final String toString() {
        return this.getCodeString();
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return Long.hashCode(this.id);
    }

    public abstract QuestObjectType getObjectType();

    public abstract BaseQuestFile getQuestFile();

    public Set<String> getTags() {
        if (this.tags.isEmpty()) {
            return Collections.emptySet();
        }
        if (this.cachedTags == null) {
            this.cachedTags = new LinkedHashSet<String>(this.tags);
        }
        return this.cachedTags;
    }

    public boolean hasTag(String tag) {
        return !this.tags.isEmpty() && this.getTags().contains(tag);
    }

    public void forceProgress(TeamData teamData, ProgressChange progressChange) {
    }

    public final void forceProgressRaw(TeamData teamData, ProgressChange progressChange) {
        if (teamData.isLocked()) {
            return;
        }
        teamData.clearCachedProgress();
        sendNotifications = progressChange.shouldNotify() ? Tristate.TRUE : Tristate.FALSE;
        this.forceProgress(teamData, progressChange);
        sendNotifications = Tristate.DEFAULT;
        teamData.clearCachedProgress();
        teamData.markDirty();
    }

    @Nullable
    public Chapter getQuestChapter() {
        return null;
    }

    public long getParentID() {
        return 1L;
    }

    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        if (!this.rawIcon.isEmpty()) {
            ItemStack.SINGLE_ITEM_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.rawIcon).ifSuccess(t -> nbt.put("icon", t));
        }
        if (!this.tags.isEmpty()) {
            nbt.put("tags", (Tag)Util.make((Object)new ListTag(), l -> {
                for (String s : this.tags) {
                    l.add((Object)StringTag.valueOf((String)s));
                }
            }));
        }
    }

    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        this.rawIcon = QuestObjectBase.singleItemOrMissingFromNBT((Tag)nbt.getCompound("icon"), provider);
        ListTag tagsList = nbt.getList("tags", 8);
        this.tags = new ArrayList<String>(tagsList.size());
        for (int i = 0; i < tagsList.size(); ++i) {
            this.tags.add(tagsList.getString(i));
        }
        if (nbt.contains("custom_id")) {
            this.tags.add(nbt.getString("custom_id"));
        }
    }

    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)2, (!this.rawIcon.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)4, (!this.tags.isEmpty() ? 1 : 0) != 0);
        buffer.writeVarInt(flags);
        if (!this.rawIcon.isEmpty()) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)this.rawIcon);
        }
        if (!this.tags.isEmpty()) {
            NetUtils.writeStrings((FriendlyByteBuf)buffer, this.tags);
        }
    }

    public void readNetData(RegistryFriendlyByteBuf buffer) {
        int flags = buffer.readVarInt();
        this.rawIcon = Bits.getFlag((int)flags, (int)2) ? (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer) : ItemStack.EMPTY;
        this.tags = new ArrayList<String>(0);
        if (Bits.getFlag((int)flags, (int)4)) {
            NetUtils.readStrings((FriendlyByteBuf)buffer, this.tags);
        }
    }

    protected boolean hasTitleConfig() {
        return true;
    }

    protected boolean hasIconConfig() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        if (this.hasTitleConfig()) {
            config.addString("title", this.getRawTitle(), this::setRawTitle, "").setNameKey("ftbquests.title").setOrder(-127);
        }
        if (this.hasIconConfig()) {
            ((ConfigIconItemStack)config.add("icon", (ConfigValue)new ConfigIconItemStack(), (Object)this.rawIcon, v -> {
                this.rawIcon = v;
            }, (Object)ItemStack.EMPTY)).setNameKey("ftbquests.icon").setOrder(-126);
        }
        config.addList("tags", this.tags, (ConfigValue)new StringConfig(TAG_PATTERN), (Object)"").setNameKey("ftbquests.tags").setOrder(-125);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract Component getAltTitle();

    @OnlyIn(value=Dist.CLIENT)
    public abstract Icon getAltIcon();

    @OnlyIn(value=Dist.CLIENT)
    public final Component getTitle() {
        if (this.cachedTitle != null) {
            return this.cachedTitle.copy();
        }
        this.cachedTitle = !this.getRawTitle().isEmpty() ? TextUtils.parseRawText(this.getRawTitle(), this.holderLookup()) : this.getAltTitle();
        return this.cachedTitle.copy();
    }

    @OnlyIn(value=Dist.CLIENT)
    public final MutableComponent getMutableTitle() {
        return this.getTitle().copy();
    }

    @OnlyIn(value=Dist.CLIENT)
    public final Icon getIcon() {
        if (this.cachedIcon == null) {
            if (!this.rawIcon.isEmpty()) {
                this.cachedIcon = CustomIconItem.getIcon(this.rawIcon);
            }
            if (this.cachedIcon == null || this.cachedIcon.isEmpty()) {
                this.cachedIcon = (Icon)ThemeProperties.ICON.get(this);
            }
            if (this.cachedIcon.isEmpty()) {
                this.cachedIcon = this.getAltIcon();
            }
        }
        return this.cachedIcon;
    }

    public void deleteSelf() {
        this.getQuestFile().remove(this.id);
    }

    public void deleteChildren() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void editedFromGUI() {
        ClientQuestFile.INSTANCE.refreshGui();
    }

    public void editedFromGUIOnServer() {
    }

    public void onCreated() {
    }

    public Optional<String> getPath() {
        return Optional.empty();
    }

    public void clearCachedData() {
        this.cachedIcon = null;
        this.cachedTitle = null;
        this.cachedTags = null;
    }

    public ConfigGroup createSubGroup(ConfigGroup group) {
        return group.getOrCreateSubgroup(this.getObjectType().getId());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onEditButtonClicked(Runnable gui) {
        ConfigGroup group = new ConfigGroup("ftbquests", accepted -> {
            gui.run();
            if (accepted && this.validateEditedConfig()) {
                NetworkManager.sendToServer((CustomPacketPayload)EditObjectMessage.forQuestObject(this));
            }
        });
        this.fillConfigGroup(this.createSubGroup(group));
        new EditConfigScreen(group).openGui();
    }

    protected boolean validateEditedConfig() {
        return true;
    }

    public Set<RecipeModHelper.Components> componentsToRefresh() {
        return EnumSet.noneOf(RecipeModHelper.Components.class);
    }

    public static <T extends QuestObjectBase> T copy(T orig, Supplier<T> factory) {
        QuestObjectBase copied = (QuestObjectBase)factory.get();
        if (copied == null) {
            return null;
        }
        CompoundTag tag = new CompoundTag();
        orig.writeData(tag, orig.holderLookup());
        copied.readData(tag, orig.holderLookup());
        return (T)copied;
    }

    @Override
    public int compareTo(@NotNull QuestObjectBase other) {
        int typeCmp = Integer.compare(this.getObjectType().ordinal(), other.getObjectType().ordinal());
        return typeCmp == 0 ? this.getTitle().getString().toLowerCase().compareTo(other.getTitle().getString().toLowerCase()) : typeCmp;
    }

    public HolderLookup.Provider holderLookup() {
        return this.getQuestFile().holderLookup();
    }

    protected CompoundTag saveItemSingleLine(ItemStack stack) {
        if (stack.isEmpty()) {
            return new SNBTCompoundTag();
        }
        return (CompoundTag)Util.make((Object)SNBTCompoundTag.of((Tag)stack.save(this.holderLookup())), SNBTCompoundTag::singleLine);
    }
}

