/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.block.TaskScreenBlock;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public record TaskScreenConfigResponseMessage(BlockPos pos, CompoundTag payload) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TaskScreenConfigResponseMessage> TYPE = new CustomPacketPayload.Type(FTBQuestsAPI.rl("task_screen_config_response_message"));
    public static final StreamCodec<FriendlyByteBuf, TaskScreenConfigResponseMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, TaskScreenConfigResponseMessage::pos, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, TaskScreenConfigResponseMessage::payload, TaskScreenConfigResponseMessage::new);

    public CustomPacketPayload.Type<TaskScreenConfigResponseMessage> type() {
        return TYPE;
    }

    public static void handle(TaskScreenConfigResponseMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            TaskScreenBlockEntity taskScreen;
            ServerPlayer serverPlayer;
            BlockEntity patt1$temp;
            Player patt0$temp = context.getPlayer();
            if (patt0$temp instanceof ServerPlayer && (patt1$temp = (serverPlayer = (ServerPlayer)patt0$temp).level().getBlockEntity(message.pos)) instanceof TaskScreenBlockEntity && TaskScreenBlock.hasPermissionToEdit(serverPlayer, taskScreen = (TaskScreenBlockEntity)patt1$temp)) {
                taskScreen.loadAdditional(message.payload, (HolderLookup.Provider)serverPlayer.registryAccess());
                serverPlayer.level().sendBlockUpdated(taskScreen.getBlockPos(), taskScreen.getBlockState(), taskScreen.getBlockState(), 3);
                taskScreen.setChanged();
            }
        });
    }
}

