/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.net.MoveChapterResponseMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.util.NetUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;

public record MoveChapterMessage(long id, boolean movingUp) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MoveChapterMessage> TYPE = new CustomPacketPayload.Type(FTBQuestsAPI.rl("move_chapter_message"));
    public static final StreamCodec<FriendlyByteBuf, MoveChapterMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, MoveChapterMessage::id, (StreamCodec)ByteBufCodecs.BOOL, MoveChapterMessage::movingUp, MoveChapterMessage::new);

    public CustomPacketPayload.Type<MoveChapterMessage> type() {
        return TYPE;
    }

    public static void handle(MoveChapterMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            Chapter chapter;
            if (NetUtils.canEdit(context) && (chapter = ServerQuestFile.INSTANCE.getChapter(message.id)) != null && chapter.getGroup().moveChapterWithinGroup(chapter, message.movingUp)) {
                chapter.file.clearCachedData();
                NetworkHelper.sendToAll((MinecraftServer)ServerQuestFile.INSTANCE.server, (CustomPacketPayload)new MoveChapterResponseMessage(message.id, message.movingUp));
                chapter.file.markDirty();
            }
        });
    }
}

