/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.reward.ChoiceReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record ClaimChoiceRewardMessage(long id, int index) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClaimChoiceRewardMessage> TYPE = new CustomPacketPayload.Type(FTBQuestsAPI.rl("claim_choice_reward_message"));
    public static final StreamCodec<FriendlyByteBuf, ClaimChoiceRewardMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, ClaimChoiceRewardMessage::id, (StreamCodec)ByteBufCodecs.VAR_INT, ClaimChoiceRewardMessage::index, ClaimChoiceRewardMessage::new);

    public CustomPacketPayload.Type<ClaimChoiceRewardMessage> type() {
        return TYPE;
    }

    public static void handle(ClaimChoiceRewardMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            Reward reward = ServerQuestFile.INSTANCE.getReward(message.id);
            if (reward instanceof ChoiceReward) {
                ChoiceReward choiceReward = (ChoiceReward)reward;
                Player patt0$temp = context.getPlayer();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                    ServerQuestFile.INSTANCE.getTeamData((Player)serverPlayer).ifPresent(data -> {
                        RewardTable table = choiceReward.getTable();
                        if (table != null && data.isCompleted(reward.getQuest()) && message.index >= 0 && message.index < table.getWeightedRewards().size()) {
                            table.getWeightedRewards().get(message.index).getReward().claim(serverPlayer, true);
                            data.claimReward(serverPlayer, reward, true);
                        }
                    });
                }
            }
        });
    }
}

