/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.snbt.config;

import dev.ftb.mods.ftblibrary.sidebar.SidebarGuiButton;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.BaseValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class StringSidebarMapValue
extends BaseValue<Map<String, SideButtonInfo>> {
    public StringSidebarMapValue(@Nullable SNBTConfig c, String n, Map<String, SideButtonInfo> def) {
        super(c, n, def);
        super.set(new HashMap<String, SideButtonInfo>(def));
    }

    @Override
    public void write(SNBTCompoundTag tag) {
        Map map = (Map)this.get();
        SNBTCompoundTag mapTag = new SNBTCompoundTag();
        for (Map.Entry entry : map.entrySet()) {
            SNBTCompoundTag buttonTag = new SNBTCompoundTag();
            buttonTag.putBoolean("enabled", ((SideButtonInfo)entry.getValue()).enabled());
            buttonTag.putInt("x", ((SideButtonInfo)entry.getValue()).xPos());
            buttonTag.putInt("y", ((SideButtonInfo)entry.getValue()).yPos());
            mapTag.put((String)entry.getKey(), (Tag)buttonTag);
        }
        tag.put(this.key, (Tag)mapTag);
    }

    @Override
    public void read(SNBTCompoundTag tag) {
        HashMap<String, SideButtonInfo> map = new HashMap<String, SideButtonInfo>();
        SNBTCompoundTag compound = tag.getCompound(this.key);
        for (String key : compound.getAllKeys()) {
            SNBTCompoundTag buttonTag = compound.getCompound(key);
            map.put(key, new SideButtonInfo(buttonTag.getBoolean("enabled"), buttonTag.getInt("x"), buttonTag.getInt("y")));
        }
        this.set(map);
    }

    public record SideButtonInfo(boolean enabled, int xPos, int yPos) {
        public static SideButtonInfo DISABLED = new SideButtonInfo(false, -1, -1);

        public static SideButtonInfo at(int x, int y) {
            return new SideButtonInfo(true, x, y);
        }

        public static SideButtonInfo ofButton(SidebarGuiButton button) {
            return new SideButtonInfo(button.isEnabled(), button.getGridLocation().x(), button.getGridLocation().y());
        }
    }
}

