/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config;

import dev.ftb.mods.ftblibrary.config.NumberConfig;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class DoubleConfig
extends NumberConfig<Double> {
    public DoubleConfig(double mn, double mx) {
        super(mn, mx);
        this.scrollIncrement = 1.0;
    }

    @Override
    public void addInfo(TooltipList list) {
        super.addInfo(list);
        if ((Double)this.min != Double.NEGATIVE_INFINITY) {
            list.add(DoubleConfig.info("Min", this.formatValue((Double)this.min)));
        }
        if ((Double)this.max != Double.POSITIVE_INFINITY) {
            list.add(DoubleConfig.info("Max", this.formatValue((Double)this.max)));
        }
    }

    @Override
    public String getStringFromValue(@Nullable Double v) {
        if (v == null) {
            return "null";
        }
        if (v == Double.POSITIVE_INFINITY) {
            return "+Inf";
        }
        if (v == Double.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        return super.getStringFromValue(v);
    }

    @Override
    public boolean parse(@Nullable Consumer<Double> callback, String string) {
        if (string.equals("-") || string.equals("+") || string.isEmpty()) {
            return this.okValue(callback, 0.0);
        }
        switch (string) {
            case "+Inf": {
                return (Double)this.max == Double.POSITIVE_INFINITY && this.okValue(callback, Double.POSITIVE_INFINITY);
            }
            case "-Inf": {
                return (Double)this.min == Double.NEGATIVE_INFINITY && this.okValue(callback, Double.NEGATIVE_INFINITY);
            }
            case "-": {
                return (Double)this.min <= 0.0 && (Double)this.max >= 0.0 && this.okValue(callback, 0.0);
            }
        }
        try {
            double multiplier = 1.0;
            if (string.endsWith("K")) {
                multiplier = 1000.0;
                string = string.substring(0, string.length() - 1);
            } else if (string.endsWith("M")) {
                multiplier = 1000000.0;
                string = string.substring(0, string.length() - 1);
            } else if (string.endsWith("B")) {
                multiplier = 1.0E9;
                string = string.substring(0, string.length() - 1);
            }
            double v = Double.parseDouble(string.trim()) * multiplier;
            if (v >= (Double)this.min && v <= (Double)this.max) {
                return this.okValue(callback, v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Optional<Double> scrollValue(Double currentValue, boolean forward) {
        double newVal = Mth.clamp((double)(currentValue + (forward ? (Double)this.scrollIncrement : -((Double)this.scrollIncrement).doubleValue())), (double)((Double)this.min), (double)((Double)this.max));
        return newVal != currentValue ? Optional.of(newVal) : Optional.empty();
    }
}

