/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.impl.misc;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.mixin.PlayerListAccess;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.Leaderboard;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderboardCommand
implements FTBCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeaderboardCommand.class);

    @Override
    public boolean enabled() {
        return FTBEConfig.LEADERBOARD.isEnabled();
    }

    @Override
    public List<LiteralArgumentBuilder<CommandSourceStack>> register() {
        return Collections.singletonList(Leaderboard.buildCommand());
    }

    public static <T extends Number> int leaderboard(CommandSourceStack source, Leaderboard<T> leaderboard, boolean reverse) {
        int i;
        List<UUID> knownPlayers = FTBEPlayerData.getAllKnownPlayers();
        List<FTBEPlayerData> playerData = knownPlayers.stream().map(uuid -> FTBEPlayerData.getOrCreate(source.getServer(), uuid)).filter(Optional::isPresent).map(Optional::get).toList();
        ArrayList<Pair> list = new ArrayList<Pair>();
        int self = -1;
        Path worldPath = source.getServer().getWorldPath(LevelResource.PLAYER_STATS_DIR);
        if (!Files.exists(worldPath, new LinkOption[0])) {
            return 1;
        }
        playerData.forEach(pd -> {
            ServerStatsCounter stats = LeaderboardCommand.getPlayerStats(source.getServer(), pd.getUuid());
            Object num = leaderboard.getValue(stats);
            if (leaderboard.test(num)) {
                list.add(Pair.of((Object)pd, num));
            }
        });
        if (reverse) {
            list.sort(Comparator.comparingDouble(pair -> ((Number)pair.getRight()).doubleValue()));
        } else {
            list.sort((pair1, pair2) -> Double.compare(((Number)pair2.getRight()).doubleValue(), ((Number)pair1.getRight()).doubleValue()));
        }
        if (source.getEntity() instanceof ServerPlayer) {
            for (i = 0; i < list.size(); ++i) {
                if (!((FTBEPlayerData)((Pair)list.get(i)).getLeft()).getUuid().equals(source.getEntity().getUUID())) continue;
                self = list.size();
                break;
            }
        }
        source.sendSuccess(() -> Component.literal((String)"== ").append((Component)Component.translatable((String)"ftbessentials.leaderboard", (Object[])new Object[]{leaderboard.formattedName()})).append((Component)Component.literal((String)" ==").withStyle(ChatFormatting.DARK_GREEN)), false);
        if (list.isEmpty()) {
            source.sendSuccess(() -> Component.translatable((String)"ftbessentials.leaderboard.no_data").withStyle(ChatFormatting.GRAY), false);
            return 1;
        }
        for (i = 0; i < Math.min(20, list.size()); ++i) {
            Pair pair3 = (Pair)list.get(i);
            String num = String.format("%02d", i + 1);
            MutableComponent component = Component.literal((String)"");
            component.withStyle(ChatFormatting.GRAY);
            if (i == 0) {
                component.append((Component)Component.literal((String)("#" + num + " ")).withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
            } else if (i == 1) {
                component.append((Component)Component.literal((String)("#" + num + " ")).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)11590143))));
            } else if (i == 2) {
                component.append((Component)Component.literal((String)("#" + num + " ")).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)13467442))));
            } else {
                component.append((Component)Component.literal((String)("#" + num + " ")).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xB4B4B4))));
            }
            TextColor color = TextColor.fromRgb((int)13467442);
            component.append((Component)Component.literal((String)((FTBEPlayerData)pair3.getLeft()).getName()).withStyle(i == self ? ChatFormatting.GREEN : ChatFormatting.YELLOW));
            component.append((Component)Component.literal((String)": "));
            component.append((Component)Component.literal((String)leaderboard.asString((Number)pair3.getRight())).withStyle(ChatFormatting.WHITE));
            source.sendSuccess(() -> component, false);
        }
        return 1;
    }

    private static ServerStatsCounter getPlayerStats(MinecraftServer server, UUID playerId) {
        Map<UUID, ServerStatsCounter> stats = ((PlayerListAccess)server.getPlayerList()).getStats();
        return stats.computeIfAbsent(playerId, k -> {
            File file1 = server.getWorldPath(LevelResource.PLAYER_STATS_DIR).toFile();
            File file2 = new File(file1, String.valueOf(playerId) + ".json");
            return new ServerStatsCounter(server, file2);
        });
    }
}

