/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record AddWaypointPacket(String name, GlobalPos position, int color, boolean useGui) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AddWaypointPacket> TYPE = new CustomPacketPayload.Type(FTBChunksAPI.rl("add_waypoint_packet"));
    public static final StreamCodec<FriendlyByteBuf, AddWaypointPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, AddWaypointPacket::name, (StreamCodec)GlobalPos.STREAM_CODEC, AddWaypointPacket::position, (StreamCodec)ByteBufCodecs.INT, AddWaypointPacket::color, (StreamCodec)ByteBufCodecs.BOOL, AddWaypointPacket::useGui, AddWaypointPacket::new);

    public CustomPacketPayload.Type<AddWaypointPacket> type() {
        return TYPE;
    }

    public static void handle(AddWaypointPacket message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            if (message.useGui()) {
                StringConfig configName = new StringConfig();
                configName.setValue((Object)message.name);
                new FTBChunksClient.WaypointAddScreen(configName, message.position).openGui();
            } else {
                FTBChunksClient.addWaypoint(message.name, message.position, message.color);
            }
        });
    }
}

