/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.gui;

import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.gui.SliceCreationGUI;
import dev.ftb.mods.ftbchunks.client.mapicon.EntityIcons;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.ToggleableButton;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractGroupedButtonListScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;

public class EntityIconSettingsScreen
extends AbstractGroupedButtonListScreen<MobCategory, EntityType<?>> {
    private final boolean showCreationButton;

    public EntityIconSettingsScreen(boolean showCreationButton) {
        super((Component)Component.translatable((String)"ftbchunks.gui.entity_icon_settings"));
        this.showCreationButton = showCreationButton;
    }

    protected List<AbstractGroupedButtonListScreen.GroupData<MobCategory, EntityType<?>>> getGroups() {
        ArrayList groups = new ArrayList();
        for (MobCategory mobCategory : MobCategory.values()) {
            ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
            for (EntityType entityType : BuiltInRegistries.ENTITY_TYPE) {
                if (entityType.getCategory() != mobCategory || !EntityIcons.canTypeRenderer(entityType)) continue;
                entityTypes.add(entityType);
            }
            groups.add(new AbstractGroupedButtonListScreen.GroupData((Object)mobCategory, false, (Component)Component.translatable((String)("mob_category." + mobCategory.getName())), entityTypes));
        }
        return groups;
    }

    protected AbstractGroupedButtonListScreen.RowPanel createRowPanel(Panel panel, EntityType<?> value) {
        return new RowPanel(panel, value);
    }

    private class RowPanel
    extends AbstractGroupedButtonListScreen.RowPanel {
        private TextField nameField;
        private SimpleButton hideButton;
        private SimpleButton createButton;
        private final Icon icon;
        private final ResourceKey<EntityType<?>> resourceKey;

        public RowPanel(Panel panel, EntityType<?> entityType) {
            super((AbstractGroupedButtonListScreen)EntityIconSettingsScreen.this, panel, entityType);
            this.icon = EntityIcons.getIcon(entityType);
            this.resourceKey = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)BuiltInRegistries.ENTITY_TYPE.getKey(entityType));
            this.setHeight(18);
        }

        public void addWidgets() {
            boolean hiddenState = ((Map)FTBChunksClientConfig.ENTITY_ICON.get()).getOrDefault(this.resourceKey, true);
            this.hideButton = new ToggleableButton((Panel)this, hiddenState, Icons.ACCEPT, Icons.ACCEPT_GRAY, (hideButton, hidden) -> {
                ((Map)FTBChunksClientConfig.ENTITY_ICON.get()).put(this.resourceKey, hidden);
                FTBChunksClientConfig.saveConfig();
            });
            this.add((Widget)this.hideButton);
            if (EntityIconSettingsScreen.this.showCreationButton) {
                boolean isDynamicTexture = EntityIcons.IS_USING_NEW_JSON.getOrDefault(this.value, false);
                Icon icon = isDynamicTexture ? Icons.BOOK_RED : Icons.BOOK;
                this.createButton = new SimpleButton((Panel)this, (Component)Component.translatable((String)"ftbchunks.gui.open_creation_gui"), icon, (widget, button) -> new SliceCreationGUI((EntityType)this.value).openGui());
                this.add((Widget)this.createButton);
            }
            final EntityIcons.EntityIconSettings entityIconSettings = EntityIcons.getSettings((EntityType)this.value).orElseThrow();
            this.nameField = new TextField((Panel)this){

                public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                    graphics.pose().pushPose();
                    graphics.pose().translate((float)(x - 16), (float)(y - 2), 0.0f);
                    graphics.pose().scale(0.75f, 0.75f, 0.0f);
                    RowPanel.this.icon.draw(graphics, 0, 0, entityIconSettings.widthHeight().width(), entityIconSettings.widthHeight().height());
                    graphics.pose().popPose();
                    super.draw(graphics, theme, x, y, w, h);
                }

                public void addMouseOverText(TooltipList list) {
                    list.add((Component)Component.literal((String)((EntityType)RowPanel.this.value).arch$registryName().toString()));
                }
            }.setTrim().addFlags(2);
            this.add((Widget)this.nameField);
        }

        public void alignWidgets() {
        }

        public void setWidth(int newWidth) {
            super.setWidth(newWidth);
            if (newWidth <= 0) {
                return;
            }
            int farRight = newWidth - 8;
            int yOff = (this.height - EntityIconSettingsScreen.this.getTheme().getFontHeight()) / 2 + 1;
            double size = 16.0;
            this.hideButton.setForceButtonSize(false);
            this.hideButton.setPosAndSize(farRight - 8, 1, (int)size, (int)size);
            if (EntityIconSettingsScreen.this.showCreationButton) {
                this.createButton.setPosAndSize(farRight - 8 - (int)size, 1, (int)size, (int)size);
            }
            this.nameField.setPos(17, yOff);
            this.nameField.setText((Component)Component.translatable((String)((EntityType)this.value).getDescriptionId()));
            this.nameField.setHeight(EntityIconSettingsScreen.this.getTheme().getFontHeight() + 2);
        }
    }
}

