/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.entity.ai.brain.TuffGolemBrain;
import com.faboslav.friendsandfoes.common.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.common.entity.animation.TuffGolemAnimations;
import com.faboslav.friendsandfoes.common.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationHolder;
import com.faboslav.friendsandfoes.common.entity.pose.TuffGolemEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.util.MovementUtil;
import com.faboslav.friendsandfoes.common.util.particle.ParticleSpawner;
import com.faboslav.friendsandfoes.common.versions.VersionedEntity;
import com.faboslav.friendsandfoes.common.versions.VersionedEntitySpawnReason;
import com.faboslav.friendsandfoes.common.versions.VersionedInteractionResult;
import com.faboslav.friendsandfoes.common.versions.VersionedNbt;
import com.faboslav.friendsandfoes.common.versions.VersionedProfilerProvider;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class TuffGolemEntity
extends AbstractGolem
implements AnimatedEntity {
    private static final EntityDataAccessor<String> COLOR = SynchedEntityData.defineId(TuffGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Pose> PREV_POSE = SynchedEntityData.defineId(TuffGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.POSE);
    private static final EntityDataAccessor<Integer> POSE_TICKS = SynchedEntityData.defineId(TuffGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_GLUED = SynchedEntityData.defineId(TuffGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<CompoundTag> HOME = SynchedEntityData.defineId(TuffGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private static final float MOVEMENT_SPEED = 0.225f;
    private static final float MOVEMENT_SPEED_WITH_ITEM = 0.175f;
    private static final int TUFF_HEAL_AMOUNT = 5;
    private static final int INACTIVE_TICKS_AFTER_SPAWN = 200;
    private static final String COLOR_NBT_NAME = "Color";
    private static final String PREV_POSE_NBT_NAME = "PrevPose";
    private static final String POSE_NBT_NAME = "Pose";
    private static final String IS_GLUED_NBT_NAME = "IsGlued";
    private static final String HOME_NBT_NAME = "Home";
    private static final String HOME_NBT_NAME_X = "x";
    private static final String HOME_NBT_NAME_Y = "y";
    private static final String HOME_NBT_NAME_Z = "z";
    private static final String HOME_NBT_NAME_YAW = "yaw";
    private int inactiveTicksAfterSpawn = 0;
    private AnimationContextTracker animationContextTracker;

    @Override
    public AnimationContextTracker getAnimationContextTracker() {
        if (this.animationContextTracker == null) {
            this.animationContextTracker = new AnimationContextTracker();
            for (AnimationHolder animation : this.getTrackedAnimations()) {
                this.animationContextTracker.add(animation);
            }
        }
        return this.animationContextTracker;
    }

    @Override
    public ArrayList<AnimationHolder> getTrackedAnimations() {
        return TuffGolemAnimations.ANIMATIONS;
    }

    @Override
    public AnimationHolder getMovementAnimation() {
        if (this.isHoldingItem()) {
            return TuffGolemAnimations.WALK_WITH_ITEM;
        }
        return TuffGolemAnimations.WALK;
    }

    @Override
    public int getCurrentAnimationTick() {
        return (Integer)this.entityData.get(POSE_TICKS);
    }

    @Override
    public void setCurrentAnimationTick(int keyframeAnimationTicks) {
        this.entityData.set(POSE_TICKS, (Object)keyframeAnimationTicks);
    }

    public TuffGolemEntity(EntityType<? extends TuffGolemEntity> entityType, Level world) {
        super(entityType, world);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        SpawnGroupData superEntityData = super.finalizeSpawn(world, difficulty, spawnReason, entityData);
        if (spawnReason == VersionedEntitySpawnReason.MOB_SUMMONED || spawnReason == VersionedEntitySpawnReason.COMMAND) {
            float randomSpawnYaw = 90.0f * (float)this.getRandom().nextIntBetweenInclusive(0, 3);
            this.setSpawnYaw(randomSpawnYaw);
        }
        this.setPrevPose(TuffGolemEntityPose.STANDING.get());
        this.setPoseWithoutPrevPose(TuffGolemEntityPose.STANDING.get());
        this.setHome(this.getNewHome());
        TuffGolemBrain.setSleepCooldown(this);
        this.inactiveTicksAfterSpawn = 200;
        return superEntityData;
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return TuffGolemBrain.create(dynamic);
    }

    public Brain<TuffGolemEntity> getBrain() {
        return super.getBrain();
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    protected void customServerAiStep() {
        ServerLevel level = (ServerLevel)this.level();
        ProfilerFiller profiler = VersionedProfilerProvider.getProfiler((Entity)this);
        profiler.push("tuffGolemBrain");
        this.getBrain().tick(level, (LivingEntity)this);
        profiler.pop();
        profiler.push("tuffGolemActivityUpdate");
        TuffGolemBrain.updateActivities(this);
        profiler.pop();
        super.customServerAiStep();
    }

    public static AttributeSupplier.Builder createTuffGolemAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, (double)0.225f).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COLOR, (Object)Color.RED.getName());
        builder.define(PREV_POSE, (Object)TuffGolemEntityPose.STANDING.get());
        builder.define(POSE_TICKS, (Object)0);
        builder.define(IS_GLUED, (Object)false);
        builder.define(HOME, (Object)new CompoundTag());
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putString(COLOR_NBT_NAME, this.getColor().getName());
        nbt.putString(PREV_POSE_NBT_NAME, this.getPrevPose().name());
        nbt.putString(POSE_NBT_NAME, this.getPose().name());
        nbt.putBoolean(IS_GLUED_NBT_NAME, this.isGlued());
        nbt.put(HOME_NBT_NAME, (Tag)this.getHome());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        String savedPose;
        String prevSavedPose;
        super.readAdditionalSaveData(nbt);
        this.setColor(Color.fromName(VersionedNbt.getString(nbt, COLOR_NBT_NAME, Color.RED.getName())));
        this.setGlued(VersionedNbt.getBoolean(nbt, IS_GLUED_NBT_NAME, false));
        this.setHome(VersionedNbt.getCompound(nbt, HOME_NBT_NAME));
        if (this.isAtHomePos()) {
            this.setSpawnYaw(this.getHomeYaw());
        }
        if ((prevSavedPose = VersionedNbt.getString(nbt, PREV_POSE_NBT_NAME, "")) != "") {
            this.setPrevPose(Pose.valueOf((String)prevSavedPose));
        }
        if ((savedPose = VersionedNbt.getString(nbt, POSE_NBT_NAME, "")) != "") {
            this.setPoseWithoutPrevPose(Pose.valueOf((String)savedPose));
            Pose entityPose = Pose.valueOf((String)savedPose);
            if (!(this.level().isClientSide() || entityPose != TuffGolemEntityPose.SLEEPING.get() && entityPose != TuffGolemEntityPose.SLEEPING_WITH_ITEM.get())) {
                this.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
                this.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
                TuffGolemBrain.resetSleepCooldown(this);
            } else {
                this.setPoseWithoutPrevPose(entityPose);
            }
        }
    }

    private SoundEvent getGlueOnSound() {
        return (SoundEvent)FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_GLUE_ON.get();
    }

    private void playGlueOnSound() {
        this.playSound(this.getGlueOnSound(), 1.0f, 1.0f);
    }

    private SoundEvent getGlueOffSound() {
        return (SoundEvent)FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_GLUE_OFF.get();
    }

    private void playGlueOffSound() {
        this.playSound(this.getGlueOffSound(), 1.0f, 1.0f);
    }

    public SoundEvent getMoveSound() {
        return (SoundEvent)FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_MOVE.get();
    }

    public void playMoveSound() {
        this.playSound(this.getMoveSound(), 1.0f, 1.05f + this.getRandom().nextFloat() * 0.05f);
    }

    public SoundEvent getHoldItemSound() {
        return (SoundEvent)FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_HOLD_ITEM.get();
    }

    public void playHoldItemSound() {
        this.playSound(this.getHoldItemSound(), 1.0f, 1.05f + this.getRandom().nextFloat() * 0.05f);
    }

    public SoundEvent getDropItemSound() {
        return (SoundEvent)FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_DROP_ITEM.get();
    }

    public void playDropItemSound() {
        this.playSound(this.getDropItemSound(), 1.0f, 1.05f + this.getRandom().nextFloat() * 0.05f);
    }

    private SoundEvent getRepairSound() {
        return (SoundEvent)FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_REPAIR.get();
    }

    private void playRepairSound() {
        this.playSound(this.getRepairSound(), 1.0f, 1.0f + (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f);
    }

    public SoundEvent getWakeSound() {
        return (SoundEvent)FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_WAKE.get();
    }

    public void playWakeSound() {
        this.playSound(this.getWakeSound(), 1.0f, 1.05f + this.getRandom().nextFloat() * 0.05f);
    }

    public SoundEvent getSleepSound() {
        return (SoundEvent)FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_SLEEP.get();
    }

    public void playSleepSound() {
        this.playSound(this.getSleepSound(), 1.0f, 1.05f + this.getRandom().nextFloat() * 0.05f);
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_HURT.get();
    }

    protected void playHurtSound(DamageSource source) {
        this.ambientSoundTime = -this.getAmbientSoundInterval();
        this.playSound(this.getHurtSound(source), 2.0f, 0.7f + this.getRandom().nextFloat() * 0.15f);
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        if (this.isInSleepingPose() || state.liquid()) {
            return;
        }
        BlockState blockState = this.level().getBlockState(pos.above());
        SoundType blockSoundGroup = blockState.is(BlockTags.INSIDE_STEP_SOUND_BLOCKS) ? blockState.getSoundType() : state.getSoundType();
        this.playSound((SoundEvent)FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_STEP.get(), blockSoundGroup.getVolume(), 0.75f + this.getRandom().nextFloat() * 0.15f);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        Item itemInHand = itemStack.getItem();
        boolean interactionResult = false;
        if (itemInHand == Items.TUFF) {
            interactionResult = this.tryToInteractMobWithTuff(player, itemStack);
        } else if (itemInHand instanceof DyeItem) {
            interactionResult = this.tryToInteractMobWithDye(player, itemStack);
        } else if (itemInHand instanceof HoneycombItem) {
            interactionResult = this.tryToInteractMobWithHoneycomb(player, itemStack);
        } else if (itemInHand instanceof AxeItem) {
            interactionResult = this.tryToInteractMobWithAxe(player, hand, itemStack);
        }
        if (!interactionResult) {
            interactionResult = this.tryToInteractMobWithItem(player, itemStack);
        }
        if (interactionResult) {
            this.gameEvent((Holder)GameEvent.ENTITY_INTERACT, (Entity)this);
            return VersionedInteractionResult.success((Entity)this);
        }
        return super.mobInteract(player, hand);
    }

    private boolean tryToInteractMobWithTuff(Player player, ItemStack itemStack) {
        if (this.getHealth() >= this.getMaxHealth()) {
            return false;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.heal(5.0f);
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            this.playRepairSound();
        }
        return true;
    }

    private boolean tryToInteractMobWithDye(Player player, ItemStack itemStack) {
        Color usedColor = Color.fromDyeColor(((DyeItem)itemStack.getItem()).getDyeColor());
        if (this.getColor() == usedColor) {
            return false;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.setColor(usedColor);
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            this.playSound(SoundEvents.DYE_USE, 1.0f, 1.0f);
        }
        return true;
    }

    private boolean tryToInteractMobWithHoneycomb(Player player, ItemStack itemStack) {
        if (this.isGlued()) {
            return false;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.setGlued(true);
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            this.playGlueOnSound();
            ParticleSpawner.spawnParticles((LivingEntity)this, (ParticleOptions)ParticleTypes.WAX_ON, 7, 1.0);
        }
        return true;
    }

    private boolean tryToInteractMobWithAxe(Player player, InteractionHand hand, ItemStack itemStack) {
        if (!this.isGlued()) {
            return false;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.setGlued(false);
            this.playGlueOffSound();
            ParticleSpawner.spawnParticles((LivingEntity)this, (ParticleOptions)ParticleTypes.WAX_OFF, 7, 1.0);
            if (player.getAbilities().instabuild) {
                itemStack.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)hand));
            }
        }
        return true;
    }

    private boolean tryToInteractMobWithItem(Player player, ItemStack itemStack) {
        if (this.getItemBySlot(EquipmentSlot.MAINHAND).getItem() == Items.AIR && itemStack.getItem() == Items.AIR || itemStack.getItem() instanceof SpawnEggItem || this.isAnyKeyframeAnimationRunning()) {
            return false;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MovementUtil.stopMovement((Mob)this);
            if (this.isHoldingItem()) {
                if (!player.getAbilities().instabuild) {
                    VersionedEntity.spawnAtLocation((Entity)this, this.getItemBySlot(EquipmentSlot.MAINHAND));
                }
                this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                this.startStanding();
                if (this.isInSleepingPose()) {
                    this.playWakeSound();
                } else {
                    this.playDropItemSound();
                }
            } else {
                ItemStack itemsStackToBeEquipped = itemStack.copy();
                if (!player.getAbilities().instabuild) {
                    itemStack.shrink(1);
                }
                itemsStackToBeEquipped.setCount(1);
                this.setItemSlot(EquipmentSlot.MAINHAND, itemsStackToBeEquipped);
                this.startStandingWithItem();
                this.playHoldItemSound();
            }
        }
        return true;
    }

    public void setColor(Color color) {
        this.entityData.set(COLOR, (Object)color.getName());
    }

    public Color getColor() {
        return Color.fromName((String)this.entityData.get(COLOR));
    }

    public void setPose(Pose pose) {
        if (this.level().isClientSide()) {
            return;
        }
        this.setPrevPose(this.getPose());
        super.setPose(pose);
    }

    public void setPoseWithoutPrevPose(Pose pose) {
        if (this.level().isClientSide()) {
            return;
        }
        super.setPose(pose);
    }

    public void setPrevPose(Pose pose) {
        if (this.level().isClientSide()) {
            return;
        }
        this.entityData.set(PREV_POSE, (Object)pose);
    }

    public Pose getPrevPose() {
        return (Pose)this.entityData.get(PREV_POSE);
    }

    public boolean isInPose(TuffGolemEntityPose pose) {
        return this.getPose() == pose.get();
    }

    public boolean wasInPose(TuffGolemEntityPose pose) {
        return this.getPrevPose() == pose.get();
    }

    public boolean isInStandingPose() {
        return this.isInPose(TuffGolemEntityPose.STANDING) || this.isInPose(TuffGolemEntityPose.STANDING_WITH_ITEM);
    }

    public boolean isInSleepingPose() {
        return this.isInPose(TuffGolemEntityPose.SLEEPING) || this.isInPose(TuffGolemEntityPose.SLEEPING_WITH_ITEM);
    }

    public boolean isInHoldingItemPose() {
        return this.isInPose(TuffGolemEntityPose.STANDING_WITH_ITEM) || this.isInPose(TuffGolemEntityPose.SLEEPING_WITH_ITEM);
    }

    public void setGlued(boolean isGlued) {
        this.entityData.set(IS_GLUED, (Object)isGlued);
    }

    public boolean isGlued() {
        return (Boolean)this.entityData.get(IS_GLUED);
    }

    public CompoundTag getNewHome() {
        CompoundTag home = new CompoundTag();
        home.putDouble(HOME_NBT_NAME_X, this.position().x());
        home.putDouble(HOME_NBT_NAME_Y, this.position().y());
        home.putDouble(HOME_NBT_NAME_Z, this.position().z());
        home.putFloat(HOME_NBT_NAME_YAW, this.yBodyRot);
        return home;
    }

    public void setHome(CompoundTag home) {
        this.entityData.set(HOME, (Object)home);
    }

    public CompoundTag getHome() {
        return (CompoundTag)this.entityData.get(HOME);
    }

    public Vec3 getHomePos() {
        CompoundTag nbt = this.getHome();
        return new Vec3(VersionedNbt.getDouble(nbt, HOME_NBT_NAME_X, this.position().x()), VersionedNbt.getDouble(nbt, HOME_NBT_NAME_Y, this.position().y()), VersionedNbt.getDouble(nbt, HOME_NBT_NAME_Z, this.position().z()));
    }

    public float getHomeYaw() {
        CompoundTag nbt = this.getHome();
        return VersionedNbt.getFloat(nbt, HOME_NBT_NAME_YAW, 0.0f);
    }

    public boolean isAtHomePos() {
        return this.distanceToSqr(this.getHomePos()) < 0.1;
    }

    public boolean isCloseToHomePos(float distance) {
        return this.distanceToSqr(this.getHomePos()) < (double)distance;
    }

    public boolean isAtHomeYaw() {
        return this.yRotO == this.getHomeYaw() && this.getYRot() == this.getHomeYaw() && this.yBodyRotO == this.getHomeYaw() && this.getVisualRotationYInDegrees() == this.getHomeYaw() && this.yHeadRotO == this.getHomeYaw() && this.getYHeadRot() == this.getHomeYaw();
    }

    public boolean isAtHome() {
        return this.isAtHomePos() && this.isAtHomeYaw();
    }

    public boolean isHoldingItem() {
        return this.getItemBySlot(EquipmentSlot.MAINHAND).getItem() != Items.AIR;
    }

    public boolean isShowingItem() {
        return this.isHoldingItem() && this.isInHoldingItemPose();
    }

    public boolean isNotImmobilized() {
        return this.getCurrentAnimationTick() == 0 && this.inactiveTicksAfterSpawn == 0 && !this.isGlued() && !this.isInSleepingPose();
    }

    public void startSleeping() {
        if (this.isInPose(TuffGolemEntityPose.SLEEPING)) {
            return;
        }
        this.playSleepSound();
        this.setPose(TuffGolemEntityPose.SLEEPING.get());
    }

    public void startSleepingWithItem() {
        if (this.isInPose(TuffGolemEntityPose.SLEEPING_WITH_ITEM)) {
            return;
        }
        this.playSleepSound();
        this.setPose(TuffGolemEntityPose.SLEEPING_WITH_ITEM.get());
    }

    public void startStanding() {
        if (this.isInPose(TuffGolemEntityPose.STANDING)) {
            return;
        }
        this.setPose(TuffGolemEntityPose.STANDING.get());
    }

    public void startStandingWithItem() {
        if (this.isInPose(TuffGolemEntityPose.STANDING_WITH_ITEM)) {
            return;
        }
        this.setPose(TuffGolemEntityPose.STANDING_WITH_ITEM.get());
    }

    public void tick() {
        if (!this.level().isClientSide() && !FriendsAndFoes.getConfig().enableTuffGolem) {
            this.discard();
        }
        if (!this.level().isClientSide() && this.inactiveTicksAfterSpawn > 0) {
            --this.inactiveTicksAfterSpawn;
        }
        this.updateKeyframeAnimations();
        super.tick();
    }

    public boolean isPushable() {
        return !this.isSleeping();
    }

    private void updateKeyframeAnimations() {
        AnimationHolder animationToStart;
        if (!this.level().isClientSide()) {
            this.updateCurrentAnimationTick();
        }
        if ((animationToStart = this.getAnimationByPose()) != null && !this.isKeyframeAnimationRunning(animationToStart)) {
            if (!this.level().isClientSide()) {
                this.setCurrentAnimationTick(animationToStart.get().lengthInTicks());
            }
            this.startKeyframeAnimation(animationToStart);
        }
    }

    private void startKeyframeAnimation(AnimationHolder animationToStart) {
        for (AnimationHolder animation : this.getTrackedAnimations()) {
            if (animation == animationToStart) continue;
            this.stopKeyframeAnimation(animation);
        }
        this.startKeyframeAnimation(animationToStart, this.tickCount);
    }

    @Override
    @Nullable
    public AnimationHolder getAnimationByPose() {
        Pose prevPose = this.getPrevPose();
        Pose pose = this.getPose();
        if (pose == prevPose) {
            return null;
        }
        AnimationHolder animationHolder = null;
        if (this.wasInPose(TuffGolemEntityPose.STANDING)) {
            if (this.isInPose(TuffGolemEntityPose.STANDING_WITH_ITEM)) {
                animationHolder = TuffGolemAnimations.SHOW_ITEM;
            } else if (this.isInPose(TuffGolemEntityPose.SLEEPING)) {
                animationHolder = TuffGolemAnimations.SLEEP;
            }
        } else if (this.wasInPose(TuffGolemEntityPose.STANDING_WITH_ITEM)) {
            if (this.isInPose(TuffGolemEntityPose.STANDING)) {
                animationHolder = TuffGolemAnimations.HIDE_ITEM;
            } else if (this.isInPose(TuffGolemEntityPose.SLEEPING_WITH_ITEM)) {
                animationHolder = TuffGolemAnimations.SLEEP_WITH_ITEM;
            }
        } else if (this.wasInPose(TuffGolemEntityPose.SLEEPING)) {
            if (this.isInPose(TuffGolemEntityPose.SLEEPING_WITH_ITEM)) {
                animationHolder = TuffGolemAnimations.SHOW_ITEM;
            } else if (this.isInPose(TuffGolemEntityPose.STANDING_WITH_ITEM)) {
                animationHolder = TuffGolemAnimations.WAKE_AND_SHOW_ITEM;
            } else if (this.isInPose(TuffGolemEntityPose.STANDING)) {
                animationHolder = TuffGolemAnimations.WAKE;
            }
        } else if (this.wasInPose(TuffGolemEntityPose.SLEEPING_WITH_ITEM)) {
            if (this.isInPose(TuffGolemEntityPose.SLEEPING)) {
                animationHolder = TuffGolemAnimations.HIDE_ITEM;
            } else if (this.isInPose(TuffGolemEntityPose.STANDING)) {
                animationHolder = TuffGolemAnimations.WAKE_AND_HIDE_ITEM;
            } else if (this.isInPose(TuffGolemEntityPose.STANDING_WITH_ITEM)) {
                animationHolder = TuffGolemAnimations.WAKE_WITH_ITEM;
            }
        }
        return animationHolder;
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        Level level = this.level();
        Entity attacker = damageSource.getEntity();
        if (attacker instanceof LightningBolt || damageSource == this.damageSources().sweetBerryBush()) {
            return false;
        }
        if (!this.level().isClientSide() && this.isInSleepingPose()) {
            if (this.isHoldingItem()) {
                this.startStandingWithItem();
                if (this.isInSleepingPose()) {
                    this.playWakeSound();
                } else {
                    this.playMoveSound();
                }
            } else {
                this.startStanding();
                if (this.isInSleepingPose()) {
                    this.playWakeSound();
                } else {
                    this.playMoveSound();
                }
            }
        }
        return super.hurt(damageSource, amount);
    }

    public boolean canBeLeashed() {
        return super.canBeLeashed() && !this.isInSleepingPose();
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)this.getEyeHeight() * 0.45, 0.0);
    }

    public float getSpeed() {
        return this.isHoldingItem() ? 0.175f : 0.225f;
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource damageSource, boolean recentlyHit) {
        super.dropCustomDeathLoot(level, damageSource, recentlyHit);
        if (this.isHoldingItem()) {
            VersionedEntity.spawnAtLocation((Entity)this, this.getItemBySlot(EquipmentSlot.MAINHAND));
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        }
    }

    public float getMovementSpeedModifier() {
        if (this.isHoldingItem()) {
            return 1.0f;
        }
        return 0.7777778f;
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    public void setSpawnYaw(float yaw) {
        this.yRotO = yaw;
        this.setYRot(yaw);
        this.yBodyRotO = yaw;
        this.setYBodyRot(yaw);
        this.yHeadRotO = yaw;
        this.setYHeadRot(yaw);
    }

    public static enum Color {
        RED("red"),
        BLACK("black"),
        BLUE("blue"),
        BROWN("brown"),
        CYAN("cyan"),
        GRAY("gray"),
        GREEN("green"),
        LIGHT_BLUE("light_blue"),
        LIGHT_GRAY("light_gray"),
        LIME("lime"),
        MAGENTA("magenta"),
        ORANGE("orange"),
        PINK("pink"),
        PURPLE("purple"),
        WHITE("white"),
        YELLOW("yellow");

        private final String name;

        private Color(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        private static Color fromName(String name) {
            Color[] colors;
            for (Color color : colors = Color.values()) {
                if (!color.name.equals(name)) continue;
                return color;
            }
            return RED;
        }

        public static Color fromDyeColor(DyeColor dyeColor) {
            return switch (dyeColor) {
                case DyeColor.BLACK -> BLACK;
                case DyeColor.BLUE -> BLUE;
                case DyeColor.BROWN -> BROWN;
                case DyeColor.CYAN -> CYAN;
                case DyeColor.GRAY -> GRAY;
                case DyeColor.GREEN -> GREEN;
                case DyeColor.LIGHT_BLUE -> LIGHT_BLUE;
                case DyeColor.LIGHT_GRAY -> LIGHT_GRAY;
                case DyeColor.LIME -> LIME;
                case DyeColor.MAGENTA -> MAGENTA;
                case DyeColor.ORANGE -> ORANGE;
                case DyeColor.PINK -> PINK;
                case DyeColor.PURPLE -> PURPLE;
                case DyeColor.WHITE -> WHITE;
                case DyeColor.YELLOW -> YELLOW;
                default -> RED;
            };
        }

        public static Color fromWool(Block block) {
            if (block == Blocks.BLACK_WOOL) {
                return BLACK;
            }
            if (block == Blocks.BLUE_WOOL) {
                return BLUE;
            }
            if (block == Blocks.BROWN_WOOL) {
                return BROWN;
            }
            if (block == Blocks.CYAN_WOOL) {
                return CYAN;
            }
            if (block == Blocks.GRAY_WOOL) {
                return GRAY;
            }
            if (block == Blocks.GREEN_WOOL) {
                return GREEN;
            }
            if (block == Blocks.LIGHT_BLUE_WOOL) {
                return LIGHT_BLUE;
            }
            if (block == Blocks.LIGHT_GRAY_WOOL) {
                return LIGHT_GRAY;
            }
            if (block == Blocks.LIME_WOOL) {
                return LIME;
            }
            if (block == Blocks.MAGENTA_WOOL) {
                return MAGENTA;
            }
            if (block == Blocks.ORANGE_WOOL) {
                return ORANGE;
            }
            if (block == Blocks.PINK_WOOL) {
                return PINK;
            }
            if (block == Blocks.PURPLE_WOOL) {
                return PURPLE;
            }
            if (block == Blocks.WHITE_WOOL) {
                return WHITE;
            }
            if (block == Blocks.YELLOW_WOOL) {
                return YELLOW;
            }
            return RED;
        }
    }
}

