/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.block;

import com.faboslav.friendsandfoes.common.block.CopperButtonBlock;
import com.faboslav.friendsandfoes.common.block.FriendsAndFoesOxidizable;
import com.faboslav.friendsandfoes.common.block.OnUseOxidizable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public final class OxidizableButtonBlock
extends CopperButtonBlock
implements FriendsAndFoesOxidizable {
    private final WeatheringCopper.WeatherState oxidationLevel;

    public OxidizableButtonBlock(WeatheringCopper.WeatherState oxidationLevel, int pressTicks, BlockBehaviour.Properties properties) {
        super(pressTicks, properties);
        this.oxidationLevel = oxidationLevel;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.changeOverTime(state, world, pos, random);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return this.getAge().ordinal() < WeatheringCopper.WeatherState.OXIDIZED.ordinal();
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.oxidationLevel;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        InteractionResult actionResult = OnUseOxidizable.onOxidizableUse(state, world, pos, player, hit);
        if (actionResult.consumesAction()) {
            return actionResult;
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }
}

