/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.sync;

import com.mrcrayfish.framework.api.sync.DataSerializer;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class Serializers {
    public static final DataSerializer<Boolean> BOOLEAN = new DataSerializer<Boolean>(ByteBufCodecs.BOOL, (val, provider) -> ByteTag.valueOf((boolean)val), (tag, provider) -> ((ByteTag)tag).getAsByte() != 0);
    public static final DataSerializer<Byte> BYTE = new DataSerializer<Byte>(ByteBufCodecs.BYTE, (val, provider) -> ByteTag.valueOf((byte)val), (tag, provider) -> ((ByteTag)tag).getAsByte());
    public static final DataSerializer<Short> SHORT = new DataSerializer<Short>(ByteBufCodecs.SHORT, (val, provider) -> ShortTag.valueOf((short)val), (tag, provider) -> ((ShortTag)tag).getAsShort());
    public static final DataSerializer<Integer> INTEGER = new DataSerializer<Integer>(ByteBufCodecs.INT, (val, provider) -> IntTag.valueOf((int)val), (tag, provider) -> ((IntTag)tag).getAsInt());
    public static final DataSerializer<Long> LONG = new DataSerializer<Long>(ByteBufCodecs.VAR_LONG, (val, provider) -> LongTag.valueOf((long)val), (tag, provider) -> ((LongTag)tag).getAsLong());
    public static final DataSerializer<Float> FLOAT = new DataSerializer<Float>(ByteBufCodecs.FLOAT, (val, provider) -> FloatTag.valueOf((float)val.floatValue()), (tag, provider) -> Float.valueOf(((FloatTag)tag).getAsFloat()));
    public static final DataSerializer<Double> DOUBLE = new DataSerializer<Double>(ByteBufCodecs.DOUBLE, (val, provider) -> DoubleTag.valueOf((double)val), (tag, provider) -> ((DoubleTag)tag).getAsDouble());
    public static final DataSerializer<String> STRING = new DataSerializer<String>(ByteBufCodecs.STRING_UTF8, (val, provider) -> StringTag.valueOf((String)val), (tag, provider) -> tag.getAsString());
    public static final DataSerializer<CompoundTag> COMPOUND_TAG = new DataSerializer<CompoundTag>(ByteBufCodecs.COMPOUND_TAG, (val, provider) -> val, (tag, provider) -> (CompoundTag)tag);
    public static final DataSerializer<Optional<CompoundTag>> OPTIONAL_COMPOUND_TAG = new DataSerializer<Optional>(ByteBufCodecs.OPTIONAL_COMPOUND_TAG, (val, provider) -> val.orElse(null), (tag, provider) -> tag != null ? Optional.of((CompoundTag)tag) : Optional.empty());
    public static final DataSerializer<BlockPos> BLOCK_POS = new DataSerializer<BlockPos>(BlockPos.STREAM_CODEC, (val, provider) -> LongTag.valueOf((long)val.asLong()), (tag, provider) -> BlockPos.of((long)((LongTag)tag).getAsLong()));
    public static final DataSerializer<UUID> UUID = new DataSerializer<UUID>(UUIDUtil.STREAM_CODEC, (val, provider) -> NbtUtils.createUUID((UUID)val), (tag, provider) -> NbtUtils.loadUUID((Tag)tag));
    public static final DataSerializer<ItemStack> ITEM_STACK = new DataSerializer<ItemStack>(ItemStack.STREAM_CODEC, ItemStack::saveOptional, (tag, provider) -> ItemStack.parse((HolderLookup.Provider)provider, (Tag)tag).orElse(ItemStack.EMPTY));
    public static final DataSerializer<ItemStack> ITEM_STACK_NON_EMPTY = new DataSerializer<ItemStack>(ItemStack.STREAM_CODEC, ItemStack::saveOptional, (tag, provider) -> ItemStack.parse((HolderLookup.Provider)provider, (Tag)tag).orElse(ItemStack.EMPTY));
    public static final DataSerializer<ResourceLocation> RESOURCE_LOCATION = new DataSerializer<ResourceLocation>(ResourceLocation.STREAM_CODEC, (val, provider) -> StringTag.valueOf((String)val.toString()), (tag, provider) -> ResourceLocation.tryParse((String)tag.getAsString()));
}

