/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.data.recipes.builder;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoCookingTimes;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoFireType;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.residue.ResidueChance;
import com.stal111.forbidden_arcanus.common.item.crafting.ClibanoRecipe;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerDefinition;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.Holder;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClibanoRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final CookingBookCategory bookCategory;
    private final Item result;
    private final ItemStack stackResult;
    private final Either<Ingredient, Pair<Ingredient, Ingredient>> ingredients;
    private final float experience;
    private final int cookingTime;
    @Nullable
    private ResidueChance residueChance;
    private ClibanoFireType requiredFireType = ClibanoFireType.FIRE;
    @Nullable
    private Holder<EnhancerDefinition> requiredEnhancer;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;

    public ClibanoRecipeBuilder(RecipeCategory recipeCategory, CookingBookCategory bookCategory, ItemStack result, Either<Ingredient, Pair<Ingredient, Ingredient>> ingredients, float experience, int cookingTime) {
        this.category = recipeCategory;
        this.bookCategory = bookCategory;
        this.result = result.getItem();
        this.stackResult = result;
        this.ingredients = ingredients;
        this.experience = experience;
        this.cookingTime = cookingTime;
    }

    @NotNull
    public RecipeBuilder unlockedBy(@NotNull String name, @NotNull Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    @NotNull
    public RecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public ClibanoRecipeBuilder residue(ResidueChance residueChance) {
        this.residueChance = residueChance;
        return this;
    }

    public ClibanoRecipeBuilder fireType(ClibanoFireType fireType) {
        this.requiredFireType = fireType;
        return this;
    }

    public ClibanoRecipeBuilder enhancer(Holder<EnhancerDefinition> enhancer) {
        this.requiredEnhancer = enhancer;
        return this;
    }

    @NotNull
    public Item getResult() {
        return this.result;
    }

    public void save(@NotNull RecipeOutput recipeOutput, @NotNull ResourceLocation id) {
        this.ensureValid(id);
        Advancement.Builder advancement$builder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        ClibanoRecipe recipe = new ClibanoRecipe(Objects.requireNonNullElse(this.group, ""), this.bookCategory, this.ingredients, this.stackResult, this.experience, ClibanoCookingTimes.of(this.cookingTime), Optional.ofNullable(this.residueChance), this.requiredFireType, Optional.ofNullable(this.requiredEnhancer));
        recipeOutput.accept(id, (Recipe)recipe, advancement$builder.build(id.withPrefix("recipes/" + this.category.getFolderName() + "/")));
    }

    private void ensureValid(ResourceLocation pId) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(pId));
        }
    }
}

