/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.data;

import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceType;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import com.stal111.forbidden_arcanus.core.init.ModEntities;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import com.stal111.forbidden_arcanus.data.ModEnchantments;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class LangProvider
extends LanguageProvider {
    public static final Map<DyeColor, String> COLOR_TO_STRING = (Map)Util.make(new EnumMap(DyeColor.class), map -> {
        map.put(DyeColor.WHITE, "White");
        map.put(DyeColor.ORANGE, "Orange");
        map.put(DyeColor.MAGENTA, "Magenta");
        map.put(DyeColor.LIGHT_BLUE, "Light Blue");
        map.put(DyeColor.YELLOW, "Yellow");
        map.put(DyeColor.LIME, "Lime");
        map.put(DyeColor.PINK, "Pink");
        map.put(DyeColor.GRAY, "Gray");
        map.put(DyeColor.LIGHT_GRAY, "Light Gray");
        map.put(DyeColor.CYAN, "Cyan");
        map.put(DyeColor.PURPLE, "Purple");
        map.put(DyeColor.BLUE, "Blue");
        map.put(DyeColor.BROWN, "Brown");
        map.put(DyeColor.GREEN, "Green");
        map.put(DyeColor.RED, "Red");
        map.put(DyeColor.BLACK, "Black");
    });

    public LangProvider(PackOutput output) {
        super(output, "forbidden_arcanus", "en_us");
    }

    protected void addTranslations() {
        this.add(Util.makeDescriptionId((String)"itemGroup", (ResourceLocation)ForbiddenArcanus.location("main")), "Forbidden & Arcanus");
        this.addModifier("eternal", "Eternal");
        this.addModifier("fiery", "Fiery");
        this.addModifier("magnetized", "Magnetized");
        this.addModifier("demolishing", "Demolishing");
        this.addModifier("aquatic", "Aquatic");
        this.addModifier("soulbound", "Soulbound");
        this.add("essence", EssenceType.AUREAL, "Aureal");
        this.add("essence", EssenceType.SOULS, "Souls");
        this.add("essence", EssenceType.BLOOD, "Blood");
        this.add("essence", EssenceType.EXPERIENCE, "Experience");
        this.add(Util.makeDescriptionId((String)"container", (ResourceLocation)ForbiddenArcanus.location("hephaestus_forge")), "Hephaestus Forge");
        this.add(Util.makeDescriptionId((String)"container", (ResourceLocation)ForbiddenArcanus.location("clibano")), "Clibano");
        this.addEntityType((Supplier)ModEntities.LOST_SOUL, "Lost Soul");
        this.addEntityType((Supplier)ModEntities.CORRUPT_LOST_SOUL, "Corrupt Lost Soul");
        this.addEntityType((Supplier)ModEntities.ENCHANTED_LOST_SOUL, "Enchanted Lost Soul");
        this.addEntityType((Supplier)ModEntities.DARK_TRADER, "Dark Trader");
        this.add(Util.makeDescriptionId((String)"enchantment", (ResourceLocation)ModEnchantments.SOUL_LOOTING.location()), "Soul Looting");
        this.addBlock((Supplier)ModBlocks.QUANTUM_CORE, "Quantum Core");
        this.addBlock((Supplier)ModBlocks.QUANTUM_INJECTOR, "Quantum Injector");
        this.addBlock((Supplier)ModBlocks.DARKSTONE, "Darkstone");
        this.addBlock((Supplier)ModBlocks.DARKSTONE_SLAB, "Darkstone Slab");
        this.addBlock((Supplier)ModBlocks.DARKSTONE_STAIRS, "Darkstone Stairs");
        this.addBlock((Supplier)ModBlocks.DARKSTONE_WALL, "Darkstone Wall");
        this.addBlock((Supplier)ModBlocks.POLISHED_DARKSTONE, "Polished Darkstone");
        this.addBlock((Supplier)ModBlocks.POLISHED_DARKSTONE_SLAB, "Polished Darkstone Slab");
        this.addBlock((Supplier)ModBlocks.POLISHED_DARKSTONE_STAIRS, "Polished Darkstone Stairs");
        this.addBlock((Supplier)ModBlocks.POLISHED_DARKSTONE_WALL, "Polished Darkstone Wall");
        this.addBlock((Supplier)ModBlocks.POLISHED_DARKSTONE_PRESSURE_PLATE, "Polished Darkstone Pressure Plate");
        this.addBlock((Supplier)ModBlocks.POLISHED_DARKSTONE_BUTTON, "Polished Darkstone Button");
        this.addBlock((Supplier)ModBlocks.CHISELED_POLISHED_DARKSTONE, "Chiseled Polished Darkstone");
        this.addBlock((Supplier)ModBlocks.GILDED_CHISELED_POLISHED_DARKSTONE, "Gilded Chiseled Polished Darkstone");
        this.addBlock((Supplier)ModBlocks.POLISHED_DARKSTONE_BRICKS, "Polished Darkstone Bricks");
        this.addBlock((Supplier)ModBlocks.POLISHED_DARKSTONE_BRICK_SLAB, "Polished Darkstone Brick Slab");
        this.addBlock((Supplier)ModBlocks.POLISHED_DARKSTONE_BRICK_STAIRS, "Polished Darkstone Brick Stairs");
        this.addBlock((Supplier)ModBlocks.POLISHED_DARKSTONE_BRICK_WALL, "Polished Darkstone Brick Wall");
        this.addBlock((Supplier)ModBlocks.CRACKED_POLISHED_DARKSTONE_BRICKS, "Cracked Polished Darkstone Bricks");
        this.addBlock((Supplier)ModBlocks.TILED_POLISHED_DARKSTONE_BRICKS, "Tiled Polished Darkstone Bricks");
        this.addBlock((Supplier)ModBlocks.ARCANE_POLISHED_DARKSTONE, "Arcane Polished Darkstone");
        this.addBlock((Supplier)ModBlocks.ARCANE_POLISHED_DARKSTONE_SLAB, "Arcane Polished Darkstone Slab");
        this.addBlock((Supplier)ModBlocks.ARCANE_POLISHED_DARKSTONE_STAIRS, "Arcane Polished Darkstone Stairs");
        this.addBlock((Supplier)ModBlocks.ARCANE_POLISHED_DARKSTONE_WALL, "Arcane Polished Darkstone Wall");
        this.addBlock((Supplier)ModBlocks.CHISELED_ARCANE_POLISHED_DARKSTONE, "Chiseled Arcane Polished Darkstone");
        this.addBlock((Supplier)ModBlocks.ARCANE_POLISHED_DARKSTONE_PILLAR, "Arcane Polished Darkstone Pillar");
        this.addBlock((Supplier)ModBlocks.DARKSTONE_PEDESTAL, "Darkstone Pedestal");
        this.addBlock((Supplier)ModBlocks.MAGNETIZED_DARKSTONE_PEDESTAL, "Magnetized Darkstone Pedestal");
        this.addBlock((Supplier)ModBlocks.CLIBANO_CORE, "Clibano Core");
        this.addBlock((Supplier)ModBlocks.HEPHAESTUS_FORGE_TIER_1, "Hephaestus Forge");
        this.addBlock((Supplier)ModBlocks.ARCANE_CRYSTAL_ORE, "Arcane Crystal Ore");
        this.addBlock((Supplier)ModBlocks.DEEPSLATE_ARCANE_CRYSTAL_ORE, "Deepslate Arcane Crystal Ore");
        this.addBlock((Supplier)ModBlocks.RUNIC_STONE, "Runic Stone");
        this.addBlock((Supplier)ModBlocks.RUNIC_DEEPSLATE, "Runic Deepslate");
        this.addBlock((Supplier)ModBlocks.RUNIC_DARKSTONE, "Runic Darkstone");
        this.addBlock((Supplier)ModBlocks.STELLA_ARCANUM, "Stella Arcanum");
        this.addBlock((Supplier)ModBlocks.ARCANE_CRYSTAL_BLOCK, "Arcane Crystal Block");
        this.addBlock((Supplier)ModBlocks.CORRUPTED_ARCANE_CRYSTAL_BLOCK, "Corrupted Arcane Crystal Block");
        this.addBlock((Supplier)ModBlocks.RUNE_BLOCK, "Rune Block");
        this.addBlock((Supplier)ModBlocks.STELLARITE_BLOCK, "Stellarite Block");
        this.addBlock((Supplier)ModBlocks.DEORUM_BLOCK, "Deorum Block");
        this.addBlock((Supplier)ModBlocks.OBSIDIANSTEEL_BLOCK, "Obsidiansteel Block");
        this.addBlock((Supplier)ModBlocks.ARCANE_CRYSTAL_OBELISK, "Arcane Crystal Obelisk");
        this.addBlock((Supplier)ModBlocks.CORRUPTED_ARCANE_CRYSTAL_OBELISK, "Corrupted Arcane Crystal Obelisk");
        this.addBlock((Supplier)ModBlocks.DEORUM_GLASS, "Deorum Glass");
        this.addBlock((Supplier)ModBlocks.RUNIC_GLASS, "Runic Glass");
        this.addBlock((Supplier)ModBlocks.DEORUM_GLASS_PANE, "Deorum Glass Pane");
        this.addBlock((Supplier)ModBlocks.RUNIC_GLASS_PANE, "Runic Glass Pane");
        this.addBlock((Supplier)ModBlocks.DEORUM_LANTERN, "Deorum Lantern");
        this.addBlock((Supplier)ModBlocks.DEORUM_SOUL_LANTERN, "Deorum Soul Lantern");
        this.addBlock((Supplier)ModBlocks.SOULLESS_SAND, "Soulless Sand");
        this.addBlock((Supplier)ModBlocks.SOULLESS_SANDSTONE, "Soulless Sandstone");
        this.addBlock((Supplier)ModBlocks.SOULLESS_SANDSTONE_SLAB, "Soulless Sandstone Slab");
        this.addBlock((Supplier)ModBlocks.SOULLESS_SANDSTONE_STAIRS, "Soulless Sandstone Stairs");
        this.addBlock((Supplier)ModBlocks.SOULLESS_SANDSTONE_WALL, "Soulless Sandstone Wall");
        this.addBlock((Supplier)ModBlocks.CUT_SOULLESS_SANDSTONE, "Cut Soulless Sandstone");
        this.addBlock((Supplier)ModBlocks.CUT_SOULLESS_SANDSTONE_SLAB, "Cut Soulless Sandstone Slab");
        this.addBlock((Supplier)ModBlocks.POLISHED_SOULLESS_SANDSTONE, "Polished Soulless Sandstone");
        this.addBlock((Supplier)ModBlocks.POLISHED_SOULLESS_SANDSTONE_SLAB, "Polished Soulless Sandstone Slab");
        this.addBlock((Supplier)ModBlocks.POLISHED_SOULLESS_SANDSTONE_STAIRS, "Polished Soulless Sandstone Stairs");
        this.addBlock((Supplier)ModBlocks.FUNGYSS, "Fungyss");
        this.addBlock((Supplier)ModBlocks.AURUM_SAPLING, "Aurum Sapling");
        this.addBlock((Supplier)ModBlocks.GROWING_EDELWOOD, "Growing Edelwood");
        this.addBlock((Supplier)ModBlocks.FUNGYSS_BLOCK, "Fungyss Block");
        this.addBlock((Supplier)ModBlocks.AURUM_LEAVES, "Aurum Leaves");
        this.addBlock((Supplier)ModBlocks.NUGGETY_AURUM_LEAVES, "Nuggety Aurum Leaves");
        this.addBlock((Supplier)ModBlocks.FUNGYSS_STEM, "Fungyss Stem");
        this.addBlock((Supplier)ModBlocks.AURUM_LOG, "Aurum Log");
        this.addBlock((Supplier)ModBlocks.EDELWOOD_LOG, "Edelwood Log");
        this.addBlock((Supplier)ModBlocks.CARVED_EDELWOOD_LOG, "Carved Edelwood Log");
        this.addBlock((Supplier)ModBlocks.EDELWOOD_BRANCH, "Edelwood Branch");
        this.addBlock((Supplier)ModBlocks.STRIPPED_AURUM_LOG, "Stripped Aurum Log");
        this.addBlock((Supplier)ModBlocks.FUNGYSS_HYPHAE, "Fungyss Hyphae");
        this.addBlock((Supplier)ModBlocks.AURUM_WOOD, "Aurum Wood");
        this.addBlock((Supplier)ModBlocks.STRIPPED_AURUM_WOOD, "Stripped Aurum Wood");
        this.addBlock((Supplier)ModBlocks.FUNGYSS_PLANKS, "Fungyss Planks");
        this.addBlock((Supplier)ModBlocks.AURUM_PLANKS, "Aurum Planks");
        this.addBlock((Supplier)ModBlocks.EDELWOOD_PLANKS, "Edelwood Planks");
        this.addBlock((Supplier)ModBlocks.ARCANE_EDELWOOD_PLANKS, "Arcane Edelwood Planks");
        this.addBlock((Supplier)ModBlocks.FUNGYSS_SLAB, "Fungyss Slab");
        this.addBlock((Supplier)ModBlocks.AURUM_SLAB, "Aurum Slab");
        this.addBlock((Supplier)ModBlocks.EDELWOOD_SLAB, "Edelwood Slab");
        this.addBlock((Supplier)ModBlocks.FUNGYSS_STAIRS, "Fungyss Stairs");
        this.addBlock((Supplier)ModBlocks.AURUM_STAIRS, "Aurum Stairs");
        this.addBlock((Supplier)ModBlocks.EDELWOOD_STAIRS, "Edelwood Stairs");
        this.addBlock((Supplier)ModBlocks.FUNGYSS_FENCE, "Fungyss Fence");
        this.addBlock((Supplier)ModBlocks.AURUM_FENCE, "Aurum Fence");
        this.addBlock((Supplier)ModBlocks.EDELWOOD_FENCE, "Edelwood Fence");
        this.addBlock((Supplier)ModBlocks.FUNGYSS_FENCE_GATE, "Fungyss Fence Gate");
        this.addBlock((Supplier)ModBlocks.AURUM_FENCE_GATE, "Aurum Fence Gate");
        this.addBlock((Supplier)ModBlocks.EDELWOOD_FENCE_GATE, "Edelwood Fence Gate");
        this.addBlock((Supplier)ModBlocks.DEORUM_DOOR, "Deorum Door");
        this.addBlock((Supplier)ModBlocks.FUNGYSS_DOOR, "Fungyss Door");
        this.addBlock((Supplier)ModBlocks.AURUM_DOOR, "Aurum Door");
        this.addBlock((Supplier)ModBlocks.EDELWOOD_DOOR, "Edelwood Door");
        this.addBlock((Supplier)ModBlocks.ARCANE_EDELWOOD_DOOR, "Arcane Edelwood Door");
        this.addBlock((Supplier)ModBlocks.DEORUM_TRAPDOOR, "Deorum Trapdoor");
        this.addBlock((Supplier)ModBlocks.FUNGYSS_TRAPDOOR, "Fungyss Trapdoor");
        this.addBlock((Supplier)ModBlocks.AURUM_TRAPDOOR, "Aurum Trapdoor");
        this.addBlock((Supplier)ModBlocks.EDELWOOD_TRAPDOOR, "Edelwood Trapdoor");
        this.addBlock((Supplier)ModBlocks.ARCANE_EDELWOOD_TRAPDOOR, "Arcane Edelwood Trapdoor");
        this.addBlock((Supplier)ModBlocks.FUNGYSS_BUTTON, "Fungyss Button");
        this.addBlock((Supplier)ModBlocks.AURUM_BUTTON, "Aurum Button");
        this.addBlock((Supplier)ModBlocks.EDELWOOD_BUTTON, "Edelwood Button");
        this.addBlock((Supplier)ModBlocks.FUNGYSS_PRESSURE_PLATE, "Fungyss Pressure Plate");
        this.addBlock((Supplier)ModBlocks.AURUM_PRESSURE_PLATE, "Aurum Pressure Plate");
        this.addBlock((Supplier)ModBlocks.EDELWOOD_PRESSURE_PLATE, "Edelwood Pressure Plate");
        this.addBlock((Supplier)ModBlocks.EDELWOOD_LADDER, "Edelwood Ladder");
        this.addBlock((Supplier)ModBlocks.ARCANE_DRAGON_EGG, "Arcane Dragon Egg");
        this.addBlock((Supplier)ModBlocks.DEORUM_CHAIN, "Deorum Chain");
        this.addBlock((Supplier)ModBlocks.YELLOW_ORCHID, "Yellow Orchid");
        this.addBlock((Supplier)ModBlocks.MAGICAL_FARMLAND, "Magical Farmland");
        this.addBlock((Supplier)ModBlocks.OBSIDIAN_SKULL.skull(), "Obsidian Skull");
        this.addBlock((Supplier)ModBlocks.CRACKED_OBSIDIAN_SKULL.skull(), "Cracked Obsidian Skull");
        this.addBlock((Supplier)ModBlocks.FRAGMENTED_OBSIDIAN_SKULL.skull(), "Fragmented Obsidian Skull");
        this.addBlock((Supplier)ModBlocks.FADING_OBSIDIAN_SKULL.skull(), "Fading Obsidian Skull");
        this.addBlock((Supplier)ModBlocks.AUREALIC_OBSIDIAN_SKULL.skull(), "Aurealic Obsidian Skull");
        this.addBlock((Supplier)ModBlocks.ETERNAL_OBSIDIAN_SKULL.skull(), "Eternal Obsidian Skull");
        this.addBlock((Supplier)ModBlocks.UTREM_JAR, "Utrem Jar");
        this.add("block", "hephaestus_forge.tier", "Tier %s");
        this.add("block", "hephaestus_forge.tier.match_exact", "Requires exactly tier %s");
        this.add("block", "hephaestus_forge.tier.at_least", "Requires at least tier %s");
        this.add("block", "hephaestus_forge.slot_unlocked_at", "Unlocked at tier %s");
        this.addItem((Supplier)ModItems.QUANTUM_CATCHER, "Quantum Catcher");
        this.addItem((Supplier)ModItems.BOSS_CATCHER, "Boss Catcher");
        this.addItem((Supplier)ModItems.ARCANE_CRYSTAL, "Arcane Crystal");
        this.addItem((Supplier)ModItems.CORRUPTED_ARCANE_CRYSTAL, "Corrupted Arcane Crystal");
        this.addItem((Supplier)ModItems.RUNE, "Rune");
        this.addItem((Supplier)ModItems.STELLARITE_PIECE, "Stellarite Piece");
        this.addItem((Supplier)ModItems.XPETRIFIED_ORB, "Xpetrified Orb");
        this.addItem((Supplier)ModItems.DARK_NETHER_STAR, "Dark Nether Star");
        this.addItem((Supplier)ModItems.DEORUM_INGOT, "Deorum Ingot");
        this.addItem((Supplier)ModItems.OBSIDIANSTEEL_INGOT, "Obsidiansteel Ingot");
        this.addItem((Supplier)ModItems.DEORUM_NUGGET, "Deorum Nugget");
        this.addItem((Supplier)ModItems.ARCANE_CRYSTAL_DUST, "Arcane Crystal Dust");
        this.addItem((Supplier)ModItems.MUNDABITUR_DUST, "Mundabitur Dust");
        this.addItem((Supplier)ModItems.CORRUPTI_DUST, "Corrupti Dust");
        this.addItem((Supplier)ModItems.ARCANE_CRYSTAL_DUST_SPECK, "Arcane Crystal Dust Speck");
        this.addItem((Supplier)ModItems.ARCANE_BONE_MEAL, "Arcane Bone Meal");
        this.addItem((Supplier)ModItems.SOUL, "Soul");
        this.addItem((Supplier)ModItems.CORRUPT_SOUL, "Corrupt Soul");
        this.addItem((Supplier)ModItems.ENCHANTED_SOUL, "Enchanted Soul");
        this.addItem((Supplier)ModItems.AUREAL_BOTTLE, "Aureal Bottle");
        this.addItem((Supplier)ModItems.SPLASH_AUREAL_BOTTLE, "Splash Aureal Bottle");
        this.addItem((Supplier)ModItems.TEST_TUBE, "Test Tube");
        this.addItem((Supplier)ModItems.ETERNAL_STELLA, "Eternal Stella");
        this.addItem((Supplier)ModItems.TERRASTOMP_PRISM, "Terrastomp Prism");
        this.addItem((Supplier)ModItems.SEA_PRISM, "Sea Prism");
        this.addItem((Supplier)ModItems.WHIRLWIND_PRISM, "Whirlwind Prism");
        this.addItem((Supplier)ModItems.SMELTER_PRISM, "Smelter Prism");
        this.addItem((Supplier)ModItems.FERROGNETIC_MIXTURE, "Ferrognetic Mixture");
        this.addItem((Supplier)ModItems.SOUL_BINDING_CRYSTAL, "Soul Binding Crystal");
        this.addItem((Supplier)ModItems.DARK_MATTER, "Dark Matter");
        this.addItem((Supplier)ModItems.ENDER_PEARL_FRAGMENT, "Ender Pearl Fragment");
        this.addItem((Supplier)ModItems.DRAGON_SCALE, "Dragon Scale");
        this.addItem((Supplier)ModItems.SILVER_DRAGON_SCALE, "Silver Dragon Scale");
        this.addItem((Supplier)ModItems.GOLDEN_DRAGON_SCALE, "Golden Dragon Scale");
        this.addItem((Supplier)ModItems.AQUATIC_DRAGON_SCALE, "Aquatic Dragon Scale");
        this.addItem((Supplier)ModItems.SPECTRAL_EYE_AMULET, "Spectral Eye Amulet");
        this.addItem((Supplier)ModItems.BAT_WING, "Bat Wing");
        this.addItem((Supplier)ModItems.BAT_SOUP, "Bat Soup");
        this.addItem((Supplier)ModItems.TENTACLE, "Tentacle");
        this.addItem((Supplier)ModItems.COOKED_TENTACLE, "Cooked Tentacle");
        this.addItem((Supplier)ModItems.EDELWOOD_STICK, "Edelwood Stick");
        this.addItem((Supplier)ModItems.WAX, "Wax");
        this.addItem((Supplier)ModItems.SPAWNER_SCRAP, "Spawner Scrap");
        this.addItem((Supplier)ModItems.AUREAL_TANK, "Aureal Tank");
        this.addItem((Supplier)ModItems.EDELWOOD_BUCKET, "Edelwood Bucket");
        this.addItem((Supplier)ModItems.EDELWOOD_WATER_BUCKET, "Edelwood Water Bucket");
        this.addItem((Supplier)ModItems.EDELWOOD_LAVA_BUCKET, "Edelwood Lava Bucket");
        this.addItem((Supplier)ModItems.EDELWOOD_MILK_BUCKET, "Edelwood Milk Bucket");
        this.addItem((Supplier)ModItems.BOOM_ARROW, "Boom Arrow");
        this.addItem((Supplier)ModItems.DRACO_ARCANUS_ARROW, "Draco Arcanus Arrow");
        this.addItem((Supplier)ModItems.EDELWOOD_OIL, "Edelwood Oil");
        this.addItem((Supplier)ModItems.AURUM_BOAT, "Aurum Boat");
        this.addItem((Supplier)ModItems.AURUM_CHEST_BOAT, "Aurum Chest Boat");
        this.addItem((Supplier)ModItems.EDELWOOD_BOAT, "Edelwood Boat");
        this.addItem((Supplier)ModItems.EDELWOOD_CHEST_BOAT, "Edelwood Chest Boat");
        this.addItem((Supplier)ModItems.DRACO_ARCANUS_STAFF, "Draco Arcanus Staff");
        this.addItem((Supplier)ModItems.DRACO_ARCANUS_SWORD, "Draco Arcanus Sword");
        this.addItem((Supplier)ModItems.DRACO_ARCANUS_PICKAXE, "Draco Arcanus Pickaxe");
        this.addItem((Supplier)ModItems.DRACO_ARCANUS_AXE, "Draco Arcanus Axe");
        this.addItem((Supplier)ModItems.DRACO_ARCANUS_SHOVEL, "Draco Arcanus Shovel");
        this.addItem((Supplier)ModItems.DRACO_ARCANUS_HOE, "Draco Arcanus Hoe");
        this.addItem((Supplier)ModItems.DRACO_ARCANUS_SCEPTER, "Draco Arcanus Scepter");
        this.addItem((Supplier)ModItems.DRACO_ARCANUS_HELMET, "Draco Arcanus Helmet");
        this.addItem((Supplier)ModItems.DRACO_ARCANUS_CHESTPLATE, "Draco Arcanus Chestplate");
        this.addItem((Supplier)ModItems.DRACO_ARCANUS_LEGGINGS, "Draco Arcanus Leggings");
        this.addItem((Supplier)ModItems.DRACO_ARCANUS_BOOTS, "Draco Arcanus Boots");
        this.addItem((Supplier)ModItems.TYR_HELMET, "Tyr Helmet");
        this.addItem((Supplier)ModItems.TYR_CHESTPLATE, "Tyr Chestplate");
        this.addItem((Supplier)ModItems.TYR_LEGGINGS, "Tyr Leggings");
        this.addItem((Supplier)ModItems.TYR_BOOTS, "Tyr Boots");
        this.addItem((Supplier)ModItems.MORTEM_HELMET, "Mortem Helmet");
        this.addItem((Supplier)ModItems.MORTEM_CHESTPLATE, "Mortem Chestplate");
        this.addItem((Supplier)ModItems.MORTEM_LEGGINGS, "Mortem Leggings");
        this.addItem((Supplier)ModItems.MORTEM_BOOTS, "Mortem Boots");
        this.addItem((Supplier)ModItems.ARTISAN_RELIC, "Artisan Relic");
        this.addItem((Supplier)ModItems.CRESCENT_MOON, "Crescent Moon");
        this.addItem((Supplier)ModItems.CRIMSON_STONE, "Crimson Stone");
        this.addItem((Supplier)ModItems.SOUL_CRIMSON_STONE, "Soul Crimson Stone");
        this.addItem((Supplier)ModItems.ELEMENTARIUM, "Elementarium");
        this.addItem((Supplier)ModItems.DIVINE_PACT, "Divine Pact");
        this.addItem((Supplier)ModItems.MALEDICTUS_PACT, "Maledictus Pact");
        this.addItem((Supplier)ModItems.SOUL_EXTRACTOR, "Soul Extractor");
        this.addItem((Supplier)ModItems.BLACKSMITH_GAVEL_HEAD, "Blacksmith Gavel Head");
        this.addItem((Supplier)ModItems.WOODEN_BLACKSMITH_GAVEL, "Wooden Blacksmith Gavel");
        this.addItem((Supplier)ModItems.STONE_BLACKSMITH_GAVEL, "Stone Blacksmith Gavel");
        this.addItem((Supplier)ModItems.IRON_BLACKSMITH_GAVEL, "Iron Blacksmith Gavel");
        this.addItem((Supplier)ModItems.GOLDEN_BLACKSMITH_GAVEL, "Golden Blacksmith Gavel");
        this.addItem((Supplier)ModItems.DIAMOND_BLACKSMITH_GAVEL, "Diamond Blacksmith Gavel");
        this.addItem((Supplier)ModItems.NETHERITE_BLACKSMITH_GAVEL, "Netherite Blacksmith Gavel");
        this.addItem((Supplier)ModItems.REINFORCED_DEORUM_BLACKSMITH_GAVEL, "Reinforced Deorum Blacksmith Gavel");
        this.addItem((Supplier)ModItems.APPLY_MODIFIER_SMITHING_TEMPLATE, "Smithing Template");
        for (DyeColor color : DyeColor.values()) {
            this.addItem((Supplier)ModItems.DYED_QUANTUM_CATCHERS.get((Object)color), COLOR_TO_STRING.get(color) + " Quantum Catcher");
        }
        this.add("item", "enhancer", "Enhancer Relic");
        this.add("item", "enhancer.hephaestus_forge_effect", "Hephaestus Forge effect:");
        this.add("item", "enhancer.clibano_effect", "Clibano effect:");
        this.add("item", "enhancer.artisan_relic.hephaestus_forge", "Saves you a lot of experience.");
        this.add("item", "enhancer.artisan_relic.clibano", "Allows you to create new alloys.");
        this.add("item", "enhancer.crescent_moon.hephaestus_forge", "Reduces the required Aureal depending on the time of the day.");
        this.add("item", "enhancer.crimson_stone.hephaestus_forge", "Heavily decreases the amount of required souls.");
        this.add("item", "enhancer.crimson_stone.clibano", "Used souls will last longer. (Soon)");
        this.add("item", "enhancer.soul_crimson_stone.hephaestus_forge", "Completely removes the essence requirement for one ritual.");
        this.add("item", "enhancer.elementarium.hephaestus_forge", "Allows the creation of elemental items.");
        this.add("item", "enhancer.divine_pact.hephaestus_forge", "Allows the creation of celestial items.");
        this.add("item", "enhancer.maledictus_pact.hephaestus_forge", "Allows the creation of cursed items.");
        this.add("item", "smithing_template.darkstone_upgrade.additions_slot_description", "Add a modifier item");
        this.add("item", "smithing_template.darkstone_upgrade.applies_to", "Equipment");
        this.add("item", "smithing_template.darkstone_upgrade.base_slot_description", "Add armor, weapon, or tool");
        this.add("item", "smithing_template.darkstone_upgrade.ingredients", "Modifier Item");
        this.add("item", "toggle_state", "(Right-Click to toggle)");
        this.add("item", "toggle_state.activated", "Activated");
        this.add("item", "toggle_state.deactivated", "Deactivated");
        this.add("item", "stored_entity", "Entity: %s");
        this.add("item", "stored_entity.with_name", "Entity: %s (%s)");
        this.add("upgrade", "darkstone_upgrade", "Apply Item Modifier");
        this.add("tooltip", "essence.storage_format", "%s / %s");
    }

    private void addModifier(String modifier, String name) {
        this.add(Util.makeDescriptionId((String)"modifier", (ResourceLocation)ForbiddenArcanus.location(modifier)), name);
    }

    private <T extends StringRepresentable> void add(String category, T value, String name) {
        this.add(Util.makeDescriptionId((String)category, (ResourceLocation)ForbiddenArcanus.location(value.getSerializedName())), name);
    }

    public void add(String category, String path, String name) {
        this.add(Util.makeDescriptionId((String)category, (ResourceLocation)ForbiddenArcanus.location(path)), name);
    }
}

