/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item.enhancer.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.common.item.enhancer.condition.EffectCondition;
import com.stal111.forbidden_arcanus.common.item.enhancer.effect.EnhancerEffect;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.level.Level;

public record ConditionalEnhancerEffect<T extends EnhancerEffect>(T effect, Optional<List<EffectCondition>> conditions) {
    public static <T extends EnhancerEffect> ConditionalEnhancerEffect<T> of(T effect) {
        return new ConditionalEnhancerEffect<T>(effect, Optional.empty());
    }

    public static <T extends EnhancerEffect> ConditionalEnhancerEffect<T> of(T effect, List<EffectCondition> conditions) {
        return new ConditionalEnhancerEffect<T>(effect, Optional.of(conditions));
    }

    public static <T extends EnhancerEffect> MapCodec<ConditionalEnhancerEffect<T>> codec(MapCodec<T> effectCodec) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)effectCodec.forGetter(ConditionalEnhancerEffect::effect), (App)EffectCondition.DIRECT_CODEC.listOf().optionalFieldOf("conditions").forGetter(ConditionalEnhancerEffect::conditions)).apply((Applicative)instance, ConditionalEnhancerEffect::new));
    }

    public boolean checkConditions(Level level) {
        return this.conditions.stream().flatMap(Collection::stream).allMatch(condition -> condition.test(level));
    }
}

