/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item;

import com.stal111.forbidden_arcanus.common.entity.CustomBoat;
import com.stal111.forbidden_arcanus.common.entity.ModBoat;
import com.stal111.forbidden_arcanus.common.entity.ModChestBoat;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ModBoatItem
extends BoatItem {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);
    private final ModBoat.Type woodType;
    private final boolean hasChest;

    public ModBoatItem(boolean hasChest, ModBoat.Type woodType, Item.Properties properties) {
        super(hasChest, Boat.Type.OAK, properties);
        this.woodType = woodType;
        this.hasChest = hasChest;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        BlockHitResult hitResult = ModBoatItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.getType() != HitResult.Type.MISS) {
            Vec3 vec3 = player.getViewVector(1.0f);
            List list = level.getEntities((Entity)player, player.getBoundingBox().expandTowards(vec3.scale(5.0)).inflate(1.0), ENTITY_PREDICATE);
            if (!list.isEmpty()) {
                Vec3 vec31 = player.getEyePosition();
                for (Entity entity : list) {
                    if (!entity.getBoundingBox().inflate((double)entity.getPickRadius()).contains(vec31)) continue;
                    return InteractionResultHolder.pass((Object)stack);
                }
            }
            if (hitResult.getType() == HitResult.Type.BLOCK) {
                CustomBoat customBoat = this.getBoat(level, (HitResult)hitResult);
                customBoat.setWoodType(this.woodType);
                if (!(customBoat instanceof Boat)) {
                    return InteractionResultHolder.pass((Object)stack);
                }
                Boat boat = (Boat)customBoat;
                boat.setYRot(player.getYRot());
                if (!level.noCollision((Entity)boat, boat.getBoundingBox())) {
                    return InteractionResultHolder.fail((Object)stack);
                }
                if (!level.isClientSide()) {
                    level.addFreshEntity((Entity)boat);
                    level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, hitResult.getLocation());
                    stack.consume(1, (LivingEntity)player);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    private CustomBoat getBoat(Level level, HitResult hitResult) {
        return this.hasChest ? new ModChestBoat(level, hitResult.getLocation().x, hitResult.getLocation().y, hitResult.getLocation().z) : new ModBoat(level, hitResult.getLocation().x, hitResult.getLocation().y, hitResult.getLocation().z);
    }
}

