/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.event;

import com.stal111.forbidden_arcanus.common.essence.EssenceHelper;
import com.stal111.forbidden_arcanus.common.item.BloodTestTubeItem;
import com.stal111.forbidden_arcanus.common.item.modifier.ItemModifier;
import com.stal111.forbidden_arcanus.common.item.modifier.ModifierHelper;
import com.stal111.forbidden_arcanus.common.item.modifier.SoulboundInventory;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import com.stal111.forbidden_arcanus.core.init.other.ModAttachmentTypes;
import com.stal111.forbidden_arcanus.data.ModItemModifiers;
import com.stal111.forbidden_arcanus.util.ModTags;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

public class EntityEvents {
    @SubscribeEvent
    public void onEntityDamage(LivingDamageEvent.Post event) {
        Entity entity;
        DamageSource source = event.getSource();
        if (source.is(DamageTypes.PLAYER_ATTACK) && (entity = source.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            if (!event.getEntity().getType().is(ModTags.EntityTypes.TEST_TUBE_BLACKLISTED)) {
                ItemStack stack;
                if (player.getOffhandItem().is(ModItems.TEST_TUBE)) {
                    player.setItemInHand(InteractionHand.OFF_HAND, ((BloodTestTubeItem)((Object)ModItems.BLOOD_TEST_TUBE.get())).getDefaultInstance());
                }
                if ((stack = player.getOffhandItem()).getItem() instanceof BloodTestTubeItem) {
                    EssenceHelper.getEssenceStorage(stack).ifPresent(storage -> storage.addEssence(stack, (int)(20.0f * event.getNewDamage())));
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            SoulboundInventory inventory = SoulboundInventory.create();
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack stack = player.getInventory().getItem(i);
                if (!ModifierHelper.hasModifier(stack, (Holder<ItemModifier>)player.level().holderOrThrow(ModItemModifiers.SOULBOUND))) continue;
                inventory.add(i, stack);
                player.getInventory().setItem(i, ItemStack.EMPTY);
            }
            player.setData(ModAttachmentTypes.SOULBOUND_INVENTORY, (Object)inventory);
        }
    }
}

