/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.entity.darktrader;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Dynamic;
import com.stal111.forbidden_arcanus.common.entity.darktrader.DarkTrader;
import com.stal111.forbidden_arcanus.common.entity.darktrader.DarkTraderSpawning;
import java.util.List;
import java.util.Set;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class DarkTraderAI {
    public static final int SPAWN_DURATION = 60;
    private static final List<SensorType<? extends Sensor<? super DarkTrader>>> SENSOR_TYPES = List.of(SensorType.NEAREST_PLAYERS);
    private static final List<MemoryModuleType<?>> MEMORY_TYPES = List.of(MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_NEMESIS, MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET, MemoryModuleType.PATH, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.NEAREST_ATTACKABLE, MemoryModuleType.IS_EMERGING);

    public static void updateActivity(DarkTrader trader) {
        trader.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.EMERGE));
    }

    protected static Brain<?> makeBrain(DarkTrader trader, Dynamic<?> dynamic) {
        Brain.Provider provider = Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
        Brain brain = provider.makeBrain(dynamic);
        DarkTraderAI.initCoreActivity((Brain<DarkTrader>)brain);
        DarkTraderAI.initSpawnActivity((Brain<DarkTrader>)brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<DarkTrader> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initSpawnActivity(Brain<DarkTrader> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.EMERGE, 5, ImmutableList.of(new DarkTraderSpawning(60)), MemoryModuleType.IS_EMERGING);
    }
}

