/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.pedestal;

import com.stal111.forbidden_arcanus.common.block.entity.PedestalBlockEntity;
import com.stal111.forbidden_arcanus.common.block.pedestal.effect.PedestalEffectTrigger;
import com.stal111.forbidden_arcanus.core.init.ModBlockEntities;
import com.stal111.forbidden_arcanus.core.init.other.ModStats;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_core.api.common.helper.VoxelShapeHelper;
import org.jetbrains.annotations.Nullable;

public class PedestalBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    private static final VoxelShape SHAPE = VoxelShapeHelper.combineAll((VoxelShape[])new VoxelShape[]{PedestalBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0), PedestalBlock.box((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), PedestalBlock.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), PedestalBlock.box((double)2.0, (double)11.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0)});
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public PedestalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PedestalBlockEntity(pos, state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return state;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        PedestalBlockEntity blockEntity;
        ItemStack pedestalStack;
        BlockEntity blockEntity2;
        if (!level.isClientSide() && (blockEntity2 = level.getBlockEntity(pos)) instanceof PedestalBlockEntity && !(pedestalStack = (blockEntity = (PedestalBlockEntity)blockEntity2).getStack()).isEmpty()) {
            if (!player.addItem(pedestalStack)) {
                player.drop(pedestalStack, false);
            }
            blockEntity.setStack(ItemStack.EMPTY, player, PedestalEffectTrigger.PLAYER_REMOVE_ITEM);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PedestalBlockEntity) {
            PedestalBlockEntity blockEntity2 = (PedestalBlockEntity)blockEntity;
            ItemStack pedestalStack = blockEntity2.getStack();
            if (!level.isClientSide()) {
                if (pedestalStack.isEmpty() && !stack.isEmpty()) {
                    blockEntity2.setStack(stack.copyWithCount(1), player, PedestalEffectTrigger.PLAYER_PLACE_ITEM);
                    stack.consume(1, (LivingEntity)player);
                } else if (!pedestalStack.isEmpty()) {
                    if (stack.isEmpty()) {
                        player.setItemInHand(hand, pedestalStack);
                    } else if (!player.addItem(pedestalStack)) {
                        player.drop(pedestalStack, false);
                    }
                    blockEntity2.setStack(ItemStack.EMPTY, player, PedestalEffectTrigger.PLAYER_REMOVE_ITEM);
                }
                player.awardStat((ResourceLocation)ModStats.INTERACT_WITH_PEDESTAL.get());
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useItemOn(stack, state, level, pos, player, hand, result);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        PedestalBlockEntity blockEntity;
        if (newState.getBlock() instanceof PedestalBlock) {
            return;
        }
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof PedestalBlockEntity && (blockEntity = (PedestalBlockEntity)blockEntity2).hasStack()) {
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.1, (double)pos.getZ() + 0.5, blockEntity.getStack()));
            blockEntity.setStack(ItemStack.EMPTY, null, PedestalEffectTrigger.PLAYER_REMOVE_ITEM);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide()) {
            return BaseEntityBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.PEDESTAL.get()), PedestalBlockEntity::clientTick);
        }
        return BaseEntityBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.PEDESTAL.get()), PedestalBlockEntity::serverTick);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }
}

