/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.stal111.forbidden_arcanus.client.FARenderTypes;
import com.stal111.forbidden_arcanus.client.model.MagicCircleModel;
import com.stal111.forbidden_arcanus.common.block.entity.forge.circle.MagicCircleType;
import com.stal111.forbidden_arcanus.core.init.ModParticles;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public class MagicCircle {
    private final MagicCircleType type;
    private final Level level;
    private final BlockPos pos;
    private int counter;

    public MagicCircle(MagicCircleType type, Level level, BlockPos pos) {
        this.type = type;
        this.level = level;
        this.pos = pos;
    }

    public void tick() {
        ++this.counter;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public void render(PoseStack poseStack, float partialTicks, MultiBufferSource buffer, int packedLight, MagicCircleModel model, int duration) {
        float rotation = (float)this.counter + partialTicks;
        float progress = rotation / (float)duration;
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        float size = this.easeSineOut(Math.min((double)progress, 0.25), 1.25, 7.25, 0.25);
        poseStack.scale(size, 1.0f, size);
        float alpha = progress > 0.9f ? this.easeSineOut(progress - 0.9f, 1.0, -1.0, 0.1) : 1.0f;
        poseStack.mulPose(Axis.YN.rotationDegrees(rotation));
        model.outerRing().render(poseStack, buffer.getBuffer(FARenderTypes.entityFullbrightTranslucent(this.type.outerTexture())), packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.mulPose(Axis.YN.rotationDegrees(-rotation * 2.0f));
        model.innerRing().render(poseStack, buffer.getBuffer(FARenderTypes.entityFullbrightTranslucent(this.type.innerTexture())), packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        if (progress > 0.9f) {
            RandomSource random = this.level.getRandom();
            double posX = (double)this.pos.getX() + 0.25 + (double)random.nextFloat() + (double)random.nextInt(4);
            double posZ = (double)this.pos.getZ() + 0.25 + (double)random.nextFloat() + (double)random.nextInt(4);
            double ySpeed = ((double)random.nextFloat() - 0.4) * 0.125;
            this.level.addParticle((ParticleOptions)ModParticles.AUREAL_MOTE.get(), posX - 2.0, (double)((float)this.pos.getY() + 0.1f), posZ - 2.0, 0.0, ySpeed, 0.0);
        }
    }

    public float easeSineIn(double progress, double start, double change, double duration) {
        return (float)(-change * Math.cos(progress / duration * 1.5707963267948966) + change + start);
    }

    public float easeSineOut(double progress, double start, double change, double duration) {
        return (float)(change * Math.sin(progress / duration * 1.5707963267948966) + start);
    }
}

