/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.flowermimics_common_neoforge.events;

import com.natamus.collective_common_neoforge.functions.CompareBlockFunctions;
import com.natamus.collective_common_neoforge.functions.HashMapFunctions;
import com.natamus.flowermimics_common_neoforge.config.ConfigHandler;
import com.natamus.flowermimics_common_neoforge.util.Util;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MimicEvent {
    private static final WeakHashMap<Level, Boolean> wasItDay = new WeakHashMap();

    public static void onLevelTick(ServerLevel level) {
        if (!ConfigHandler.resetMimicsBeforeNightTime) {
            return;
        }
        boolean isDay = level.isDay();
        if (!wasItDay.containsKey(level)) {
            wasItDay.put((Level)level, isDay);
            Util.flowersChecked.put((Level)level, new ArrayList());
            Util.flowerIsAMimic.put((Level)level, new ArrayList());
        }
        if (!isDay && wasItDay.get(level).booleanValue()) {
            Util.resetFlowerMimics((Level)level);
        }
        wasItDay.put((Level)level, isDay);
    }

    public static void onPlayerTick(ServerLevel level, ServerPlayer player) {
        if (player.tickCount % ConfigHandler.checkForMimicFlowersDelayInTicks != 0) {
            return;
        }
        if (level.getLevelData().getDifficulty().equals((Object)Difficulty.PEACEFUL)) {
            return;
        }
        if (ConfigHandler.onlyTransformMimicsAtNight && !level.isNight()) {
            return;
        }
        BlockPos playerPos = player.blockPosition();
        int checkRange = ConfigHandler.checkForMimicAroundBlockRange;
        int transformRange = ConfigHandler.mimicTransformAroundPlayerRange;
        for (BlockPos aroundPos : BlockPos.betweenClosed((int)(playerPos.getX() - transformRange), (int)(playerPos.getY() - 3), (int)(playerPos.getZ() - transformRange), (int)(playerPos.getX() + transformRange), (int)(playerPos.getY() + 3), (int)(playerPos.getZ() + transformRange))) {
            BlockState aroundState = level.getBlockState(aroundPos);
            Block aroundBlock = aroundState.getBlock();
            if (!CompareBlockFunctions.blockIsInRegistryHolder((Block)aroundBlock, (TagKey)BlockTags.FLOWERS) || !Util.isFlowerAMimic((Level)level, aroundPos.immutable())) continue;
            Util.transformFlower((Level)level, (Player)player, aroundPos.immutable(), aroundBlock);
        }
    }

    public static void mobItemDrop(Level level, Entity entity, DamageSource damageSource) {
        int extraExperience;
        if (level.isClientSide) {
            return;
        }
        Set tags = entity.getTags();
        if (!tags.contains("flowermimics.mimic")) {
            return;
        }
        String flowerTag = "";
        String locationTag = "";
        for (String tag : tags) {
            if (tag.startsWith("flowermimics.flower.")) {
                flowerTag = tag;
                continue;
            }
            if (!tag.startsWith("flowermimics.location.")) continue;
            locationTag = tag;
        }
        Vec3 mimicVec = entity.position();
        if (ConfigHandler.dropExtraItemsOnMimicDeath || ConfigHandler.dropFlowerItemOnMimicDeath) {
            Util.dropMimicItems(level, mimicVec, flowerTag);
        }
        if (ConfigHandler.replaceOriginalFlowerBlockOnMimicDeath || ConfigHandler.placeFlowerBlockWhereMimicDies) {
            Util.placeFlowerBlockOnMimicDeath(level, mimicVec, flowerTag, locationTag);
        }
        if ((extraExperience = ConfigHandler.extraExperienceOnMimicDeath) > 0) {
            ExperienceOrb.award((ServerLevel)((ServerLevel)level), (Vec3)mimicVec, (int)extraExperience);
        }
    }

    public static void onBonemeal(Level level, BlockPos blockPos, BlockState blockState, ItemStack itemStack) {
        if (!ConfigHandler.preventMimicsOnPlacedAndBoneMealFlowers) {
            return;
        }
        if (level.isClientSide) {
            return;
        }
        level.getServer().tell((Runnable)new TickTask(level.getServer().getTickCount(), () -> {
            for (BlockPos aroundPos : BlockPos.betweenClosed((int)(blockPos.getX() - 6), (int)blockPos.getY(), (int)(blockPos.getZ() - 6), (int)(blockPos.getX() + 6), (int)(blockPos.getY() + 1), (int)(blockPos.getZ() + 6))) {
                Block aroundBlock = level.getBlockState(aroundPos).getBlock();
                if (!Util.isFlower(aroundBlock) || ((List)HashMapFunctions.computeIfAbsent(Util.flowersChecked, (Object)level, k -> new CopyOnWriteArrayList())).contains(aroundPos)) continue;
                Util.flowersChecked.get(level).add(aroundPos.immutable());
            }
        }));
    }

    public static void onNeighbourNotice(Level level, BlockPos blockPos, BlockState blockState, EnumSet<Direction> notifiedSides, boolean forceRedstoneUpdate) {
        if (!ConfigHandler.preventMimicsOnPlacedAndBoneMealFlowers) {
            return;
        }
        if (level.isClientSide) {
            return;
        }
        Block block = blockState.getBlock();
        if (Util.isFlower(block) && !((List)HashMapFunctions.computeIfAbsent(Util.flowersChecked, (Object)level, k -> new CopyOnWriteArrayList())).contains(blockPos)) {
            Util.flowersChecked.get(level).add(blockPos.immutable());
        }
    }
}

