/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.flowermimics_common_forge.util;

import com.natamus.collective_common_forge.functions.HashMapFunctions;
import com.natamus.flowermimics_common_forge.config.ConfigHandler;
import com.natamus.flowermimics_common_forge.data.MimicData;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class Util {
    public static final WeakHashMap<Level, List<BlockPos>> flowersChecked = new WeakHashMap();
    public static final WeakHashMap<Level, List<BlockPos>> flowerIsAMimic = new WeakHashMap();

    public static boolean isFlowerAMimic(Level level, BlockPos blockPos) {
        boolean isMimic;
        if (((List)HashMapFunctions.computeIfAbsent(flowersChecked, (Object)level, k -> new ArrayList())).contains(blockPos)) {
            return false;
        }
        if (((List)HashMapFunctions.computeIfAbsent(flowerIsAMimic, (Object)level, k -> new ArrayList())).contains(blockPos)) {
            return true;
        }
        flowersChecked.get(level).add(blockPos);
        boolean bl = isMimic = Math.random() <= ConfigHandler.flowerIsMimicChance;
        if (isMimic) {
            flowerIsAMimic.get(level).add(blockPos);
        }
        return isMimic;
    }

    public static boolean isFlower(Block block) {
        return block instanceof FlowerBlock || block instanceof TallFlowerBlock;
    }

    public static void transformFlower(Level level, Player player, BlockPos flowerPos, Block flowerBlock) {
        if (!flowerIsAMimic.get(level).contains(flowerPos)) {
            return;
        }
        EntityType<?> mimicEntityType = MimicData.getMimicFromFlower(flowerBlock);
        if (mimicEntityType == null) {
            flowerIsAMimic.get(level).remove(flowerPos);
            return;
        }
        Entity mimic = mimicEntityType.create(level);
        if (mimic == null) {
            return;
        }
        mimic.setPos((double)flowerPos.getX() + 0.5, (double)flowerPos.getY(), (double)flowerPos.getZ() + 0.5);
        mimic.addTag("flowermimics.mimic");
        MutableComponent mimicNameComponent = flowerBlock.getName().append(" Mimic");
        mimic.setCustomName((Component)mimicNameComponent.withStyle(ChatFormatting.GOLD));
        if (ConfigHandler.removeFlowerBlockOnMimicSpawn) {
            ResourceLocation resourceLocation = level.registryAccess().registryOrThrow(BuiltInRegistries.BLOCK.key()).getKey((Object)flowerBlock);
            mimic.addTag("flowermimics.flower." + String.valueOf(resourceLocation));
            mimic.addTag("flowermimics.location." + flowerPos.getX() + "," + flowerPos.getY() + "," + flowerPos.getZ());
        }
        if (ConfigHandler.removeFlowerBlockOnMimicSpawn) {
            if (flowerBlock instanceof TallFlowerBlock) {
                level.setBlock(flowerPos.immutable().above(), Blocks.AIR.defaultBlockState(), 3);
            }
            level.setBlock(flowerPos, Blocks.AIR.defaultBlockState(), 3);
        }
        if (ConfigHandler.showLightningOnMimicSpawn) {
            Util.spawnLightning(level, flowerPos, player);
        }
        level.addFreshEntity(mimic);
    }

    public static void dropMimicItems(Level level, Vec3 mimicVec, String flowerTag) {
        Util.dropMimicItems(level, mimicVec, flowerTag, false);
    }

    public static void dropMimicItems(Level level, Vec3 mimicVec, String flowerTag, boolean flowerOnly) {
        String flowerBlockRlString = flowerTag.split(".flower.")[1];
        ResourceLocation flowerBlockResourceLocation = ResourceLocation.parse((String)flowerBlockRlString);
        Block flowerBlock = (Block)level.registryAccess().registryOrThrow(BuiltInRegistries.BLOCK.key()).get(flowerBlockResourceLocation);
        if (flowerBlock != null) {
            ItemStack mimicItemDropStack;
            if (ConfigHandler.dropExtraItemsOnMimicDeath && !flowerOnly && !(mimicItemDropStack = MimicData.getFlowerMimicDrop(flowerBlock)).getItem().equals(Items.AIR)) {
                level.addFreshEntity((Entity)new ItemEntity(level, mimicVec.x, mimicVec.y + 1.0, mimicVec.z, mimicItemDropStack));
            }
            if (ConfigHandler.dropFlowerItemOnMimicDeath) {
                ItemStack flowerItemStack = new ItemStack((ItemLike)flowerBlock, 1);
                level.addFreshEntity((Entity)new ItemEntity(level, mimicVec.x, mimicVec.y + 1.0, mimicVec.z, flowerItemStack));
            }
        }
    }

    public static void placeFlowerBlockOnMimicDeath(Level level, Vec3 mimicVec, String flowerTag, String locationTag) {
        BlockPos mimicPos = BlockPos.containing((Position)mimicVec);
        String flowerBlockRlString = flowerTag.split(".flower.")[1];
        ResourceLocation flowerBlockResourceLocation = ResourceLocation.parse((String)flowerBlockRlString);
        Block flowerBlock = (Block)level.registryAccess().registryOrThrow(BuiltInRegistries.BLOCK.key()).get(flowerBlockResourceLocation);
        boolean flowerPlaced = false;
        if (flowerBlock != null) {
            if (ConfigHandler.placeFlowerBlockWhereMimicDies && level.getBlockState(mimicPos).getBlock().equals(Blocks.AIR)) {
                flowersChecked.get(level).add(mimicPos.immutable());
                flowerIsAMimic.get(level).remove(mimicPos);
                BlockState flowerBlockState = flowerBlock.defaultBlockState();
                if (flowerBlock instanceof TallFlowerBlock) {
                    TallFlowerBlock.placeAt((LevelAccessor)level, (BlockState)flowerBlockState, (BlockPos)mimicPos, (int)3);
                } else {
                    level.setBlock(mimicPos, flowerBlockState, 3);
                }
                if (ConfigHandler.showLightningOnFlowerBlockReturn) {
                    Util.spawnLightning(level, mimicPos, null);
                }
                flowerPlaced = true;
            }
            if (ConfigHandler.replaceOriginalFlowerBlockOnMimicDeath && !locationTag.equals("")) {
                String rawCoordinates = locationTag.split(".location.")[1];
                String[] cSpl = rawCoordinates.split(",");
                try {
                    BlockPos mimicSpawnBlockPos = new BlockPos(Integer.parseInt(cSpl[0]), Integer.parseInt(cSpl[1]), Integer.parseInt(cSpl[2]));
                    if (level.getBlockState(mimicSpawnBlockPos).getBlock().equals(Blocks.AIR)) {
                        flowersChecked.get(level).add(mimicSpawnBlockPos.immutable());
                        flowerIsAMimic.get(level).remove(mimicSpawnBlockPos);
                        BlockState flowerBlockState = flowerBlock.defaultBlockState();
                        if (flowerBlock instanceof TallFlowerBlock) {
                            TallFlowerBlock.placeAt((LevelAccessor)level, (BlockState)flowerBlockState, (BlockPos)mimicSpawnBlockPos, (int)3);
                        } else {
                            level.setBlock(mimicSpawnBlockPos, flowerBlockState, 3);
                        }
                        if (ConfigHandler.showLightningOnFlowerBlockReturn) {
                            Util.spawnLightning(level, mimicSpawnBlockPos, null);
                        }
                        flowerPlaced = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (!flowerPlaced) {
            Util.dropMimicItems(level, mimicVec, flowerTag, true);
        }
    }

    public static void spawnLightning(Level level, BlockPos pos, Player player) {
        LightningBolt lightningbolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
        if (lightningbolt == null) {
            return;
        }
        lightningbolt.moveTo(Vec3.atBottomCenterOf((Vec3i)pos));
        lightningbolt.getTags().add("visualonly");
        level.addFreshEntity((Entity)lightningbolt);
        if (player != null) {
            player.playSound(SoundEvents.LIGHTNING_BOLT_THUNDER, 5.0f, 1.0f);
        }
    }

    public static void resetFlowerMimics(Level level) {
        flowersChecked.put(level, new ArrayList());
        flowerIsAMimic.put(level, new ArrayList());
    }
}

