/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.flowermimics_common_fabric.events;

import com.natamus.collective_common_fabric.functions.CompareBlockFunctions;
import com.natamus.collective_common_fabric.functions.HashMapFunctions;
import com.natamus.flowermimics_common_fabric.config.ConfigHandler;
import com.natamus.flowermimics_common_fabric.util.Util;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3738;
import net.minecraft.class_6862;

public class MimicEvent {
    private static final WeakHashMap<class_1937, Boolean> wasItDay = new WeakHashMap();

    public static void onLevelTick(class_3218 level) {
        if (!ConfigHandler.resetMimicsBeforeNightTime) {
            return;
        }
        boolean isDay = level.method_8530();
        if (!wasItDay.containsKey(level)) {
            wasItDay.put((class_1937)level, isDay);
            Util.flowersChecked.put((class_1937)level, new ArrayList());
            Util.flowerIsAMimic.put((class_1937)level, new ArrayList());
        }
        if (!isDay && wasItDay.get(level).booleanValue()) {
            Util.resetFlowerMimics((class_1937)level);
        }
        wasItDay.put((class_1937)level, isDay);
    }

    public static void onPlayerTick(class_3218 level, class_3222 player) {
        if (player.field_6012 % ConfigHandler.checkForMimicFlowersDelayInTicks != 0) {
            return;
        }
        if (level.method_8401().method_207().equals((Object)class_1267.field_5801)) {
            return;
        }
        if (ConfigHandler.onlyTransformMimicsAtNight && !level.method_23886()) {
            return;
        }
        class_2338 playerPos = player.method_24515();
        int checkRange = ConfigHandler.checkForMimicAroundBlockRange;
        int transformRange = ConfigHandler.mimicTransformAroundPlayerRange;
        for (class_2338 aroundPos : class_2338.method_10094((int)(playerPos.method_10263() - transformRange), (int)(playerPos.method_10264() - 3), (int)(playerPos.method_10260() - transformRange), (int)(playerPos.method_10263() + transformRange), (int)(playerPos.method_10264() + 3), (int)(playerPos.method_10260() + transformRange))) {
            class_2680 aroundState = level.method_8320(aroundPos);
            class_2248 aroundBlock = aroundState.method_26204();
            if (!CompareBlockFunctions.blockIsInRegistryHolder((class_2248)aroundBlock, (class_6862)class_3481.field_20339) || !Util.isFlowerAMimic((class_1937)level, aroundPos.method_10062())) continue;
            Util.transformFlower((class_1937)level, (class_1657)player, aroundPos.method_10062(), aroundBlock);
        }
    }

    public static void mobItemDrop(class_1937 level, class_1297 entity, class_1282 damageSource) {
        int extraExperience;
        if (level.field_9236) {
            return;
        }
        Set tags = entity.method_5752();
        if (!tags.contains("flowermimics.mimic")) {
            return;
        }
        String flowerTag = "";
        String locationTag = "";
        for (String tag : tags) {
            if (tag.startsWith("flowermimics.flower.")) {
                flowerTag = tag;
                continue;
            }
            if (!tag.startsWith("flowermimics.location.")) continue;
            locationTag = tag;
        }
        class_243 mimicVec = entity.method_19538();
        if (ConfigHandler.dropExtraItemsOnMimicDeath || ConfigHandler.dropFlowerItemOnMimicDeath) {
            Util.dropMimicItems(level, mimicVec, flowerTag);
        }
        if (ConfigHandler.replaceOriginalFlowerBlockOnMimicDeath || ConfigHandler.placeFlowerBlockWhereMimicDies) {
            Util.placeFlowerBlockOnMimicDeath(level, mimicVec, flowerTag, locationTag);
        }
        if ((extraExperience = ConfigHandler.extraExperienceOnMimicDeath) > 0) {
            class_1303.method_31493((class_3218)((class_3218)level), (class_243)mimicVec, (int)extraExperience);
        }
    }

    public static void onBonemeal(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1799 itemStack) {
        if (!ConfigHandler.preventMimicsOnPlacedAndBoneMealFlowers) {
            return;
        }
        if (level.field_9236) {
            return;
        }
        level.method_8503().method_18858((Runnable)new class_3738(level.method_8503().method_3780(), () -> {
            for (class_2338 aroundPos : class_2338.method_10094((int)(blockPos.method_10263() - 6), (int)blockPos.method_10264(), (int)(blockPos.method_10260() - 6), (int)(blockPos.method_10263() + 6), (int)(blockPos.method_10264() + 1), (int)(blockPos.method_10260() + 6))) {
                class_2248 aroundBlock = level.method_8320(aroundPos).method_26204();
                if (!Util.isFlower(aroundBlock) || ((List)HashMapFunctions.computeIfAbsent(Util.flowersChecked, (Object)level, k -> new CopyOnWriteArrayList())).contains(aroundPos)) continue;
                Util.flowersChecked.get(level).add(aroundPos.method_10062());
            }
        }));
    }

    public static void onNeighbourNotice(class_1937 level, class_2338 blockPos, class_2680 blockState, EnumSet<class_2350> notifiedSides, boolean forceRedstoneUpdate) {
        if (!ConfigHandler.preventMimicsOnPlacedAndBoneMealFlowers) {
            return;
        }
        if (level.field_9236) {
            return;
        }
        class_2248 block = blockState.method_26204();
        if (Util.isFlower(block) && !((List)HashMapFunctions.computeIfAbsent(Util.flowersChecked, (Object)level, k -> new CopyOnWriteArrayList())).contains(blockPos)) {
            Util.flowersChecked.get(level).add(blockPos.method_10062());
        }
    }
}

