/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.flowermimics_common_fabric.data;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective_common_fabric.functions.DataFunctions;
import com.natamus.collective_common_fabric.functions.ItemFunctions;
import com.natamus.flowermimics_common_fabric.data.Variables;
import com.natamus.flowermimics_common_fabric.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class MimicData {
    public static List<class_2248> allFlowers = new ArrayList<class_2248>();
    private static HashMap<class_2248, class_1299<?>> flowerToMimic = new HashMap();
    private static HashMap<class_2248, class_1799> flowerMimicDrops = new HashMap();
    private static final HashMap<class_2248, class_1299<?>> defaultFlowerToMimic = new HashMap();
    private static final HashMap<class_2248, class_1799> defaultFlowerMimicDrops = new HashMap();
    private static final String dirPath = DataFunctions.getConfigDirectory() + File.separator + "flowermimics";
    private static final File dir = new File(dirPath);
    private static final File flowerMimicsFile = new File(dirPath + File.separator + "flower_mimics.txt");
    private static final File flowerItemDropsFile = new File(dirPath + File.separator + "flower_item_drops.txt");

    public static class_1299<?> getMimicFromFlower(class_2248 block) {
        if (!flowerToMimic.containsKey(block)) {
            return null;
        }
        return flowerToMimic.get(block);
    }

    public static class_1799 getFlowerMimicDrop(class_2248 block) {
        if (!flowerMimicDrops.containsKey(block)) {
            return new class_1799((class_1935)class_2246.field_10124, 1);
        }
        return flowerMimicDrops.get(block).method_7972();
    }

    public static void loadDefaultMimicData() {
        defaultFlowerToMimic.put(class_2246.field_10226, class_1299.field_6065);
        defaultFlowerToMimic.put(class_2246.field_10573, class_1299.field_17713);
        defaultFlowerToMimic.put(class_2246.field_10086, class_1299.field_6123);
        defaultFlowerToMimic.put(class_2246.field_9995, class_1299.field_6078);
        defaultFlowerToMimic.put(class_2246.field_10182, class_1299.field_6054);
        defaultFlowerToMimic.put(class_2246.field_10378, class_1299.field_6109);
        defaultFlowerToMimic.put(class_2246.field_10548, class_1299.field_6107);
        defaultFlowerToMimic.put(class_2246.field_10048, class_1299.field_6047);
        defaultFlowerToMimic.put(class_2246.field_10554, class_1299.field_6098);
        defaultFlowerToMimic.put(class_2246.field_10003, class_1299.field_6117);
        defaultFlowerToMimic.put(class_2246.field_10315, class_1299.field_6069);
        defaultFlowerToMimic.put(class_2246.field_10449, class_1299.field_6084);
        defaultFlowerToMimic.put(class_2246.field_10270, class_1299.field_6079);
        defaultFlowerToMimic.put(class_2246.field_10430, class_1299.field_6102);
        defaultFlowerToMimic.put(class_2246.field_10583, class_1299.field_6046);
        defaultFlowerToMimic.put(class_2246.field_42734, class_1299.field_6099);
        defaultFlowerToMimic.put(class_2246.field_10156, class_1299.field_6137);
        defaultFlowerToMimic.put(class_2246.field_10606, class_1299.field_6076);
    }

    public static void loadDefaultFlowerMimicDrops() {
        defaultFlowerMimicDrops.put(class_2246.field_10226, new class_1799((class_1935)class_1802.field_8233, 2));
        defaultFlowerMimicDrops.put(class_2246.field_10573, new class_1799((class_1935)class_1802.field_8687, 1));
        defaultFlowerMimicDrops.put(class_2246.field_10086, new class_1799((class_1935)class_1802.field_22016, 1));
        defaultFlowerMimicDrops.put(class_2246.field_9995, new class_1799((class_1935)class_1802.field_8153, 32));
        defaultFlowerMimicDrops.put(class_2246.field_10182, new class_1799((class_1935)class_1802.field_8463, 1));
        defaultFlowerMimicDrops.put(class_2246.field_10378, new class_1799((class_1935)class_1802.field_8301, 1));
        defaultFlowerMimicDrops.put(class_2246.field_10548, new class_1799((class_1935)class_1802.field_8620, 8));
        defaultFlowerMimicDrops.put(class_2246.field_10048, new class_1799((class_1935)class_1802.field_27876, 1));
        defaultFlowerMimicDrops.put(class_2246.field_10554, new class_1799((class_1935)class_1802.field_8236, 16));
        defaultFlowerMimicDrops.put(class_2246.field_10003, new class_1799((class_1935)class_1802.field_8638, 1));
        defaultFlowerMimicDrops.put(class_2246.field_10315, new class_1799((class_1935)class_1802.field_8635, 3));
        defaultFlowerMimicDrops.put(class_2246.field_10449, new class_1799((class_1935)class_1802.field_8786, 6));
        defaultFlowerMimicDrops.put(class_2246.field_10270, new class_1799((class_1935)class_1802.field_8073, 1));
        defaultFlowerMimicDrops.put(class_2246.field_10430, new class_1799((class_1935)class_1802.field_8354, 14));
        defaultFlowerMimicDrops.put(class_2246.field_10583, new class_1799((class_1935)class_1802.field_8626, 5));
        defaultFlowerMimicDrops.put(class_2246.field_42734, new class_1799((class_1935)class_1802.field_8814, 7));
        defaultFlowerMimicDrops.put(class_2246.field_10156, new class_1799((class_1935)class_1802.field_17534, 1));
        defaultFlowerMimicDrops.put(class_2246.field_10606, new class_1799((class_1935)class_1802.field_22021, 2));
    }

    public static class_1299<?> getDefaultMimicFromFlower(class_2248 block) {
        if (!defaultFlowerToMimic.containsKey(block)) {
            return null;
        }
        return defaultFlowerToMimic.get(block);
    }

    public static void attemptMimicConfigProcessing(class_1937 level) {
        if (!Variables.processedMimicConfig) {
            try {
                MimicData.setMimicConfig(level);
                Variables.processedMimicConfig = true;
            }
            catch (Exception ex) {
                System.out.println("[Flower Mimics] Error: Unable to generate flower mimic config list.");
            }
        }
    }

    public static void setMimicConfig(class_1937 level) throws IOException {
        class_2378 blockRegistry = level.method_30349().method_30530(class_7924.field_41254);
        class_2378 entityTypeRegistry = level.method_30349().method_30530(class_7924.field_41266);
        allFlowers = new ArrayList<class_2248>();
        PrintWriter flowerMimicsWriter = null;
        PrintWriter flowerItemDropsWriter = null;
        if (!(dir.isDirectory() && flowerMimicsFile.isFile() && flowerItemDropsFile.isFile())) {
            if (dir.mkdirs()) {
                flowerMimicsWriter = new PrintWriter(dirPath + File.separator + "flower_mimics.txt", StandardCharsets.UTF_8);
                flowerItemDropsWriter = new PrintWriter(dirPath + File.separator + "flower_item_drops.txt", StandardCharsets.UTF_8);
            }
            flowerToMimic = new HashMap();
            flowerMimicDrops = new HashMap();
        } else {
            String flowerMimicsContent = new String(Files.readAllBytes(Paths.get(dirPath + File.separator + "flower_mimics.txt", new String[0])));
            for (String line : flowerMimicsContent.split("\n")) {
                if (line.strip().equals("")) continue;
                String[] lspl = line.split(";");
                if (lspl.length < 2) {
                    Variables.logger.warn("[Flower Mimics] Unable to parse flower_mimics.txt line: " + line);
                    continue;
                }
                String flowerBlockRlString = lspl[0].strip();
                class_2960 flowerBlockResourceLocation = class_2960.method_60654((String)flowerBlockRlString);
                class_2248 flowerBlock = (class_2248)level.method_30349().method_30530(class_7923.field_41175.method_30517()).method_10223(flowerBlockResourceLocation);
                if (flowerBlock == null) {
                    Variables.logger.warn("[Flower Mimics] 1. Unable to find flower '" + flowerBlockRlString + "' in registry.");
                    continue;
                }
                String mimicEntityTypeString = lspl[1].strip();
                if (mimicEntityTypeString.equals("")) continue;
                class_2960 mimicEntityTypeResourceLocation = class_2960.method_60654((String)mimicEntityTypeString);
                class_1299 mimicEntityType = (class_1299)level.method_30349().method_30530(class_7923.field_41177.method_30517()).method_10223(mimicEntityTypeResourceLocation);
                if (mimicEntityType == null) {
                    Variables.logger.warn("[Flower Mimics] Unable to find entity type '" + mimicEntityTypeString + "' in registry.");
                    continue;
                }
                flowerToMimic.put(flowerBlock, mimicEntityType);
            }
            String flowerItemDropsContent = new String(Files.readAllBytes(Paths.get(dirPath + File.separator + "flower_item_drops.txt", new String[0])));
            for (String line : flowerItemDropsContent.split("\n")) {
                if (line.strip().equals("")) continue;
                String[] lspl = line.split(";");
                if (lspl.length < 2) {
                    Variables.logger.warn("[Flower Mimics] Unable to parse flower_item_drops.txt line: " + line);
                    continue;
                }
                String flowerBlockRlString = lspl[0].strip();
                class_2960 flowerBlockResourceLocation = class_2960.method_60654((String)flowerBlockRlString);
                class_2248 flowerBlock = (class_2248)level.method_30349().method_30530(class_7923.field_41175.method_30517()).method_10223(flowerBlockResourceLocation);
                if (flowerBlock == null) {
                    Variables.logger.warn("[Flower Mimics] 2. Unable to find flower '" + flowerBlockRlString + "' in registry.");
                    continue;
                }
                String itemStackNBTString = lspl[1].strip();
                try {
                    class_2487 newnbt = class_2522.method_10718((String)itemStackNBTString);
                    Optional optionalItemStack = class_1799.method_57360((class_7225.class_7874)level.method_30349(), (class_2520)newnbt);
                    optionalItemStack.ifPresent(itemStack -> flowerMimicDrops.put(flowerBlock, itemStack.method_7972()));
                }
                catch (CommandSyntaxException ex) {
                    Variables.logger.warn("[Flower Mimics] Unable to find itemstack from NBT: " + itemStackNBTString);
                }
            }
        }
        ArrayList<String> flowerRLStrings = new ArrayList<String>();
        HashMap<String, class_2248> flowerBlocks = new HashMap<String, class_2248>();
        for (class_2248 block : blockRegistry) {
            class_2960 rl;
            if (!Util.isFlower(block) || (rl = blockRegistry.method_10221((Object)block)) == null) continue;
            String flowerRLString = rl.toString();
            flowerRLStrings.add(flowerRLString);
            flowerBlocks.put(flowerRLString, block);
        }
        Collections.sort(flowerRLStrings);
        for (String flowerRLString : flowerRLStrings) {
            class_2248 flowerBlock = (class_2248)flowerBlocks.get(flowerRLString);
            allFlowers.add(flowerBlock);
            if (flowerMimicsWriter != null) {
                class_2960 mimicRl;
                String mimicRlString = " ";
                class_1299<?> defaultMimic = MimicData.getDefaultMimicFromFlower(flowerBlock);
                if (defaultMimic != null && (mimicRl = entityTypeRegistry.method_10221(defaultMimic)) != null) {
                    mimicRlString = mimicRl.toString();
                }
                flowerMimicsWriter.println(flowerRLString + " ; " + mimicRlString);
                flowerToMimic.put(flowerBlock, defaultMimic);
            }
            if (flowerItemDropsWriter == null) continue;
            class_1799 defaultFlowerMimicDropStack = new class_1799((class_1935)class_2246.field_10124, 1);
            if (defaultFlowerMimicDrops.containsKey(flowerBlock)) {
                defaultFlowerMimicDropStack = defaultFlowerMimicDrops.get(flowerBlock).method_7972();
            }
            String nBTString = ItemFunctions.getNBTStringFromItemStack((class_1937)level, (class_1799)defaultFlowerMimicDropStack);
            flowerItemDropsWriter.println(flowerRLString + " ; " + nBTString);
            flowerMimicDrops.put(flowerBlock, defaultFlowerMimicDropStack.method_7972());
        }
        if (flowerMimicsWriter != null) {
            flowerMimicsWriter.close();
        }
        if (flowerItemDropsWriter != null) {
            flowerItemDropsWriter.close();
        }
    }
}

