/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.flowermimics.forge.events;

import com.natamus.collective_common_forge.functions.WorldFunctions;
import com.natamus.flowermimics_common_forge.data.MimicData;
import com.natamus.flowermimics_common_forge.events.MimicEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ForgeMimicEvent {
    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        MimicData.attemptMimicConfigProcessing(level);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        Player player = e.player;
        Level level = player.level();
        if (level.isClientSide || !e.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        MimicEvent.onPlayerTick((ServerLevel)level, (ServerPlayer)player);
    }

    @SubscribeEvent
    public static void mobItemDrop(LivingDropsEvent e) {
        LivingEntity entity = e.getEntity();
        MimicEvent.mobItemDrop(entity.level(), (Entity)entity, e.getSource());
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent e) {
        Level level = e.level;
        if (level.isClientSide || !e.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        MimicEvent.onLevelTick((ServerLevel)level);
    }

    @SubscribeEvent
    public static void onNeighbourNotice(BlockEvent.NeighborNotifyEvent e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        MimicEvent.onNeighbourNotice(level, e.getPos(), e.getState(), e.getNotifiedSides(), e.getForceRedstoneUpdate());
    }
}

