/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.network;

import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.farmingforblockheads.api.MarketCategory;
import net.blay09.mods.farmingforblockheads.registry.MarketCategoryImpl;
import net.blay09.mods.farmingforblockheads.registry.MarketCategoryRegistry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class MarketCategoriesMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<MarketCategoriesMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"farmingforblockheads", (String)"market_categories"));
    private final Map<ResourceLocation, MarketCategory> categories;

    public MarketCategoriesMessage(Map<ResourceLocation, MarketCategory> categories) {
        this.categories = categories;
    }

    public static MarketCategoriesMessage decode(RegistryFriendlyByteBuf buf) {
        int count = buf.readInt();
        HashMap<ResourceLocation, MarketCategory> categories = new HashMap<ResourceLocation, MarketCategory>();
        for (int i = 0; i < count; ++i) {
            ResourceLocation id = buf.readResourceLocation();
            ItemStack iconStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            int sortIndex = buf.readInt();
            Component tooltip = (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode((Object)buf);
            MarketCategoryImpl category = new MarketCategoryImpl(iconStack, sortIndex, tooltip);
            categories.put(id, category);
        }
        return new MarketCategoriesMessage(categories);
    }

    public static void encode(RegistryFriendlyByteBuf buf, MarketCategoriesMessage message) {
        buf.writeInt(message.categories.size());
        message.categories.forEach((id, category) -> {
            buf.writeResourceLocation(id);
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)category.iconStack());
            buf.writeInt(category.sortIndex());
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buf, (Object)category.tooltip());
        });
    }

    public static void handle(Player player, MarketCategoriesMessage message) {
        MarketCategoryRegistry.INSTANCE.load(message.categories);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

