/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.cheaterpaul.fallingleaves.FallingLeavesMod;
import de.cheaterpaul.fallingleaves.data.LeafLoader;
import de.cheaterpaul.fallingleaves.data.LeafTypeLoader;
import de.cheaterpaul.fallingleaves.util.Wind;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class FallingLeafParticle
extends TextureSheetParticle {
    public static final ParticleRenderType LEAVES_SHEET = new ParticleRenderType(){

        @NotNull
        public BufferBuilder begin(Tesselator tesselator, @NotNull TextureManager textureManager) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)LeafTypeLoader.LEAVES_ATLAS);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }

        public String toString() {
            return "FALLINGLEAVES_PARTICLE_SHEET_TRANSLUCENT";
        }
    };
    protected static final float TAU = (float)Math.PI * 2;
    protected static final int FADE_DURATION = 16;
    protected static final double WATER_FRICTION = 0.05;
    protected final float windCoefficient;
    protected final float maxRotateSpeed;
    protected final int maxRotateTime;
    protected int rotateTime = 0;
    private static final double MAXIMUM_COLLISION_VELOCITY_SQUARED = Mth.square((double)100.0);

    protected FallingLeafParticle(ClientLevel clientWorld, double x, double y, double z, double r, double g, double b, LeafTypeLoader.ParticleProvider provider) {
        super(clientWorld, x, y, z, 0.0, 0.0, 0.0);
        this.pickSprite((SpriteSet)provider.getSpriteSet());
        this.gravity = 0.08f + this.random.nextFloat() * 0.04f;
        this.windCoefficient = 0.6f + this.random.nextFloat() * 0.4f;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.hasPhysics = true;
        this.lifetime = (int)((float)((Integer)FallingLeavesMod.CONFIG.leafLifespan.get()).intValue() * provider.lifeSpawnModifier());
        this.setSize(0.3f, 0.3f);
        this.rCol = (float)r;
        this.gCol = (float)g;
        this.bCol = (float)b;
        this.maxRotateTime = (3 + this.random.nextInt(5)) * 20;
        this.maxRotateSpeed = (float)(this.random.nextBoolean() ? -1 : 1) * (0.1f + 2.4f * this.random.nextFloat()) * ((float)Math.PI * 2) / 20.0f;
        this.roll = this.oRoll = this.random.nextFloat() * ((float)Math.PI * 2);
        float mod = (2.0f + this.random.nextFloat()) / 2.5f;
        this.quadSize = (float)((Integer)FallingLeavesMod.CONFIG.leafSize.get()).intValue() / 50.0f * provider.sizeModifier() * mod;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.oRoll = this.roll;
        ++this.age;
        if (this.age >= this.lifetime + 1 - 16) {
            this.alpha -= 0.0625f;
        }
        if (this.age >= this.lifetime) {
            this.remove();
            return;
        }
        if (this.level.getFluidState(new BlockPos((int)this.x, (int)this.y, (int)this.z)).is(FluidTags.WATER)) {
            this.yd = 0.0;
            this.rotateTime = 0;
            this.xd *= 0.95;
            this.zd *= 0.95;
        } else {
            this.yd -= 0.04 * (double)this.gravity;
            if (!this.onGround) {
                this.rotateTime = Math.min(this.rotateTime + 1, this.maxRotateTime);
                this.roll += (float)this.rotateTime / (float)this.maxRotateTime * this.maxRotateSpeed;
                this.xd += ((double)Wind.windX - this.xd) * (double)this.windCoefficient / 60.0;
                this.zd += ((double)Wind.windZ - this.zd) * (double)this.windCoefficient / 60.0;
            } else {
                this.rotateTime = 0;
                this.xd = 0.0;
                this.zd = 0.0;
            }
        }
        this.move(this.xd, this.yd, this.zd);
    }

    public void move(double pX, double pY, double pZ) {
        double d0 = pX;
        double d1 = pY;
        double d2 = pZ;
        if (this.hasPhysics && (pX != 0.0 || pY != 0.0 || pZ != 0.0) && pX * pX + pY * pY + pZ * pZ < MAXIMUM_COLLISION_VELOCITY_SQUARED) {
            Vec3 vec3 = Entity.collideBoundingBox(null, (Vec3)new Vec3(pX, pY, pZ), (AABB)this.getBoundingBox(), (Level)this.level, List.of());
            pX = vec3.x;
            pY = vec3.y;
            pZ = vec3.z;
            List entities = this.level.getEntities(null, this.getBoundingBox());
            if (!entities.isEmpty() && this.random.nextFloat() > 0.4f) {
                Entity first = (Entity)entities.getFirst();
                pX += first.getDeltaMovement().x;
                pZ += first.getDeltaMovement().z;
            }
        }
        if (pX != 0.0 || pY != 0.0 || pZ != 0.0) {
            this.setBoundingBox(this.getBoundingBox().move(pX, pY, pZ));
            this.setLocationFromBoundingbox();
        }
        boolean bl = this.onGround = d1 != pY && d1 < 0.0;
        if (d0 != pX) {
            this.xd = 0.0;
        }
        if (d2 != pZ) {
            this.zd = 0.0;
        }
    }

    public void render(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        Quaternionf q = new Quaternionf();
        if (this.onGround) {
            q.rotateX(-1.5707964f);
            q.rotateZ((float)((Object)((Object)this)).hashCode());
            Vec3 pos = this.getPos();
            Vec3 position = pRenderInfo.getPosition();
            Vec3 subtract = position.subtract(pos);
            if (subtract.y < 0.0) {
                q.rotateY((float)Math.PI);
                q.rotateZ(1.5707964f);
            }
        } else {
            this.getFacingCameraMode().setRotation(q, pRenderInfo, pPartialTicks);
            if ((double)this.roll != 0.0) {
                q.rotateZ(Mth.lerp((float)pPartialTicks, (float)this.oRoll, (float)this.roll));
            }
        }
        super.renderRotatedQuad(pBuffer, pRenderInfo, q, pPartialTicks);
    }

    protected void renderRotatedQuad(VertexConsumer pBuffer, Quaternionf pQuaternion, float pX, float pY, float pZ, float pPartialTicks) {
        super.renderRotatedQuad(pBuffer, pQuaternion, pX, pY + (switch (((Object)((Object)this)).hashCode() % 3) {
            case 0 -> 0.01f;
            case 1 -> 0.02f;
            default -> 0.03f;
        }), pZ, pPartialTicks);
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return LEAVES_SHEET;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LeavesParticleFactory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(@Nullable SimpleParticleType parameters, @NotNull ClientLevel world, double x, double y, double z, double r, double g, double b) {
            return new FallingLeafParticle(world, x, y, z, r, g, b, LeafLoader.getSpriteForLeafType(FallingLeavesMod.DEFAULT));
        }

        public Particle createParticle(@Nullable SimpleParticleType parameters, @NotNull ClientLevel world, double x, double y, double z, double r, double g, double b, LeafTypeLoader.ParticleProvider spriteSet) {
            return new FallingLeafParticle(world, x, y, z, r, g, b, spriteSet);
        }
    }
}

