/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.tesla;

import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.util.Simulation;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.network.packet.EntitiesElectrocutedPacket;

public final class LethalTeslaCoilComponent
implements IComponent {
    private final MachineBlockEntity machine;
    private final Supplier<Float> damageAmount;
    private final EnergyComponent energy;
    private final Supplier<Long> energyCost;
    private final Supplier<Integer> range;
    private final Supplier<Long> damageInterval;
    private final Supplier<DamageSource> damageSource;
    private int entityCount;
    private long tick;

    public LethalTeslaCoilComponent(MachineBlockEntity machine, Supplier<Float> damageAmount, EnergyComponent energy, Supplier<Long> energyCost, Supplier<Integer> range, Supplier<Long> damageInterval, Supplier<DamageSource> damageSource) {
        this.machine = machine;
        this.damageAmount = damageAmount;
        this.energy = energy;
        this.energyCost = energyCost;
        this.range = range;
        this.damageInterval = damageInterval;
        this.damageSource = damageSource;
    }

    public boolean hasNearbyEntities() {
        return this.entityCount > 0;
    }

    private AABB getDamageArea() {
        int range = EI.config().lethalTeslaCoil().range();
        Vec3 center = this.machine.getBlockPos().getCenter();
        return new AABB(center.subtract((double)range, (double)range, (double)range).subtract(0.5, 0.5, 0.5), center.add((double)range, (double)range, (double)range).add(0.5, 0.5, 0.5));
    }

    private List<Entity> getEntitiesInDamageArea() {
        return this.machine.getLevel().getEntities((Entity)null, this.getDamageArea(), entity -> entity.isAlive() && entity instanceof LivingEntity && !(entity instanceof Player));
    }

    public boolean tick() {
        Level level = this.machine.getLevel();
        BlockPos worldPosition = this.machine.getBlockPos();
        boolean active = false;
        float damage = this.damageAmount.get().floatValue();
        if (damage > 0.0f) {
            long energyCost = this.energyCost.get();
            active = this.energy.consumeEu(energyCost, Simulation.SIMULATE) == energyCost;
            List<Entity> entities = this.getEntitiesInDamageArea();
            int originalEntityCount = this.entityCount;
            this.entityCount = entities.size();
            if (this.entityCount != originalEntityCount) {
                this.machine.sync(false);
            }
            if (active && this.tick++ % this.damageInterval.get() == 0L) {
                this.energy.consumeEu(energyCost, Simulation.ACT);
                DamageSource source = this.damageSource.get();
                if (!entities.isEmpty()) {
                    IntArrayList entityIds = new IntArrayList();
                    for (Entity entity : entities) {
                        entity.hurt(source, damage);
                        entityIds.add(entity.getId());
                    }
                    new EntitiesElectrocutedPacket((IntList)entityIds).broadcastToClients((ServerLevel)level, (Vec3i)worldPosition, 32.0);
                }
            }
        } else {
            this.entityCount = 0;
        }
        return active;
    }

    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
    }

    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
    }

    public void writeClientNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt("damaging_entities", this.entityCount);
    }

    public void readClientNbt(CompoundTag tag, HolderLookup.Provider registries) {
        this.entityCount = tag.getInt("damaging_entities");
    }
}

