/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.farmer.harvesting.harvestable;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.swedz.extended_industrialization.machines.component.farmer.harvesting.HarvestingContext;
import net.swedz.extended_industrialization.machines.component.farmer.harvesting.LootTableHarvestableBehavior;

public final class GrowingPlantHarvestable
implements LootTableHarvestableBehavior {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isValidBlock(BlockState state) {
        Block block = state.getBlock();
        if (!(block instanceof GrowingPlantBlock)) return false;
        GrowingPlantBlock block2 = (GrowingPlantBlock)block;
        if (block2.growthDirection != Direction.UP) return false;
        return true;
    }

    public boolean matches(HarvestingContext context) {
        return GrowingPlantHarvestable.isValidBlock(context.state());
    }

    @Override
    public boolean isFullyGrown(HarvestingContext context) {
        return true;
    }

    @Override
    public List<BlockPos> getBlocks(HarvestingContext context) {
        ArrayList blocks = Lists.newArrayList();
        for (int y = 0; y <= 26; ++y) {
            BlockPos pos = context.pos().above(y);
            BlockState state = context.level().getBlockState(pos);
            if (!GrowingPlantHarvestable.isValidBlock(state)) break;
            blocks.add(pos);
        }
        return blocks.size() > 1 ? blocks.reversed() : List.of();
    }
}

