/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.chainer;

import aztech.modern_industrialization.machines.IComponent;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.swedz.extended_industrialization.EILocalizedListeners;
import net.swedz.extended_industrialization.machines.blockentity.MachineChainerMachineBlockEntity;
import net.swedz.extended_industrialization.machines.component.chainer.ChainerElement;
import net.swedz.extended_industrialization.machines.component.chainer.ChainerLinks;
import net.swedz.extended_industrialization.machines.component.chainer.handler.ChainerEnergyHandler;
import net.swedz.extended_industrialization.machines.component.chainer.handler.ChainerFluidHandler;
import net.swedz.extended_industrialization.machines.component.chainer.handler.ChainerItemHandler;
import net.swedz.tesseract.neoforge.localizedlistener.LocalizedListener;

public final class ChainerComponent
implements IComponent,
ChainerElement {
    private final MachineChainerMachineBlockEntity machine;
    private final LocalizedListener<BlockEvent.NeighborNotifyEvent> listenerNeighborNotify;
    private final ChainerLinks links;
    private final ChainerItemHandler itemHandler;
    private final ChainerFluidHandler fluidHandler;
    private final ChainerEnergyHandler insertableEnergyHandler;
    private final ChainerEnergyHandler extractableEnergyHandler;
    private Set<ChunkPos> previousSpannedChunks = Set.of();

    public ChainerComponent(MachineChainerMachineBlockEntity machine, int maxConnectedMachines, Supplier<Boolean> allowOperation) {
        this.machine = machine;
        this.links = new ChainerLinks(machine, maxConnectedMachines, allowOperation);
        this.itemHandler = new ChainerItemHandler(this.links);
        this.fluidHandler = new ChainerFluidHandler(this.links);
        this.insertableEnergyHandler = new ChainerEnergyHandler(this.links, machine::getCableTier, true);
        this.extractableEnergyHandler = new ChainerEnergyHandler(this.links, machine::getCableTier, false);
        this.listenerNeighborNotify = event -> {
            BlockPos pos = event.getPos();
            if (this.links.origin().equals((Object)pos) || this.links.contains(pos) || this.links.isAfter(pos) || this.links.isFailPosition(pos)) {
                machine.buildLinks();
            }
        };
    }

    public Level level() {
        return this.machine.getLevel();
    }

    public ChainerLinks links() {
        return this.links;
    }

    public ChainerItemHandler itemHandler() {
        return this.itemHandler;
    }

    public ChainerFluidHandler fluidHandler() {
        return this.fluidHandler;
    }

    public ChainerEnergyHandler insertableEnergyHandler() {
        return this.insertableEnergyHandler;
    }

    public ChainerEnergyHandler extractableEnergyHandler() {
        return this.extractableEnergyHandler;
    }

    public void registerListeners() {
        if (!this.previousSpannedChunks.isEmpty()) {
            throw new IllegalStateException("Cannot register listeners for a chainer that already has listeners registered");
        }
        Set<ChunkPos> spannedChunks = this.links.getSpannedChunks(true, true);
        EILocalizedListeners.INSTANCE.register(this.level(), spannedChunks, BlockEvent.NeighborNotifyEvent.class, this.listenerNeighborNotify);
        this.previousSpannedChunks = spannedChunks;
    }

    public void unregisterListeners() {
        if (!this.previousSpannedChunks.isEmpty()) {
            EILocalizedListeners.INSTANCE.unregister(this.level(), this.previousSpannedChunks, BlockEvent.NeighborNotifyEvent.class, this.listenerNeighborNotify);
            this.previousSpannedChunks = Set.of();
        }
    }

    private void forEachElement(Consumer<ChainerElement> action) {
        List.of(this.links, this.itemHandler, this.fluidHandler, this.insertableEnergyHandler, this.extractableEnergyHandler).forEach(action);
    }

    @Override
    public void clear() {
        this.forEachElement(ChainerElement::clear);
    }

    @Override
    public void invalidate() {
        this.forEachElement(ChainerElement::invalidate);
    }

    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt("connected_machines", this.links.count());
        this.links.failPosition().ifPresent(pos -> tag.putLong("fail_position", pos.asLong()));
    }

    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        this.links.count(tag.getInt("connected_machines"));
        if (tag.contains("fail_position", 4)) {
            this.links.failPosition(BlockPos.of((long)tag.getLong("fail_position")));
        } else {
            this.links.failPosition(null);
        }
    }
}

