/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity.multiblock.farmer;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.ShapeSelection;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.swedz.extended_industrialization.EITags;
import net.swedz.extended_industrialization.EIText;
import net.swedz.extended_industrialization.machines.blockentity.multiblock.farmer.FarmerShapeMatcher;
import net.swedz.extended_industrialization.machines.component.farmer.FarmerComponent;
import net.swedz.extended_industrialization.machines.component.farmer.PlantingMode;
import net.swedz.extended_industrialization.machines.component.farmer.task.FarmerProcessRates;
import net.swedz.tesseract.neoforge.compat.mi.helper.CommonGuiComponents;
import net.swedz.tesseract.neoforge.compat.mi.machine.blockentity.multiblock.BasicMultiblockMachineBlockEntity;
import net.swedz.tesseract.neoforge.compat.mi.machine.multiblock.member.PredicateSimpleMember;
import net.swedz.tesseract.neoforge.compat.mi.tooltip.MICompatibleTextLine;
import net.swedz.tesseract.neoforge.tooltip.TranslatableTextEnum;

public abstract class FarmerBlockEntity
extends BasicMultiblockMachineBlockEntity {
    private static final int SHAPE_RADIUS_START = 3;
    private static final int SHAPE_RADIUS_LEVEL_MULTIPLIER = 2;
    private static final Component[] SHAPE_TRANSLATIONS = new Component[]{MIText.ShapeTextSmall.text(), MIText.ShapeTextMedium.text(), MIText.ShapeTextLarge.text(), MIText.ShapeTextExtreme.text()};
    protected final ShapeWrapper shapes;
    protected final long baseEuCost;
    protected final FarmerComponent farmer;

    public FarmerBlockEntity(BEP bep, ResourceLocation blockId, long baseEuCost, PlantingMode defaultPlantingMode, boolean canChoosePlantingMode, FarmerProcessRates processRates, ShapeWrapper shapes) {
        super(bep, new MachineGuiParameters.Builder(blockId, false).backgroundHeight(200).build(), shapes.shapeTemplates());
        this.shapes = shapes;
        this.baseEuCost = baseEuCost;
        this.farmer = new FarmerComponent(this, this.inventory, defaultPlantingMode, processRates);
        this.registerComponents(new IComponent[]{this.farmer});
        this.registerGuiComponent(new GuiComponent.Server[]{CommonGuiComponents.standardMultiblockScreen((MultiblockMachineBlockEntity)this, (IsActiveComponent)this.isActive)});
        ArrayList lines = Lists.newArrayList();
        ArrayList sizes = Lists.newArrayList();
        for (int i = 0; i < 4 && i < shapes.shapeTemplates().length; ++i) {
            sizes.add(SHAPE_TRANSLATIONS[i]);
        }
        lines.add(new ShapeSelection.LineInfo(sizes.size(), (List)sizes, true));
        lines.add(new ShapeSelection.LineInfo(2, List.of(EIText.FARMER_NOT_TILLING.text(), EIText.FARMER_TILLING.text()), true));
        if (canChoosePlantingMode) {
            lines.add(new ShapeSelection.LineInfo(PlantingMode.values().length, Stream.of(PlantingMode.values()).map(PlantingMode::textComponent).toList(), true));
        }
        this.registerGuiComponent(new GuiComponent.Server[]{new ShapeSelection.Server(new ShapeSelection.Behavior(){

            public void handleClick(int line, int delta) {
                if (line == 0) {
                    FarmerBlockEntity.this.activeShape.incrementShape((MultiblockMachineBlockEntity)FarmerBlockEntity.this, delta);
                } else if (line == 1) {
                    if (delta > 0) {
                        FarmerBlockEntity.this.farmer.tilling = true;
                    } else if (delta < 0) {
                        FarmerBlockEntity.this.farmer.tilling = false;
                    }
                } else if (line == 2) {
                    int newIndex = FarmerBlockEntity.this.farmer.plantingMode.ordinal() + delta;
                    FarmerBlockEntity.this.farmer.plantingMode = PlantingMode.fromIndex(newIndex);
                }
            }

            public int getCurrentIndex(int line) {
                if (line == 0) {
                    return FarmerBlockEntity.this.activeShape.getActiveShapeIndex();
                }
                if (line == 1) {
                    return FarmerBlockEntity.this.farmer.tilling ? 1 : 0;
                }
                if (line == 2) {
                    return FarmerBlockEntity.this.farmer.plantingMode.ordinal();
                }
                throw new IllegalStateException();
            }
        }, lines.toArray(new ShapeSelection.LineInfo[0]))});
    }

    public CableTier getHighestCableTier() {
        return null;
    }

    public long getEuCost() {
        return this.baseEuCost;
    }

    public abstract long consumeEu(long var1);

    public ShapeMatcher createShapeMatcher() {
        return new FarmerShapeMatcher(this.level, this.worldPosition, this.orientation.facingDirection, this.getActiveShape(), this.farmer);
    }

    protected void onRematch(ShapeMatcher shapeMatcher) {
        super.onRematch(shapeMatcher);
        if (shapeMatcher.isMatchSuccessful()) {
            List<BlockPos> offsets = this.shapes.dirtPositions()[this.activeShape.getActiveShapeIndex()];
            this.farmer.fromOffsets(this.worldPosition, this.orientation.facingDirection, offsets);
            this.farmer.updateStackListeners();
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            return;
        }
        if (this.isEnabled() && this.isShapeValid()) {
            long eu = this.consumeEu(this.getEuCost());
            boolean active = eu > 0L;
            this.updateActive(active);
            if (active) {
                this.farmer.tick();
            }
        } else {
            this.updateActive(false);
        }
    }

    public List<Component> getTooltips() {
        ArrayList lines = Lists.newArrayList();
        lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.FARMER_TASK_TOOLTIP).arg((Object)this.baseEuCost, MITooltips.EU_PER_TICK_PARSER));
        lines.addAll(this.farmer.getTaskTooltipLines());
        return lines;
    }

    public static final class ShapeWrapper {
        private static final SimpleMember DIRT = new PredicateSimpleMember(state -> state.is(EITags.Blocks.FARMER_DIRT) || state.getFluidState().is((Fluid)Fluids.WATER) || state.getFluidState().is((Fluid)Fluids.FLOWING_WATER), Blocks.DIRT);
        private final ShapeTemplate[] shapeTemplates;
        private final List<BlockPos>[] dirtPositions;
        private SimpleMember casingBase;
        private SimpleMember casingPipe;
        private MachineCasing hatch;
        private boolean electric;

        public static ShapeWrapper of(int maxHeight) {
            return new ShapeWrapper(maxHeight);
        }

        public ShapeWrapper(int maxHeight) {
            this.shapeTemplates = new ShapeTemplate[maxHeight];
            this.dirtPositions = new List[maxHeight];
        }

        public ShapeWrapper withCasing(SimpleMember base, SimpleMember pipe, MachineCasing hatch) {
            this.casingBase = base;
            this.casingPipe = pipe;
            this.hatch = hatch;
            return this;
        }

        public ShapeWrapper withElectric() {
            this.electric = true;
            return this;
        }

        public ShapeWrapper complete() {
            HatchFlags.Builder hatchFlagsBuilder = new HatchFlags.Builder();
            if (this.electric) {
                hatchFlagsBuilder.with(HatchType.ENERGY_INPUT);
            }
            HatchFlags hatchFlags = hatchFlagsBuilder.with(new HatchType[]{HatchType.ITEM_INPUT, HatchType.ITEM_OUTPUT, HatchType.FLUID_INPUT}).build();
            for (int i = 0; i < this.shapeTemplates.length; ++i) {
                ShapeTemplate.Builder builder = new ShapeTemplate.Builder(this.hatch);
                int height = i + 4;
                for (int y = 0; y > -height; --y) {
                    boolean bottom = y == -height + 1;
                    boolean top = y == 0;
                    boolean topSecond = y == -1;
                    boolean middle = !bottom && !top && !topSecond;
                    builder.add3by3(y, middle ? this.casingPipe : this.casingBase, middle, (HatchFlags)(middle ? hatchFlags : null));
                    if (!middle) continue;
                    builder.add(0, y, 1, this.casingPipe);
                }
                ArrayList dirtBlocks = Lists.newArrayList();
                double maxDistance = 4.5 + (double)(i * 2);
                int maxDistanceRounded = (int)Math.ceil(maxDistance);
                int maxDistanceSquared = (int)Math.pow(maxDistance, 2.0);
                for (int x = -maxDistanceRounded; x <= maxDistanceRounded; ++x) {
                    for (int z = -maxDistanceRounded; z <= maxDistanceRounded; ++z) {
                        int distance;
                        if (Math.abs(x) <= 1 && Math.abs(z) <= 1 || (distance = (int)(Math.pow(x, 2.0) + Math.pow(z, 2.0))) >= maxDistanceSquared) continue;
                        builder.add(x, -1, z + 1, DIRT);
                        dirtBlocks.add(new BlockPos(x, -1, z + 1));
                    }
                }
                this.shapeTemplates[i] = builder.build();
                this.dirtPositions[i] = Collections.unmodifiableList(dirtBlocks);
            }
            return this;
        }

        public ShapeTemplate[] shapeTemplates() {
            return this.shapeTemplates;
        }

        public List<BlockPos>[] dirtPositions() {
            return this.dirtPositions;
        }
    }
}

