/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.client.ber.chainer;

import aztech.modern_industrialization.MITags;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.swedz.extended_industrialization.client.ber.chainer.MachineChainerBlockEntityRenderer;
import net.swedz.extended_industrialization.machines.blockentity.MachineChainerMachineBlockEntity;
import net.swedz.extended_industrialization.machines.component.chainer.ChainerLinks;
import net.swedz.tesseract.neoforge.helper.CubeOverlayRenderHelper;

public final class MachineChainerHighlightRenderer
extends MachineChainerBlockEntityRenderer {
    private static final int COLOR_SUCCESS = 0x6FFF6F;
    private static final int COLOR_FAILURE = 0xFF6F6F;
    private static final String ARROW_LEFT = "\u2190";
    private static final String ARROW_UP = "\u2191";
    private static final String ARROW_RIGHT = "\u2192";
    private static final String ARROW_DOWN = "\u2193";

    public MachineChainerHighlightRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public boolean shouldRenderOffScreen(MachineChainerMachineBlockEntity machine) {
        return true;
    }

    public AABB getRenderBoundingBox(MachineChainerMachineBlockEntity machine) {
        ChainerLinks links = machine.getChainerComponent().links();
        boolean hasConnections = links.hasConnections();
        boolean hasFailure = links.failPosition().isPresent();
        if (hasConnections || hasFailure) {
            BlockPos endPos = hasFailure ? links.failPosition().get() : links.position(links.count() + 1);
            return new AABB(Vec3.atLowerCornerOf((Vec3i)machine.getBlockPos()), Vec3.atLowerCornerOf((Vec3i)endPos).add(1.0, 1.0, 1.0));
        }
        return super.getRenderBoundingBox((BlockEntity)machine);
    }

    @Override
    public void render(MachineChainerMachineBlockEntity machine, float tickDelta, PoseStack matrices, MultiBufferSource buffer, int light, int overlay) {
        super.render(machine, tickDelta, matrices, buffer, light, overlay);
        BlockPos originPos = machine.getBlockPos();
        ChainerLinks links = machine.getChainerComponent().links();
        boolean holdingWrench = MachineChainerHighlightRenderer.isHoldingWrench();
        boolean holdingMachine = MachineChainerHighlightRenderer.isHoldingMachine(machine);
        if (holdingWrench || holdingMachine) {
            if (links.hasFailure()) {
                if (holdingWrench) {
                    this.renderPosition(machine, tickDelta, matrices, buffer, light, overlay, links.failPosition().orElseThrow(), 1.0f, 0.43359375f, 0.43359375f);
                }
            } else if (links.maxConnections() > links.count() && holdingMachine) {
                this.renderPosition(machine, tickDelta, matrices, buffer, light, overlay, links.positionAfter(), 0.43359375f, 1.0f, 0.43359375f);
            }
        }
        if (holdingWrench) {
            int count = links.count();
            int color = 0x6FFF6F;
            if (links.hasFailure()) {
                count = links.failPositionOffset();
                color = 0xFF6F6F;
            }
            this.renderNumbers(machine, tickDelta, matrices, buffer, light, overlay, count, color);
        }
    }

    private void renderPosition(MachineChainerMachineBlockEntity machine, float tickDelta, PoseStack matrices, MultiBufferSource buffer, int light, int overlay, BlockPos pos, float red, float green, float blue) {
        BlockPos originPos = machine.getBlockPos();
        BlockPos offset = pos.subtract((Vec3i)originPos);
        matrices.pushPose();
        matrices.translate((float)offset.getX(), (float)offset.getY(), (float)offset.getZ());
        matrices.translate(-0.005, -0.005, -0.005);
        matrices.scale(1.01f, 1.01f, 1.01f);
        CubeOverlayRenderHelper.render((PoseStack)matrices, (MultiBufferSource)buffer, (float)red, (float)green, (float)blue, (int)overlay);
        matrices.popPose();
    }

    private Direction pickNumberRenderFace(MachineChainerMachineBlockEntity machine) {
        int playerY = (int)Math.round(Minecraft.getInstance().player.getY());
        Direction machineDirection = machine.orientation.facingDirection;
        if (machineDirection.getAxis().isHorizontal()) {
            int machineY = machine.getBlockPos().getY();
            if (playerY == machineY || playerY == machineY - 1) {
                return Direction.fromYRot((double)Minecraft.getInstance().player.yHeadRot).getOpposite();
            }
            if (playerY < machineY) {
                return Direction.DOWN;
            }
            return Direction.UP;
        }
        int machineEndY = machine.getChainerComponent().links().positionAfter().getY();
        if (machineDirection == Direction.UP && playerY >= machineEndY) {
            return Direction.UP;
        }
        if (machineDirection == Direction.DOWN && playerY < machineEndY) {
            return Direction.DOWN;
        }
        return Direction.fromYRot((double)Minecraft.getInstance().player.yHeadRot).getOpposite();
    }

    private String pickArrowSymbol(MachineChainerMachineBlockEntity machine, Direction playerDirection, Direction renderDirection) {
        ChainerLinks links = machine.getChainerComponent().links();
        Direction machineDirection = links.direction();
        Direction playerDirectionLeft = playerDirection.getCounterClockWise();
        Direction playerDirectionRight = playerDirection.getClockWise();
        String arrow = "";
        if (renderDirection != machineDirection && renderDirection != machineDirection.getOpposite()) {
            if (playerDirection == machineDirection) {
                arrow = renderDirection == Direction.DOWN ? ARROW_DOWN : ARROW_UP;
            } else if (playerDirection == machineDirection.getOpposite()) {
                arrow = renderDirection == Direction.DOWN ? ARROW_UP : ARROW_DOWN;
            } else if (playerDirectionLeft == machineDirection) {
                arrow = ARROW_LEFT;
            } else if (playerDirectionRight == machineDirection) {
                arrow = ARROW_RIGHT;
            } else if (machineDirection == Direction.UP) {
                arrow = ARROW_UP;
            } else if (machineDirection == Direction.DOWN) {
                arrow = ARROW_DOWN;
            }
        }
        return arrow;
    }

    private void renderNumbers(MachineChainerMachineBlockEntity machine, float tickDelta, PoseStack matrices, MultiBufferSource buffer, int light, int overlay, int count, int color) {
        if (count <= 0) {
            return;
        }
        BlockPos originPos = machine.getBlockPos();
        ChainerLinks links = machine.getChainerComponent().links();
        Direction playerDirection = Direction.fromYRot((double)Minecraft.getInstance().player.yHeadRot);
        Direction renderDirection = this.pickNumberRenderFace(machine);
        String arrow = this.pickArrowSymbol(machine, playerDirection, renderDirection);
        for (int i = 1; i <= count; ++i) {
            BlockPos pos = links.position(i);
            BlockPos offset = pos.subtract((Vec3i)originPos);
            Vec3 center = Vec3.atCenterOf((Vec3i)offset);
            matrices.pushPose();
            float stepAmount = 0.52f;
            matrices.translate((float)center.x() + (float)renderDirection.getStepX() * stepAmount, (float)center.y() + (float)renderDirection.getStepY() * stepAmount, (float)center.z() + (float)renderDirection.getStepZ() * stepAmount);
            matrices.translate(-0.005, -0.005, -0.005);
            matrices.scale(0.03f, 0.03f, 0.03f);
            matrices.mulPose(playerDirection.getOpposite().getRotation());
            matrices.mulPose(renderDirection.getRotation());
            if (renderDirection == Direction.NORTH) {
                matrices.mulPose(Axis.ZP.rotationDegrees(180.0f));
            } else if (renderDirection == Direction.WEST) {
                matrices.mulPose(Axis.ZN.rotationDegrees(90.0f));
            } else if (renderDirection == Direction.EAST) {
                matrices.mulPose(Axis.ZP.rotationDegrees(90.0f));
            }
            this.renderCenteredText(Integer.toString(i), color, 0.0f, 0.0f, matrices, buffer);
            float arrowTextXOffset = 10.0f;
            float arrowTextYOffset = 10.0f;
            switch (arrow) {
                case "\u2190": {
                    this.renderCenteredText(arrow, color, -arrowTextXOffset, 0.0f, matrices, buffer);
                    break;
                }
                case "\u2191": {
                    this.renderCenteredText(arrow, color, 0.0f, -arrowTextYOffset, matrices, buffer);
                    break;
                }
                case "\u2192": {
                    this.renderCenteredText(arrow, color, arrowTextXOffset, 0.0f, matrices, buffer);
                    break;
                }
                case "\u2193": {
                    this.renderCenteredText(arrow, color, 0.0f, arrowTextYOffset, matrices, buffer);
                }
            }
            matrices.popPose();
        }
    }

    private void renderCenteredText(String text, int color, float x, float y, PoseStack matrices, MultiBufferSource buffer) {
        float textX = (float)Minecraft.getInstance().font.width(text) / 2.0f;
        Objects.requireNonNull(Minecraft.getInstance().font);
        float textY = 9.0f / 2.0f;
        matrices.pushPose();
        matrices.translate(1.0, 1.0, 0.01);
        Minecraft.getInstance().font.drawInBatch(text, -textX + x, -textY + y, 0, false, matrices.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        matrices.popPose();
        Minecraft.getInstance().font.drawInBatch(text, -textX + x, -textY + y, color, false, matrices.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    private static boolean isHoldingMachine(MachineChainerMachineBlockEntity machine) {
        LocalPlayer player = Minecraft.getInstance().player;
        return machine.getChainerComponent().links().test(player.getMainHandItem()).isSuccess() || machine.getChainerComponent().links().test(player.getOffhandItem()).isSuccess();
    }

    private static boolean isHoldingWrench() {
        LocalPlayer player = Minecraft.getInstance().player;
        return player.getMainHandItem().is(MITags.WRENCHES) || player.getOffhandItem().is(MITags.WRENCHES);
    }
}

