/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.client.ber.chainer;

import aztech.modern_industrialization.compat.sodium.SodiumCompat;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.ModelHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.pipeline.QuadBakingVertexConsumer;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.client.ber.chainer.MachineChainerHighlightRenderer;
import net.swedz.extended_industrialization.client.model.chainer.MachineChainerBakedModel;
import net.swedz.extended_industrialization.machines.blockentity.MachineChainerMachineBlockEntity;

public sealed class MachineChainerBlockEntityRenderer
implements BlockEntityRenderer<MachineChainerMachineBlockEntity>
permits MachineChainerHighlightRenderer {
    private final BlockModelShaper blockModels;
    private BlockState lastBlockState = null;
    private MachineChainerBakedModel model = null;
    private final Object[] quadCache = new Object[36];
    private static final Object NO_QUAD = new Object();

    public MachineChainerBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.blockModels = context.getBlockRenderDispatcher().getBlockModelShaper();
    }

    private BakedQuad getCachedQuad(MachineModelClientData data, Direction direction) {
        Object quad;
        Direction facing = data.frontDirection;
        int cachedQuadIndex = facing.ordinal() * 6 + direction.ordinal();
        if (this.quadCache[cachedQuadIndex] == null) {
            TextureAtlasSprite sprite;
            TextureAtlasSprite textureAtlasSprite = sprite = this.model == null ? null : MachineChainerBakedModel.getSprite(this.model.getSprites(), direction, facing, true);
            if (sprite != null) {
                QuadBakingVertexConsumer vc = new QuadBakingVertexConsumer();
                this.quadCache[cachedQuadIndex] = ModelHelper.bakeSprite((QuadBakingVertexConsumer)vc, (Direction)direction, (TextureAtlasSprite)sprite, (float)(-2.0f * MachineChainerBakedModel.Z_OFFSET));
            } else {
                this.quadCache[cachedQuadIndex] = NO_QUAD;
            }
        }
        return (quad = this.quadCache[cachedQuadIndex]) == NO_QUAD ? null : (BakedQuad)quad;
    }

    private MachineChainerBakedModel getMachineModel(BlockState state) {
        BakedModel bakedModel = this.blockModels.getBlockModel(state);
        if (bakedModel instanceof MachineChainerBakedModel) {
            MachineChainerBakedModel mbm = (MachineChainerBakedModel)bakedModel;
            return mbm;
        }
        EI.LOGGER.warn("Model {} should have been a MachineChainerBakedModel, but was {}", (Object)state, (Object)this.blockModels.getBlockModel(state).getClass());
        return null;
    }

    public void render(MachineChainerMachineBlockEntity machine, float tickDelta, PoseStack matrices, MultiBufferSource buffer, int light, int overlay) {
        BlockState state = machine.getBlockState();
        if (this.lastBlockState == null) {
            this.lastBlockState = state;
            this.model = this.getMachineModel(state);
        } else if (this.lastBlockState != state) {
            throw new IllegalStateException("Tried to use the same machine BER with two block states: " + String.valueOf(state) + " and " + String.valueOf(this.lastBlockState));
        }
        MachineModelClientData data = (MachineModelClientData)machine.getModelData().get(MachineModelClientData.KEY);
        if (data.isActive) {
            VertexConsumer vc = buffer.getBuffer(Sheets.cutoutBlockSheet());
            for (Direction direction : Direction.values()) {
                BakedQuad quad = this.getCachedQuad(data, direction);
                if (quad == null) continue;
                int faceLight = LevelRenderer.getLightColor((BlockAndTintGetter)machine.getLevel(), (BlockState)machine.getBlockState(), (BlockPos)machine.getBlockPos().relative(direction));
                vc.putBulkData(matrices.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, faceLight, OverlayTexture.NO_OVERLAY);
                SodiumCompat.markSpriteActive((TextureAtlasSprite)quad.getSprite());
            }
        }
    }

    public int getViewDistance() {
        return 256;
    }
}

