/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.EITags;
import net.swedz.extended_industrialization.EIText;
import net.swedz.extended_industrialization.datamap.EnchantmentModule;
import net.swedz.extended_industrialization.item.ElectricToolItem;
import net.swedz.extended_industrialization.item.PhotovoltaicCellItem;
import net.swedz.extended_industrialization.item.nanosuit.NanoSuitArmorItem;
import net.swedz.extended_industrialization.machines.blockentity.multiblock.LargeElectricFurnaceBlockEntity;
import net.swedz.extended_industrialization.machines.blockentity.multiblock.teslatower.TeslaTowerBlockEntity;
import net.swedz.extended_industrialization.machines.blockentity.multiblock.teslatower.TeslaTowerTier;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.api.WorldPos;
import net.swedz.tesseract.neoforge.api.tuple.Pair;
import net.swedz.tesseract.neoforge.compat.mi.tooltip.MICompatibleTextLine;
import net.swedz.tesseract.neoforge.compat.mi.tooltip.MIParser;
import net.swedz.tesseract.neoforge.tooltip.BiParser;
import net.swedz.tesseract.neoforge.tooltip.Parser;
import net.swedz.tesseract.neoforge.tooltip.TooltipAttachment;
import net.swedz.tesseract.neoforge.tooltip.TranslatableTextEnum;

public final class EITooltips {
    private static final BiParser<Boolean, Float> MAYBE_SPACED_PERCENTAGE_PARSER = (space, ratio) -> Component.literal((String)"%d%s%%".formatted((int)(ratio.floatValue() * 100.0f), space != false ? " " : "")).withStyle(MITooltips.NUMBER_TEXT);
    public static final Parser<Float> PERCENTAGE_PARSER = ratio -> MAYBE_SPACED_PERCENTAGE_PARSER.parse((Object)false, ratio);
    public static final Parser<Float> SPACED_PERCENTAGE_PARSER = ratio -> MAYBE_SPACED_PERCENTAGE_PARSER.parse((Object)true, ratio);
    public static final Parser<Long> TICKS_TO_MINUTES_PARSER = ticks -> {
        float minutes = (float)ticks.longValue() / 1200.0f;
        return Component.literal((String)"%.2f".formatted(Float.valueOf(minutes))).withStyle(MITooltips.NUMBER_TEXT);
    };
    public static final Parser<Integer> NUMBERED_LIST_BULLET_PARSER = number -> Component.literal((String)"%d)".formatted(number)).withStyle(MITooltips.HIGHLIGHT_STYLE);
    public static final Parser<Boolean> ACTIVATED_BOOLEAN_PARSER = value -> value != false ? EIText.ACTIVATED.text().withStyle(ChatFormatting.GREEN) : EIText.DEACTIVATED.text().withStyle(ChatFormatting.RED);
    public static final Parser<WorldPos> TESLA_NETWORK_KEY_PARSER = key -> Parser.GLOBAL_POS.withStyle(MITooltips.DEFAULT_STYLE).parse((Object)GlobalPos.of((ResourceKey)key.dimension(), (BlockPos)key.pos()));
    public static final Parser<String> KEYBIND_PARSER = Parser.KEYBIND.withStyle(MITooltips.HIGHLIGHT_STYLE);
    public static final Parser<Float> DAMAGE_PARSER = damage -> {
        MICompatibleTextLine line = damage.floatValue() == 2.1474836E9f ? EIText.DAMAGE.arg(Component.literal((String)"\u221e").withStyle(MITooltips.HIGHLIGHT_STYLE)) : ((damage = Float.valueOf(damage.floatValue() / 2.0f)).floatValue() % 1.0f == 0.0f ? EIText.DAMAGE.arg(damage.intValue()) : EIText.DAMAGE.arg(damage, 1, Parser.FLOAT));
        return line.withStyle(MITooltips.HIGHLIGHT_STYLE);
    };
    public static final TooltipAttachment ENERGY_STORED_ITEM = TooltipAttachment.singleLineOptional((stack, item) -> BuiltInRegistries.ITEM.getKey((Object)item).getNamespace().equals("extended_industrialization"), (flags, context, stack, item) -> {
        long capacity;
        ILongEnergyStorage energyStorage = (ILongEnergyStorage)stack.getCapability(EnergyApi.ITEM);
        if (energyStorage != null && (capacity = energyStorage.getCapacity()) > 0L) {
            return Optional.of(MICompatibleTextLine.line((MIText)MIText.EnergyStored).arg((Object)new MITooltips.NumberWithMax((Number)energyStorage.getAmount(), (Number)capacity), MITooltips.EU_MAXED_PARSER));
        }
        return Optional.empty();
    }).noShiftRequired();
    public static final TooltipAttachment MULCH_GANG_FOR_LIFE = TooltipAttachment.multilines(EIItems.MULCH, List.of(MICompatibleTextLine.line((TranslatableTextEnum)EIText.MULCH_GANG_FOR_LIFE_0, (Style)MITooltips.DEFAULT_STYLE.withItalic(Boolean.valueOf(true))), MICompatibleTextLine.line((TranslatableTextEnum)EIText.MULCH_GANG_FOR_LIFE_1, (Style)MITooltips.DEFAULT_STYLE.withItalic(Boolean.valueOf(true))))).noShiftRequired();
    public static final TooltipAttachment COILS_LEF = TooltipAttachment.singleLine((stack, item) -> {
        if (!(item instanceof BlockItem)) return false;
        BlockItem blockItem = (BlockItem)item;
        if (!LargeElectricFurnaceBlockEntity.getTiersByCoil().containsKey(BuiltInRegistries.BLOCK.getKey((Object)blockItem.getBlock()))) return false;
        return true;
    }, (flags, context, stack, item) -> {
        LargeElectricFurnaceBlockEntity.Tier tier = LargeElectricFurnaceBlockEntity.getTiersByCoil().get(BuiltInRegistries.BLOCK.getKey((Object)((BlockItem)stack.getItem()).getBlock()));
        int batchSize = tier.batchSize();
        float euCostMultiplier = tier.euCostMultiplier();
        return MICompatibleTextLine.line((TranslatableTextEnum)EIText.COILS_LEF_TIER).arg((Object)batchSize).arg((Object)Float.valueOf(euCostMultiplier), PERCENTAGE_PARSER);
    });
    public static final TooltipAttachment WINDINGS_TESLA = TooltipAttachment.singleLine((stack, item) -> {
        if (!(item instanceof BlockItem)) return false;
        BlockItem blockItem = (BlockItem)item;
        if (!TeslaTowerBlockEntity.getTiersByWinding().containsKey(BuiltInRegistries.BLOCK.getKey((Object)blockItem.getBlock()))) return false;
        return true;
    }, (flags, context, stack, item) -> {
        TeslaTowerTier tier = TeslaTowerBlockEntity.getTiersByWinding().get(BuiltInRegistries.BLOCK.getKey((Object)((BlockItem)stack.getItem()).getBlock()));
        return MICompatibleTextLine.line((TranslatableTextEnum)EIText.WINDINGS_TESLA_TOWER_TIER).arg((Object)tier.maxTransfer(), MITooltips.EU_PER_TICK_PARSER).arg((Object)tier.maxDistance()).arg((Object)tier.drain(), MITooltips.EU_PER_TICK_PARSER);
    });
    public static final TooltipAttachment PHOTOVOLTAIC_CELLS = TooltipAttachment.multilines(PhotovoltaicCellItem.class, (flags, context, stack, item) -> {
        int euPerTick = item.getEuPerTick();
        ArrayList lines = Lists.newArrayList();
        lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.PHOTOVOLTAIC_CELL_EU).arg((Object)euPerTick, MITooltips.EU_PER_TICK_PARSER));
        if (!item.lastsForever()) {
            int solarTicksRemaining = item.getSolarTicksRemaining(stack);
            lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.PHOTOVOLTAIC_CELL_REMAINING_OPERATION_TIME_MINUTES).arg((Object)solarTicksRemaining, TICKS_TO_MINUTES_PARSER));
        } else {
            lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.PHOTOVOLTAIC_CELL_REMAINING_OPERATION_TIME).arg((Object)Component.literal((String)"\u221e").withStyle(MITooltips.NUMBER_TEXT)));
        }
        return lines;
    });
    public static final TooltipAttachment STEAM_CHAINSAW = TooltipAttachment.multilines(EIItems.STEAM_CHAINSAW, List.of(MICompatibleTextLine.line((TranslatableTextEnum)EIText.STEAM_CHAINSAW_1).arg((Object)"use", KEYBIND_PARSER), MICompatibleTextLine.line((TranslatableTextEnum)EIText.STEAM_CHAINSAW_2).arg((Object)"use", KEYBIND_PARSER), MICompatibleTextLine.line((TranslatableTextEnum)EIText.STEAM_CHAINSAW_3).arg((Object)"sneak", KEYBIND_PARSER).arg((Object)"use", KEYBIND_PARSER)));
    public static final TooltipAttachment ROBOT_AUTO_FEEDER = TooltipAttachment.multilines(EIItems.ROBOT_AUTO_FEEDER, List.of(MICompatibleTextLine.line((TranslatableTextEnum)EIText.ROBOT_AUTO_FEEDER_HELP_1), MICompatibleTextLine.line((TranslatableTextEnum)EIText.ROBOT_AUTO_FEEDER_HELP_2)));
    public static final TooltipAttachment MACHINE_CONFIG_CARD = TooltipAttachment.multilines(EIItems.MACHINE_CONFIG_CARD, List.of(MICompatibleTextLine.line((TranslatableTextEnum)EIText.MACHINE_CONFIG_CARD_HELP_1).arg((Object)"sneak", KEYBIND_PARSER).arg((Object)"use", KEYBIND_PARSER), MICompatibleTextLine.line((TranslatableTextEnum)EIText.MACHINE_CONFIG_CARD_HELP_2).arg((Object)"use", KEYBIND_PARSER), MICompatibleTextLine.line((TranslatableTextEnum)EIText.MACHINE_CONFIG_CARD_HELP_3), MICompatibleTextLine.line((TranslatableTextEnum)EIText.MACHINE_CONFIG_CARD_HELP_4).arg((Object)"sneak", KEYBIND_PARSER).arg((Object)"use", KEYBIND_PARSER)));
    public static final TooltipAttachment TESLA_CALIBRATOR = TooltipAttachment.multilines(EIItems.TESLA_CALIBRATOR, List.of(MICompatibleTextLine.line((TranslatableTextEnum)EIText.TESLA_CALIBRATOR_HELP_1).arg((Object)"sneak", KEYBIND_PARSER).arg((Object)"use", KEYBIND_PARSER), MICompatibleTextLine.line((TranslatableTextEnum)EIText.TESLA_CALIBRATOR_HELP_2).arg((Object)"use", KEYBIND_PARSER), MICompatibleTextLine.line((TranslatableTextEnum)EIText.TESLA_CALIBRATOR_HELP_3), MICompatibleTextLine.line((TranslatableTextEnum)EIText.TESLA_CALIBRATOR_HELP_4).arg((Object)"sneak", KEYBIND_PARSER).arg((Object)"use", KEYBIND_PARSER)));
    public static final TooltipAttachment ELECTRIC_TOOL_HELP = TooltipAttachment.multilines(ElectricToolItem.class, (flags, context, stack, item) -> {
        ArrayList lines = Lists.newArrayList();
        lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.ELECTRIC_TOOL_HELP_1));
        if (stack.is(ItemTags.DYEABLE)) {
            lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.DYEABLE_HELP));
        }
        lines.add(MICompatibleTextLine.line((TranslatableTextEnum)(item.getToolType().includeLooting() ? EIText.ELECTRIC_TOOL_HELP_2_LOOTING : EIText.ELECTRIC_TOOL_HELP_2)).arg((Object)"sneak", KEYBIND_PARSER).arg((Object)"use", KEYBIND_PARSER));
        lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.ELECTRIC_TOOL_HELP_3).arg((Object)EIText.KEY_ALT.text().withStyle(MITooltips.NUMBER_TEXT)).arg((Object)EIText.KEY_MOUSE_SCROLL.text().withStyle(MITooltips.NUMBER_TEXT)));
        if (item.getToolType().canDo3by3()) {
            lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.ELECTRIC_TOOL_HELP_4).arg((Object)"%s.toggle_main_hand_ability".formatted("extended_industrialization"), KEYBIND_PARSER).arg((Object)"mouse.right", KEYBIND_PARSER));
        }
        return lines;
    });
    public static final TooltipAttachment NANO_SUIT_HELP = TooltipAttachment.multilines(NanoSuitArmorItem.class, (flags, context, stack, item) -> {
        ArrayList lines = Lists.newArrayList();
        lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.NANO_SUIT_HELP_1));
        lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.DYEABLE_AND_TRIMMABLE_HELP));
        item.ability().ifPresent(ability -> lines.addAll(ability.getHelpTooltipLines((NanoSuitArmorItem)item, stack)));
        return lines;
    });
    public static final TooltipAttachment MACHINE_CHAINER = TooltipAttachment.multilines(List.of(EI.id("machine_chainer")), List.of(MICompatibleTextLine.line((TranslatableTextEnum)EIText.MACHINE_CHAINER_HELP_1).arg((Object)EI.config().machineChainerMaxConnections()), MICompatibleTextLine.line((TranslatableTextEnum)EIText.MACHINE_CHAINER_HELP_2), MICompatibleTextLine.line((TranslatableTextEnum)EIText.MACHINE_CHAINER_HELP_3)));
    public static final TooltipAttachment HONEY_EXTRACTOR = TooltipAttachment.singleLine(List.of(EI.id("steel_honey_extractor"), EI.id("electric_honey_extractor")), (Component)MICompatibleTextLine.line((TranslatableTextEnum)EIText.HONEY_EXTRACTOR_HELP));
    public static final TooltipAttachment WASTE_COLLECTOR = TooltipAttachment.singleLine(List.of(EI.id("bronze_waste_collector"), EI.id("steel_waste_collector"), EI.id("electric_waste_collector")), (Component)MICompatibleTextLine.line((TranslatableTextEnum)EIText.WASTE_COLLECTOR_HELP));
    public static final TooltipAttachment TESLA_INTERDIMENSIONAL_UPGRADE = TooltipAttachment.singleLine(List.of(EI.id("tesla_interdimensional_upgrade")), (Component)MICompatibleTextLine.line((TranslatableTextEnum)EIText.TESLA_INTERDIMENSIONAL_UPGRADE_HELP));
    public static final TooltipAttachment TESLA_HANDHELD_RECEIVER = TooltipAttachment.multilines(List.of(EI.id("tesla_handheld_receiver")), List.of(MICompatibleTextLine.line((TranslatableTextEnum)EIText.TESLA_HANDHELD_HELP_1), MICompatibleTextLine.line((TranslatableTextEnum)EIText.TESLA_HANDHELD_HELP_2), MICompatibleTextLine.line((TranslatableTextEnum)EIText.TESLA_HANDHELD_HELP_3).arg((Object)"use", KEYBIND_PARSER), MICompatibleTextLine.line((TranslatableTextEnum)EIText.TESLA_HANDHELD_HELP_4).arg((Object)"sneak", KEYBIND_PARSER).arg((Object)"use", KEYBIND_PARSER)));
    private static final LinkedHashMap<TagKey<Item>, ResourceLocation> ENCHANTMENT_MODULE_MACHINES = Maps.newLinkedHashMap();
    public static final TooltipAttachment ENCHANTMENT_MODULE;

    public static void registerEnchantmentModuleMachine(TagKey<Item> tag, ResourceLocation machineId) {
        Assert.noneNull((Object[])new Object[]{tag, machineId});
        if (ENCHANTMENT_MODULE_MACHINES.put(tag, machineId) != null) {
            throw new IllegalArgumentException("Enchantment module machine already registered for tag " + String.valueOf(tag.location()));
        }
    }

    public static void init() {
    }

    static {
        EITooltips.registerEnchantmentModuleMachine(EITags.Items.EnchantmentModules.FARMER, EI.id("electric_farmer"));
        EITooltips.registerEnchantmentModuleMachine(EITags.Items.EnchantmentModules.LETHAL_TESLA_COIL, EI.id("lethal_tesla_coil"));
        ENCHANTMENT_MODULE = TooltipAttachment.multilinesOptional((flags, context, stack, item) -> {
            EnchantmentModule module = EnchantmentModule.getFor(item);
            if (module != null) {
                ArrayList lines = Lists.newArrayList();
                for (Map.Entry entry : ENCHANTMENT_MODULE_MACHINES.sequencedEntrySet()) {
                    if (!stack.is((TagKey)entry.getKey())) continue;
                    lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.ENCHANTMENT_MODULE_MACHINE).arg((Object)((Block)BuiltInRegistries.BLOCK.get((ResourceLocation)entry.getValue())), Parser.BLOCK.withStyle(MITooltips.HIGHLIGHT_STYLE)));
                }
                if (module.values().isEmpty()) {
                    lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.ENCHANTMENT_MODULE_SINGLE_VALUE).arg((Object)context.registries(), (Object)new Pair(module.enchantment(), (Object)module.fallback().level()), Parser.ENCHANTMENT_AND_LEVEL.withStyle(MITooltips.HIGHLIGHT_STYLE)).arg((Object)module.fallback().euCost(), MITooltips.EU_PER_TICK_PARSER));
                } else {
                    lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.ENCHANTMENT_MODULE_VALUES).arg((Object)context.registries(), module.enchantment(), Parser.ENCHANTMENT.withStyle(MITooltips.HIGHLIGHT_STYLE)));
                    for (CableTier cableTier : CableTier.allTiers()) {
                        EnchantmentModule.Value value = module.get(cableTier);
                        lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.VOLTAGE_VALUE_FOR_COST).arg((Object)cableTier, MIParser.CABLE_TIER_SHORT.withStyle(MITooltips.HIGHLIGHT_STYLE)).arg((Object)value.level(), Parser.ENCHANTMENT_LEVEL.withStyle(MITooltips.HIGHLIGHT_STYLE)).arg((Object)value.euCost(), MITooltips.EU_PER_TICK_PARSER));
                    }
                }
                return Optional.of(lines);
            }
            return Optional.empty();
        });
    }
}

