/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.swedz.extended_industrialization.EI;

public final class EITags {
    private static final Map<TagKey<Item>, String> TRANSLATIONS = Maps.newHashMap();

    public static Map<TagKey<Item>, String> translations() {
        return Collections.unmodifiableMap(TRANSLATIONS);
    }

    public static TagKey<Item> item(String path, String englishName) {
        TagKey tag = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)EI.id(path));
        TRANSLATIONS.put((TagKey<Item>)tag, englishName);
        return tag;
    }

    public static TagKey<Item> itemCommon(String path) {
        return TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }

    public static TagKey<Fluid> fluid(String path) {
        return TagKey.create((ResourceKey)BuiltInRegistries.FLUID.key(), (ResourceLocation)EI.id(path));
    }

    public static TagKey<Fluid> fluidCommon(String path) {
        return TagKey.create((ResourceKey)BuiltInRegistries.FLUID.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }

    public static TagKey<Block> block(String path) {
        return TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)EI.id(path));
    }

    public static TagKey<Block> blockCommon(String path) {
        return TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }

    public static final class GeneratedRecipesBlacklist {
        public static final TagKey<Item> CANNING_FOOD = EITags.item("generated_recipes_blacklist/canning_food", "Canning Food Generated Recipes Blacklist");
        public static final TagKey<Fluid> CANNING_BUCKETS = EITags.fluid("generated_recipes_blacklist/canning_buckets");
        public static final TagKey<Item> COMPOSTING = EITags.item("generated_recipes_blacklist/composting", "Composting Generated Recipes Blacklist");
    }

    public static final class Blocks {
        public static final TagKey<Block> FARMER_DIRT = EITags.block("farmer_dirt");
        public static final TagKey<Block> MACHINE_CHAINER_LINKABLE = EITags.block("machine_chainer/linkable");
        public static final TagKey<Block> MACHINE_CHAINER_RELAY = EITags.block("machine_chainer/relay");
    }

    public static final class Fluids {
        public static final TagKey<Fluid> HONEY = EITags.fluidCommon("honey");
    }

    public static final class Items {
        public static final TagKey<Item> FARMER_PLANTABLE = EITags.item("farmer_plantable", "Farmer Plantable");
        public static final TagKey<Item> FARMER_VOIDABLE = EITags.item("farmer_voidable", "Farmer Voidable");
        public static final TagKey<Item> PHOTOVOLTAIC_CELL = EITags.item("photovoltaic_cell", "Photovoltaic Cells");
        public static final TagKey<Item> RAINBOW_DYEABLE = EITags.item("rainbow_dyeable", "Rainbow Dyeable");
        public static final TagKey<Item> PROCESSING_ARRAY_BLACKLIST = EITags.item("processing_array_blacklist", "Processing Array Blacklist");

        public static final class EnchantmentModules {
            public static final TagKey<Item> FARMER = EITags.item("enchantment_modules/farmer", "Farmer Enchantment Modules");
            public static final TagKey<Item> LETHAL_TESLA_COIL = EITags.item("enchantment_modules/lethal_tesla_coil", "Lethal Tesla Coil Enchantment Modules");
        }
    }
}

