/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import aztech.modern_industrialization.api.energy.CableTier;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.loaders.ItemLayerModelBuilder;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIArmorMaterials;
import net.swedz.extended_industrialization.EIComponents;
import net.swedz.extended_industrialization.EISortOrder;
import net.swedz.extended_industrialization.EITags;
import net.swedz.extended_industrialization.component.RainbowDataComponent;
import net.swedz.extended_industrialization.item.ElectricToolItem;
import net.swedz.extended_industrialization.item.PhotovoltaicCellItem;
import net.swedz.extended_industrialization.item.RobotAutoFeederItem;
import net.swedz.extended_industrialization.item.SteamChainsawItem;
import net.swedz.extended_industrialization.item.machineconfig.MachineConfigCardItem;
import net.swedz.extended_industrialization.item.nanosuit.NanoSuitArmorItem;
import net.swedz.extended_industrialization.item.nanosuit.ability.NanoSuitAbility;
import net.swedz.extended_industrialization.item.nanosuit.decoration.NanoSuitDecoration;
import net.swedz.extended_industrialization.item.teslalinkable.TeslaCalibratorItem;
import net.swedz.extended_industrialization.item.teslalinkable.TeslaHandheldReceiverItem;
import net.swedz.tesseract.neoforge.registry.SortOrder;
import net.swedz.tesseract.neoforge.registry.common.CommonModelBuilders;
import net.swedz.tesseract.neoforge.registry.common.CommonRegistrations;
import net.swedz.tesseract.neoforge.registry.common.MICommonCapabitilies;
import net.swedz.tesseract.neoforge.registry.holder.ItemHolder;

public final class EIItems {
    public static final ItemHolder<SteamChainsawItem> STEAM_CHAINSAW = ((ItemHolder)EIItems.create("steam_chainsaw", "Steam Chainsaw", SteamChainsawItem::new, EISortOrder.GEAR).tag(new TagKey[]{ItemTags.AXES, ItemTags.HOES, ItemTags.SWORDS, Tags.Items.TOOLS_SHEAR})).withModelBuilder(CommonModelBuilders::handheld).register();
    public static final ItemHolder<ElectricToolItem> ELECTRIC_CHAINSAW = ((ItemHolder)((ItemHolder)EIItems.create("electric_chainsaw", "Electric Chainsaw", p -> new ElectricToolItem((Item.Properties)p, ElectricToolItem.Type.CHAINSAW), EISortOrder.GEAR).tag(new TagKey[]{ItemTags.AXES, ItemTags.HOES, ItemTags.SWORDS, Tags.Items.TOOLS_SHEAR})).withCapabilities(MICommonCapabitilies::simpleEnergyItem)).withModelBuilder(CommonModelBuilders::handheld).register();
    public static final ItemHolder<ElectricToolItem> ELECTRIC_MINING_DRILL = ((ItemHolder)((ItemHolder)EIItems.create("electric_mining_drill", "Electric Mining Drill", p -> new ElectricToolItem((Item.Properties)p, ElectricToolItem.Type.DRILL), EISortOrder.GEAR).tag(new TagKey[]{ItemTags.PICKAXES, ItemTags.SHOVELS})).withCapabilities(MICommonCapabitilies::simpleEnergyItem)).withModelBuilder(CommonModelBuilders::handheld).register();
    public static final ItemHolder<ElectricToolItem> ULTIMATE_LASER_DRILL = ((ItemHolder)((ItemHolder)((ItemHolder)((ItemHolder)EIItems.create("ultimate_laser_drill", "Ultimate Laser Drill", p -> new ElectricToolItem((Item.Properties)p, ElectricToolItem.Type.ULTIMATE), EISortOrder.GEAR).tag(new TagKey[]{ItemTags.DYEABLE, EITags.Items.RAINBOW_DYEABLE, ItemTags.PICKAXES, ItemTags.SHOVELS, ItemTags.AXES, ItemTags.HOES, ItemTags.SWORDS, Tags.Items.TOOLS_SHEAR})).withRegistrationListener(CommonRegistrations::cauldronClearDye)).withRegistrationListener(RainbowDataComponent::cauldronClearDyeAndRainbow)).withCapabilities(MICommonCapabitilies::simpleEnergyItem)).withModelBuilder(CommonModelBuilders::handheldOverlayed).register();
    public static final ItemHolder<NanoSuitArmorItem> NANO_HELMET = EIItems.createNanosuitArmor("nano_helmet", "Nano Helmet", ArmorItem.Type.HELMET, NanoSuitAbility.NIGHT_VISION).register();
    public static final ItemHolder<NanoSuitArmorItem> NANO_CHESTPLATE = EIItems.createNanosuitArmor("nano_chestplate", "Nano Chestplate", ArmorItem.Type.CHESTPLATE).register();
    public static final ItemHolder<NanoSuitArmorItem> NANO_GRAVICHESTPLATE = EIItems.createNanosuitArmor("nano_gravichestplate", "Nano Gravichestplate", ArmorItem.Type.CHESTPLATE, EIArmorMaterials.NANO_GRAVICHESTPLATE, NanoSuitAbility.GRAVICHESTPLATE).register();
    public static final ItemHolder<NanoSuitArmorItem> NANO_LEGGINGS = EIItems.createNanosuitArmor("nano_leggings", "Nano Leggings", ArmorItem.Type.LEGGINGS, NanoSuitAbility.SPEED).register();
    public static final ItemHolder<NanoSuitArmorItem> NANO_BOOTS = EIItems.createNanosuitArmor("nano_boots", "Nano Boots", ArmorItem.Type.BOOTS, NanoSuitAbility.STEP).register();
    public static final ItemHolder<NanoSuitArmorItem> NANO_QUANTUM_HELMET = EIItems.createNanosuitArmor("nano_quantum_helmet", "Quantum Nano Helmet", ArmorItem.Type.HELMET, EIArmorMaterials.NANO_QUANTUM, NanoSuitAbility.NIGHT_VISION).register();
    public static final ItemHolder<NanoSuitArmorItem> NANO_QUANTUM_CHESTPLATE = EIItems.createNanosuitArmor("nano_quantum_chestplate", "Quantum Nano Chestplate", ArmorItem.Type.CHESTPLATE, EIArmorMaterials.NANO_QUANTUM, NanoSuitAbility.QUANTUM_FLIGHT).register();
    public static final ItemHolder<NanoSuitArmorItem> NANO_QUANTUM_LEGGINGS = EIItems.createNanosuitArmor("nano_quantum_leggings", "Quantum Nano Leggings", ArmorItem.Type.LEGGINGS, EIArmorMaterials.NANO_QUANTUM, NanoSuitAbility.SPEED).register();
    public static final ItemHolder<NanoSuitArmorItem> NANO_QUANTUM_BOOTS = EIItems.createNanosuitArmor("nano_quantum_boots", "Quantum Nano Boots", ArmorItem.Type.BOOTS, EIArmorMaterials.NANO_QUANTUM, NanoSuitAbility.STEP).register();
    public static final ItemHolder<Item> TIN_CAN = EIItems.create("tin_can", "Tin Can", Item::new, EISortOrder.OTHER_GEAR).withModelBuilder(CommonModelBuilders::generated).register();
    public static final ItemHolder<Item> CANNED_FOOD = ((ItemHolder)EIItems.create("canned_food", "Canned Food", Item::new, EISortOrder.OTHER_GEAR).withProperties(p -> p.food(new FoodProperties.Builder().nutrition(2).saturationModifier(0.3f).fast().usingConvertsTo(TIN_CAN).build())).tag(new TagKey[]{ItemTags.WOLF_FOOD, ItemTags.CAT_FOOD})).withModelBuilder(CommonModelBuilders::generated).register();
    public static final ItemHolder<RobotAutoFeederItem> ROBOT_AUTO_FEEDER = ((ItemHolder)EIItems.create("robot_auto_feeder", "Robot Auto Feeder", RobotAutoFeederItem::new, EISortOrder.OTHER_GEAR).withCapabilities(MICommonCapabitilies::simpleEnergyItem)).withModelBuilder(CommonModelBuilders::generated).register();
    public static final ItemHolder<MachineConfigCardItem> MACHINE_CONFIG_CARD = EIItems.create("machine_config_card", "Machine Config Card", MachineConfigCardItem::new, EISortOrder.OTHER_GEAR).withModelBuilder(CommonModelBuilders::generated).register();
    public static final ItemHolder<TeslaCalibratorItem> TESLA_CALIBRATOR = ((ItemHolder)EIItems.create("tesla_calibrator", "Tesla Calibrator", TeslaCalibratorItem::new, EISortOrder.OTHER_GEAR).withModelBuilder(CommonModelBuilders::generated).withClientRegistrationListener(EIItems::itemPropertyTeslaNetworkSelected)).register();
    public static final ItemHolder<TeslaHandheldReceiverItem> TESLA_HANDHELD_RECEIVER = ((ItemHolder)EIItems.create("tesla_handheld_receiver", "Tesla Handheld Receiver", TeslaHandheldReceiverItem::new, EISortOrder.OTHER_GEAR).withClientRegistrationListener(EIItems::itemPropertyTeslaNetworkSelected)).register();
    public static final ItemHolder<Item> TESLA_INTERDIMENSIONAL_UPGRADE = EIItems.create("tesla_interdimensional_upgrade", "Tesla Interdimensional Upgrade", Item::new, EISortOrder.OTHER_GEAR).withProperties(p -> p.stacksTo(1).rarity(Rarity.EPIC)).withModelBuilder(CommonModelBuilders::generated).register();
    public static final ItemHolder<Item> NETHERITE_ROTARY_BLADE = EIItems.create("netherite_rotary_blade", "Netherite Rotary Blade", Item::new, EISortOrder.PARTS).withModelBuilder(CommonModelBuilders::generated).register();
    public static final ItemHolder<Item> STEEL_COMBINE = EIItems.create("steel_combine", "Steel Combine", Item::new, EISortOrder.PARTS).withModelBuilder(CommonModelBuilders::generated).register();
    public static final ItemHolder<Item> MULCH = EIItems.create("mulch", "Mulch", Item::new, EISortOrder.RESOURCES).withProperties(p -> p.food(new FoodProperties.Builder().nutrition(2).saturationModifier(0.3f).fast().build())).withModelBuilder(CommonModelBuilders::generated).register();
    public static final ItemHolder<Item> NETHERITE_DUST = ((ItemHolder)EIItems.create("netherite_dust", "Netherite Dust", Item::new, EISortOrder.RESOURCES).tag(new TagKey[]{EITags.itemCommon("dusts"), EITags.itemCommon("dusts/netherite")})).withModelBuilder(CommonModelBuilders::generated).register();
    public static final ItemHolder<Item> CRYSTALLIZED_HONEY = EIItems.create("crystallized_honey", "Crystallized Honey", Item::new, EISortOrder.RESOURCES).withProperties(p -> p.food(new FoodProperties.Builder().nutrition(3).saturationModifier(0.3f).fast().build())).withModelBuilder(CommonModelBuilders::generated).register();
    public static final ItemHolder<Item> GRANITE_DUST = ((ItemHolder)EIItems.create("granite_dust", "Granite Dust", Item::new, EISortOrder.RESOURCES).tag(new TagKey[]{EITags.itemCommon("dusts"), EITags.itemCommon("dusts/granite")})).withModelBuilder(CommonModelBuilders::generated).register();
    public static final ItemHolder<PhotovoltaicCellItem> LV_PHOTOVOLTAIC_CELL = EIItems.createPhotovoltaicCell("lv", "LV", CableTier.LV, 16, 12000);
    public static final ItemHolder<PhotovoltaicCellItem> MV_PHOTOVOLTAIC_CELL = EIItems.createPhotovoltaicCell("mv", "MV", CableTier.MV, 64, 12000);
    public static final ItemHolder<PhotovoltaicCellItem> HV_PHOTOVOLTAIC_CELL = EIItems.createPhotovoltaicCell("hv", "HV", CableTier.HV, 256, 12000);
    public static final ItemHolder<Item> SILK_TOUCH_MODULE = EIItems.createEnchantmentModule("silk_touch", "Silk Touch").register();
    public static final ItemHolder<Item> LOOTING_MODULE = EIItems.createEnchantmentModule("looting", "Looting").register();

    public static void init(IEventBus bus) {
        Registry.init(bus);
    }

    public static Set<ItemHolder> values() {
        return Set.copyOf(Registry.HOLDERS);
    }

    public static ItemHolder valueOf(String id) {
        return Registry.HOLDERS.stream().filter(holder -> holder.identifier().id().equals(id)).findFirst().orElseThrow();
    }

    public static <Type extends Item> ItemHolder<Type> create(String id, String englishName, Function<Item.Properties, Type> creator, SortOrder sortOrder) {
        ItemHolder holder = new ItemHolder(EI.id(id), englishName, Registry.ITEMS, creator).sorted(sortOrder);
        Registry.include(holder);
        return holder;
    }

    public static ItemHolder<NanoSuitArmorItem> createNanosuitArmor(String id, String englishName, ArmorItem.Type armorType, Holder<ArmorMaterial> material, Optional<NanoSuitAbility> ability) {
        boolean quantum = material == EIArmorMaterials.NANO_QUANTUM;
        TagKey armorTag = switch (armorType) {
            case ArmorItem.Type.HELMET -> ItemTags.HEAD_ARMOR;
            case ArmorItem.Type.CHESTPLATE -> ItemTags.CHEST_ARMOR;
            case ArmorItem.Type.LEGGINGS -> ItemTags.LEG_ARMOR;
            case ArmorItem.Type.BOOTS -> ItemTags.FOOT_ARMOR;
            default -> throw new IllegalArgumentException("Cannot get tag for armor type %s".formatted(armorType.name()));
        };
        Function<NanoSuitArmorItem, List> itemProperties = item -> NanoSuitDecoration.values().stream().filter(d -> d.armorType() == armorType).map(d -> d.itemProperty((NanoSuitArmorItem)item)).filter(Objects::nonNull).toList();
        return (ItemHolder)((ItemHolder)((ItemHolder)((ItemHolder)((ItemHolder)((ItemHolder)EIItems.create(id, englishName, p -> new NanoSuitArmorItem(material, armorType, p.rarity(quantum ? Rarity.EPIC : ability.map(NanoSuitAbility::rarity).orElse(Rarity.UNCOMMON)), ability, quantum), EISortOrder.GEAR.and((Comparable)Boolean.valueOf(quantum)).and((Comparable)armorType)).tag(new TagKey[]{armorTag, Tags.Items.ARMORS, ItemTags.TRIMMABLE_ARMOR, ItemTags.DYEABLE, EITags.Items.RAINBOW_DYEABLE})).withRegistrationListener(CommonRegistrations::cauldronClearDye)).withRegistrationListener(RainbowDataComponent::cauldronClearDyeAndRainbow)).withClientRegistrationListener(item -> {
            for (NanoSuitDecoration.ItemProperty itemProperty : (List)itemProperties.apply((NanoSuitArmorItem)item)) {
                ItemProperties.register((Item)item, (ResourceLocation)itemProperty.id(), (stack, __, ___, ____) -> (Boolean)stack.getOrDefault(itemProperty.component(), (Object)false) != false ? 1.0f : 0.0f);
            }
        })).withCapabilities(MICommonCapabitilies::simpleEnergyItem)).withModel(item -> provider -> {
            int[] nArray;
            if (quantum) {
                int[] nArray2 = new int[2];
                nArray2[0] = 0;
                nArray = nArray2;
                nArray2[1] = 2;
            } else {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = 0;
            }
            int[] emissiveLayers = nArray;
            String texture = item.identifier().id();
            ItemModelBuilder baseModel = (ItemModelBuilder)((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)provider.getBuilder("item/%s".formatted(texture))).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)item.identifier().modId(), (String)("item/" + texture)))).texture("layer1", ResourceLocation.fromNamespaceAndPath((String)item.identifier().modId(), (String)("item/" + texture + "_overlay")))).customLoader((parent, efh) -> ItemLayerModelBuilder.begin((ModelBuilder)parent, (ExistingFileHelper)efh).emissive(15, 15, emissiveLayers))).end();
            if (quantum) {
                baseModel.texture("layer2", ResourceLocation.fromNamespaceAndPath((String)item.identifier().modId(), (String)("item/" + texture + "_quantum_overlay")));
            }
            for (NanoSuitDecoration.ItemProperty itemProperty : (List)itemProperties.apply((NanoSuitArmorItem)item.get())) {
                String propertyTexture = itemProperty.model();
                ItemModelBuilder propertyModel = (ItemModelBuilder)((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)provider.getBuilder("item/%s".formatted(propertyTexture))).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)item.identifier().modId(), (String)("item/" + propertyTexture)))).texture("layer1", ResourceLocation.fromNamespaceAndPath((String)item.identifier().modId(), (String)("item/" + propertyTexture + "_overlay")))).customLoader((parent, efh) -> ItemLayerModelBuilder.begin((ModelBuilder)parent, (ExistingFileHelper)efh).emissive(15, 15, emissiveLayers))).end();
                if (quantum) {
                    propertyModel.texture("layer2", ResourceLocation.fromNamespaceAndPath((String)item.identifier().modId(), (String)("item/" + propertyTexture + "_quantum_overlay")));
                }
                baseModel.override().predicate(itemProperty.id(), 1.0f).model((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)item.identifier().modId(), (String)("item/" + propertyTexture)))).end();
            }
        });
    }

    public static ItemHolder<NanoSuitArmorItem> createNanosuitArmor(String id, String englishName, ArmorItem.Type armorType, Holder<ArmorMaterial> material, NanoSuitAbility ability) {
        return EIItems.createNanosuitArmor(id, englishName, armorType, material, Optional.of(ability));
    }

    public static ItemHolder<NanoSuitArmorItem> createNanosuitArmor(String id, String englishName, ArmorItem.Type armorType, NanoSuitAbility ability) {
        return EIItems.createNanosuitArmor(id, englishName, armorType, EIArmorMaterials.NANO, Optional.of(ability));
    }

    public static ItemHolder<NanoSuitArmorItem> createNanosuitArmor(String id, String englishName, ArmorItem.Type armorType, Holder<ArmorMaterial> material) {
        return EIItems.createNanosuitArmor(id, englishName, armorType, material, Optional.empty());
    }

    public static ItemHolder<NanoSuitArmorItem> createNanosuitArmor(String id, String englishName, ArmorItem.Type armorType) {
        return EIItems.createNanosuitArmor(id, englishName, armorType, EIArmorMaterials.NANO, Optional.empty());
    }

    public static ItemHolder<PhotovoltaicCellItem> createPhotovoltaicCell(String id, String name, CableTier tier, int euPerTick, int durationTicks) {
        return ((ItemHolder)EIItems.create("%s_photovoltaic_cell".formatted(id), "%s Photovoltaic Cell".formatted(name), p -> new PhotovoltaicCellItem((Item.Properties)p, tier, euPerTick, durationTicks), EISortOrder.PARTS).tag(new TagKey[]{EITags.Items.PHOTOVOLTAIC_CELL})).withModelBuilder(CommonModelBuilders::generated).register();
    }

    public static ItemHolder<Item> createEnchantmentModule(String id, String name) {
        return EIItems.create(id + "_module", name + " Module", Item::new, EISortOrder.OTHER_GEAR).withProperties(p -> p.stacksTo(1).rarity(Rarity.RARE).component(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true)).withModelBuilder(CommonModelBuilders::generated);
    }

    public static void itemPropertyTeslaNetworkSelected(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)EI.id("selected_tesla_network"), (stack, __, ___, ____) -> stack.has(EIComponents.SELECTED_TESLA_NETWORK) ? 1.0f : 0.0f);
    }

    public static final class Registry {
        public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"extended_industrialization");
        private static final Set<ItemHolder> HOLDERS = Sets.newHashSet();

        private static void init(IEventBus bus) {
            ITEMS.register(bus);
        }

        public static void include(ItemHolder holder) {
            HOLDERS.add(holder);
        }
    }
}

