/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterRenderBuffersEvent;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIClientShaders;
import net.swedz.extended_industrialization.client.shader.NanoQuantumTextureStateShard;
import net.swedz.extended_industrialization.client.shader.TeslaPlasmaTextureStateShard;

@EventBusSubscriber(modid="extended_industrialization", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class EIClientRenderTypes {
    public static final BiFunction<ResourceLocation, Boolean, RenderType> ARMOR_CUTOUT_NO_CULL_WITH_TRANSPARENCY = Util.memoize((texture, glow) -> EIClientRenderTypes.armorCutoutWithTransparency(texture, glow, false));
    public static final BiFunction<ResourceLocation, Boolean, RenderType> ARMOR_CUTOUT_CULL_WITH_TRANSPARENCY = Util.memoize((texture, glow) -> EIClientRenderTypes.armorCutoutWithTransparency(texture, glow, true));
    public static final BiFunction<ResourceLocation, Boolean, RenderType> NANO_QUANTUM_STARS = Util.memoize((mask, cull) -> EIClientRenderTypes.createNanoQuantum(mask, true, cull));
    public static final BiFunction<ResourceLocation, Boolean, RenderType> NANO_QUANTUM_NO_STARS = Util.memoize((mask, cull) -> EIClientRenderTypes.createNanoQuantum(mask, false, cull));
    public static final RenderType TESLA_ARC = RenderType.create((String)"tesla_arc", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(EIClientShaders.TESLA_ARC).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(EI.id("textures/vfx/tesla_arc.png"), false, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(RenderStateShard.CULL).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.OVERLAY).createCompositeState(false));
    public static final BiFunction<Float, Float, RenderType> TESLA_PLASMA = Util.memoize(EIClientRenderTypes::createTeslaPlasma);

    private static RenderType armorCutoutWithTransparency(ResourceLocation texture, boolean glow, boolean cull) {
        RenderType.CompositeState state = RenderType.CompositeState.builder().setShaderState(glow ? EIClientShaders.ARMOR_CUTOUT_GLOW : RenderStateShard.RENDERTYPE_ARMOR_CUTOUT_NO_CULL_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(cull ? RenderStateShard.CULL : RenderStateShard.NO_CULL).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.NO_OVERLAY).setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).createCompositeState(false);
        return RenderType.create((String)"armor_cutout_%s_with_transparency".formatted(cull ? "cull" : "no_cull"), (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    }

    private static RenderStateShard.EmptyTextureStateShard nanoQuantumTexture(ResourceLocation mask, boolean stars) {
        ArrayList sprites = Lists.newArrayList();
        for (int i = 1; i <= 4; ++i) {
            sprites.add(EI.id("shaders/nano_quantum/%d".formatted(i)));
        }
        return new NanoQuantumTextureStateShard(mask, EI.id("textures/shaders/nano_quantum/glint.png"), stars, EI.id("textures/atlas/nano_quantum.png"), sprites, false, false);
    }

    private static RenderType createNanoQuantum(ResourceLocation mask, boolean stars, boolean cull) {
        RenderType.CompositeState state = RenderType.CompositeState.builder().setShaderState(EIClientShaders.NANO_QUANTUM).setTextureState(EIClientRenderTypes.nanoQuantumTexture(mask, stars)).setCullState(cull ? RenderStateShard.CULL : RenderStateShard.NO_CULL).setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING).createCompositeState(false);
        return RenderType.create((String)"nano_quantum_%s".formatted(stars ? "stars" : "no_stars"), (VertexFormat)EIClientShaders.NANO_QUANTUM_VERTEX_FORMAT, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    }

    private static RenderType createTeslaPlasma(float scale, float speed) {
        return RenderType.create((String)"plasma", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(EIClientShaders.TESLA_PLASMA).setTextureState((RenderStateShard.EmptyTextureStateShard)new TeslaPlasmaTextureStateShard(EI.id("textures/vfx/tesla_plasma.png"), scale, speed)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(RenderStateShard.CULL).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.OVERLAY).createCompositeState(false));
    }

    @SubscribeEvent
    private static void onRegisterRenderBuffers(RegisterRenderBuffersEvent event) {
        event.registerRenderBuffer(TESLA_ARC);
    }
}

