/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.experiencelib.impl.capability;

import es.degrassi.experiencelib.api.capability.IContentsListener;
import es.degrassi.experiencelib.api.capability.IExperienceHandler;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class BasicExperienceTank
implements IExperienceHandler,
INBTSerializable<CompoundTag> {
    private long experience;
    private long capacity;
    @Nullable
    private final IContentsListener listener;

    public BasicExperienceTank(long capacity, @Nullable IContentsListener listener) {
        this.capacity = capacity;
        this.experience = 0L;
        this.listener = listener;
    }

    @Override
    public boolean canAcceptExperience(long experience) {
        return this.receiveExperience(experience, true) > 0L;
    }

    @Override
    public boolean canProvideExperience(long experience) {
        return this.extractExperience(experience, true) > 0L;
    }

    @Override
    public boolean canReceive() {
        return this.getMaxReceive() > 0L;
    }

    @Override
    public boolean canExtract() {
        return this.getMaxExtract() > 0L;
    }

    @Override
    public long getMaxExtract() {
        return this.capacity;
    }

    @Override
    public long getMaxReceive() {
        return this.capacity;
    }

    @Override
    public long getExperience() {
        return this.experience;
    }

    @Override
    public long getExperienceCapacity() {
        return this.capacity;
    }

    @Override
    public void setExperience(long experience) {
        this.experience = experience;
        if (this.listener != null) {
            this.listener.onContentsChanged();
        }
    }

    @Override
    public void setCapacity(long capacity) {
        this.capacity = capacity;
        if (this.listener != null) {
            this.listener.onContentsChanged();
        }
    }

    @Override
    public long receiveExperience(long toReceive, boolean simulate) {
        if (this.canReceive() && toReceive > 0L) {
            long experienceReceived = Mth.clamp((long)(this.capacity - this.experience), (long)0L, (long)Math.min(this.getMaxReceive(), toReceive));
            if (!simulate) {
                this.experience += experienceReceived;
                if (this.listener != null) {
                    this.listener.onContentsChanged();
                }
            }
            return experienceReceived;
        }
        return 0L;
    }

    @Override
    public long extractExperience(long toExtract, boolean simulate) {
        if (this.canExtract() && toExtract > 0L) {
            long experienceExtracted = Math.min(this.experience, Math.min(this.getMaxExtract(), toExtract));
            if (!simulate) {
                this.experience -= experienceExtracted;
                if (this.listener != null) {
                    this.listener.onContentsChanged();
                }
            }
            return experienceExtracted;
        }
        return 0L;
    }

    @Override
    public long extractExperienceRecipe(long maxExtract, boolean simulate) {
        long extractable;
        long l = extractable = this.experience - maxExtract < 0L ? this.experience : maxExtract;
        if (!simulate) {
            this.experience = this.clamp(this.experience - extractable, 0L, this.getExperienceCapacity());
            if (this.listener != null) {
                this.listener.onContentsChanged();
            }
        }
        return extractable;
    }

    @Override
    public long receiveExperienceRecipe(long maxReceive, boolean simulate) {
        long insertable;
        long l = insertable = this.experience + maxReceive > this.getExperienceCapacity() ? this.getExperienceCapacity() - this.experience : maxReceive;
        if (!simulate) {
            this.experience = this.clamp(this.experience + insertable, 0L, this.getExperienceCapacity());
            if (this.listener != null) {
                this.listener.onContentsChanged();
            }
        }
        return insertable;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putLong("experience", this.getExperience());
        tag.putLong("capacity", this.getExperienceCapacity());
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.experience = nbt.getLong("experience");
        this.capacity = nbt.getLong("capacity");
    }
}

