/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.degradation;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.api.degradation.IDegradable;
import org.cyclops.evilcraft.api.degradation.IDegradationEffect;
import org.cyclops.evilcraft.api.degradation.IDegradationRegistry;

public class DegradationExecutor {
    private static final String ROOT_TAG = "degradationExecutor";
    private static final int DEFAULT_TICK_INTERVAL = 1;
    private int tickInterval = 1;
    private int currentTick = 0;
    private IDegradable degradable;

    public DegradationExecutor(IDegradable degradable) {
        this.degradable = degradable;
    }

    public boolean runRandomEffect(boolean isClientSide) {
        ++this.currentTick;
        if (this.currentTick >= this.tickInterval) {
            this.currentTick = 0;
            IDegradationEffect effect = ((IDegradationRegistry)EvilCraft._instance.getRegistryManager().getRegistry(IDegradationRegistry.class)).getRandomDegradationEffect();
            if (effect.canRun(this.degradable)) {
                if (isClientSide) {
                    effect.runClientSide(this.degradable);
                } else {
                    effect.runServerSide(this.degradable);
                }
                return true;
            }
        }
        return false;
    }

    public void read(CompoundTag compound) {
        this.tickInterval = compound.getCompound(ROOT_TAG).getInt("tickInterval");
        this.currentTick = compound.getCompound(ROOT_TAG).getInt("currentTick");
    }

    public void write(CompoundTag compound) {
        CompoundTag content = new CompoundTag();
        content.putInt("tickInterval", this.tickInterval);
        content.putInt("currentTick", this.currentTick);
        compound.put(ROOT_TAG, (Tag)content);
    }

    public int getTickInterval() {
        return this.tickInterval;
    }

    public void setTickInterval(int tickInterval) {
        this.tickInterval = tickInterval;
    }
}

