/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.entity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritConfig;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public class RenderVengeanceSpirit
extends EntityRenderer<EntityVengeanceSpirit> {
    private final RenderPlayerSpirit playerRenderer;
    private final Map<GameProfile, GameProfile> checkedProfiles = Maps.newHashMap();

    public RenderVengeanceSpirit(EntityRendererProvider.Context context, EntityVengeanceSpiritConfig config) {
        super(context);
        this.playerRenderer = new RenderPlayerSpirit(context);
    }

    public void render(EntityVengeanceSpirit spirit, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        EntityRenderer render;
        super.render((Entity)spirit, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        Mob innerEntity = spirit.getInnerEntity();
        if (innerEntity != null && spirit.isVisible() && (render = (EntityRenderer)this.entityRenderDispatcher.renderers.get(innerEntity.getType())) != null && !spirit.isSwarm()) {
            MultiBufferSource bufferSub = renderType -> {
                float uv = spirit.isFrozen() ? ((float)spirit.tickCount + partialTicks) * 0.01f : 1.0f;
                renderType = RenderType.energySwirl((ResourceLocation)(spirit.isPlayer() ? this.playerRenderer : render).getTextureLocation((Entity)innerEntity), (float)uv, (float)uv);
                return bufferIn.getBuffer(renderType);
            };
            try {
                PoseStack poseStackInner = new PoseStack();
                poseStackInner.last().pose().set((Matrix4fc)matrixStackIn.last().pose());
                poseStackInner.last().normal().set((Matrix3fc)matrixStackIn.last().normal());
                if (spirit.isPlayer()) {
                    GameProfile gameProfile = new GameProfile(spirit.getPlayerUUID(), spirit.getPlayerName());
                    ResourceLocation resourcelocation = DefaultPlayerSkin.getDefaultTexture();
                    Minecraft minecraft = Minecraft.getInstance();
                    if (!this.checkedProfiles.containsKey(gameProfile)) {
                        Property property = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get((Object)"textures"), null);
                        if (property == null) {
                            GameProfile newGameProfile = Minecraft.getInstance().getMinecraftSessionService().fetchProfile(gameProfile.getId(), true).profile();
                            this.checkedProfiles.put(gameProfile, newGameProfile);
                        }
                    } else {
                        PlayerSkin skin = minecraft.getSkinManager().getInsecureSkin(this.checkedProfiles.get(gameProfile));
                        resourcelocation = skin.texture();
                    }
                    this.playerRenderer.setPlayerTexture(resourcelocation);
                    Minecraft.getInstance().options.hideGui = true;
                    this.playerRenderer.render((LivingEntity)innerEntity, entityYaw, partialTicks, poseStackInner, bufferSub, packedLightIn);
                    Minecraft.getInstance().options.hideGui = false;
                } else {
                    render.render((Entity)innerEntity, entityYaw, 0.0f, poseStackInner, bufferSub, packedLightIn);
                }
            }
            catch (Exception e) {
                spirit.setSwarm(true);
                spirit.setPlayerId("");
            }
        }
    }

    public ResourceLocation getTextureLocation(EntityVengeanceSpirit entity) {
        return null;
    }

    public static class RenderPlayerSpirit
    extends LivingEntityRenderer<Mob, PlayerModel<Mob>> {
        private ResourceLocation playerTexture;

        public RenderPlayerSpirit(EntityRendererProvider.Context context) {
            super(context, (EntityModel)new PlayerModel(context.bakeLayer(ModelLayers.PLAYER), false), 0.5f);
            this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getModelManager()));
            this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
            this.addLayer((RenderLayer)new ArrowLayer(context, (LivingEntityRenderer)this));
            this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getItemInHandRenderer()));
        }

        public ResourceLocation getTextureLocation(Mob entity) {
            return this.playerTexture;
        }

        public void setPlayerTexture(ResourceLocation playerTexture) {
            this.playerTexture = playerTexture;
        }
    }
}

