/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction.bloodinfuser;

import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.mutable.MutableInt;
import org.cyclops.evilcraft.blockentity.BlockEntityBloodInfuser;
import org.cyclops.evilcraft.blockentity.tickaction.bloodinfuser.BloodInfuserTickAction;
import org.cyclops.evilcraft.core.blockentity.upgrade.UpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;
import org.cyclops.evilcraft.core.recipe.type.RecipeBloodInfuser;

public class InfuseItemTickAction
extends BloodInfuserTickAction {
    @Override
    public boolean canTick(BlockEntityBloodInfuser tile, ItemStack itemStack, int slot, int tick) {
        return super.canTick(tile, itemStack, slot, tick) && tile.getTank().getFluidAmount() >= this.getRequiredFluidAmount(tile, this.getRecipe(tile));
    }

    @Override
    public void onTick(BlockEntityBloodInfuser tile, ItemStack itemStack, int slot, int tick) {
        Optional<RecipeBloodInfuser> recipe = this.getRecipe(tile);
        if (tick >= this.getRequiredTicks(tile, recipe) && recipe.isPresent() && this.addToProduceSlot(tile, recipe.get().getOutputItemFirst().copy())) {
            tile.getInventory().removeItem(tile.getTileWorkingMetadata().getConsumeSlot(), 1);
            tile.getTank().drain(this.getRequiredFluidAmount(tile, recipe), IFluidHandler.FluidAction.EXECUTE);
            recipe.get().getXp().ifPresent(xp -> tile.addXp(xp.floatValue()));
        }
    }

    protected int getRequiredFluidAmount(BlockEntityBloodInfuser tile, Optional<RecipeBloodInfuser> recipe) {
        if (!recipe.isPresent()) {
            return Integer.MAX_VALUE;
        }
        MutableInt amount = new MutableInt((Number)recipe.get().getInputFluid().map(FluidStack::getAmount).orElse(0));
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(amount, BlockEntityBloodInfuser.UPGRADEEVENT_BLOODUSAGE));
        return Math.max(1, amount.getValue());
    }

    private Optional<RecipeBloodInfuser> getRecipe(BlockEntityBloodInfuser tile) {
        return tile.getRecipe(this.getInfuseStack(tile));
    }

    @Override
    public int getUnmodifiedRequiredTicks(BlockEntityBloodInfuser tile, int slot) {
        return this.getUnmodifiedRequiredTicks(tile, this.getRecipe(tile));
    }

    private int getUnmodifiedRequiredTicks(BlockEntityBloodInfuser tile, Optional<RecipeBloodInfuser> recipe) {
        return recipe.map(RecipeBloodInfuser::getDuration).orElse(0);
    }

    private int getRequiredTicks(BlockEntityBloodInfuser tile, Optional<RecipeBloodInfuser> recipe) {
        MutableInt duration = new MutableInt(this.getUnmodifiedRequiredTicks(tile, recipe));
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(duration, BlockEntityBloodInfuser.UPGRADEEVENT_SPEED));
        return duration.getValue();
    }

    @Override
    public ItemStack willProduceItem(BlockEntityBloodInfuser tile) {
        return this.getRecipe(tile).map(recipe -> recipe.getOutputItemFirst().copy()).orElse(ItemStack.EMPTY);
    }
}

