/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.block.multi.DetectionResult;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityColossalBloodChest;
import org.cyclops.evilcraft.core.block.BlockWithEntityGuiTank;

public class BlockColossalBloodChest
extends BlockWithEntityGuiTank
implements CubeDetector.IDetectionListener {
    public static final MapCodec<BlockColossalBloodChest> CODEC = BlockColossalBloodChest.simpleCodec(BlockColossalBloodChest::new);
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    public BlockColossalBloodChest(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityColossalBloodChest::new);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BlockColossalBloodChest.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RegistryEntries.BLOCK_ENTITY_COLOSSAL_BLOOD_CHEST.get()), (BlockEntityTicker)(level.isClientSide ? new BlockEntityColossalBloodChest.TickerClient() : new BlockEntityColossalBloodChest.TickerServer()));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)ACTIVE, (Comparable)Boolean.valueOf(false)) != false ? RenderShape.ENTITYBLOCK_ANIMATED : super.getRenderShape(blockState);
    }

    public boolean propagatesSkylightDown(BlockState blockState, BlockGetter blockReader, BlockPos blockPos) {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public boolean shouldDisplayFluidOverlay(BlockState blockState, BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    @Override
    public InteractionResult useWithoutItem(BlockState blockState, Level world, BlockPos blockPos, Player player, BlockHitResult rayTraceResult) {
        if (((Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)ACTIVE, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            if (!BlockEntityColossalBloodChest.canWork(world, blockPos)) {
                return InteractionResult.FAIL;
            }
            return super.useWithoutItem(blockState, world, blockPos, player, rayTraceResult);
        }
        BlockColossalBloodChest.addPlayerChatError(world, blockPos, player);
        return InteractionResult.FAIL;
    }

    @Override
    public int getDefaultCapacity() {
        return 10000;
    }

    public static void triggerDetector(LevelReader world, BlockPos blockPos, boolean valid) {
        BlockEntityColossalBloodChest.getCubeDetector().detect(world, blockPos, valid ? null : blockPos, true);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntityColossalBloodChest tile;
        super.setPlacedBy(world, pos, state, placer, stack);
        if (stack.has(DataComponents.CUSTOM_NAME) && (tile = (BlockEntityColossalBloodChest)BlockEntityHelpers.get((BlockGetter)world, (BlockPos)pos, BlockEntityColossalBloodChest.class).orElse(null)) != null) {
            tile.setSize(Vec3i.ZERO);
        }
        BlockColossalBloodChest.triggerDetector((LevelReader)world, pos, true);
    }

    public void onPlace(BlockState blockStateNew, Level world, BlockPos blockPos, BlockState blockStateOld, boolean isMoving) {
        super.onPlace(blockStateNew, world, blockPos, blockStateOld, isMoving);
        if (!world.captureBlockSnapshots && blockStateNew.getBlock() != blockStateOld.getBlock() && !((Boolean)blockStateNew.getValue((Property)ACTIVE)).booleanValue()) {
            BlockColossalBloodChest.triggerDetector((LevelReader)world, blockPos, true);
        }
    }

    public void destroy(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        if (((Boolean)blockState.getValue((Property)ACTIVE)).booleanValue()) {
            BlockColossalBloodChest.triggerDetector((LevelReader)world, blockPos, false);
        }
        super.destroy(world, blockPos, blockState);
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        if (((Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)state, (Property)ACTIVE, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            BlockColossalBloodChest.triggerDetector((LevelReader)world, pos, false);
        }
        world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        this.wasExploded(world, pos, explosion);
    }

    public void onDetect(LevelReader world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
        Block block = world.getBlockState(location).getBlock();
        if (block == this) {
            ((Level)world).setBlock(location, (BlockState)world.getBlockState(location).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(valid)), 2);
            BlockEntityHelpers.get((BlockGetter)world, (BlockPos)location, BlockEntityColossalBloodChest.class).ifPresent(tile -> {
                tile.setSize(valid ? size : Vec3i.ZERO);
                tile.setCenter(originCorner.offset(1, 1, 1));
            });
        }
    }

    public static void addPlayerChatError(Level world, BlockPos blockPos, Player player) {
        if (player.getUsedItemHand() == InteractionHand.MAIN_HAND && !world.isClientSide && player.getItemInHand(player.getUsedItemHand()).isEmpty()) {
            DetectionResult result = BlockEntityColossalBloodChest.getCubeDetector().detect((LevelReader)world, blockPos, null, false);
            if (result != null && result.getError() != null) {
                BlockColossalBloodChest.addPlayerChatError(player, result.getError());
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"multiblock.evilcraft.colossalbloodchest.error.unexpected"));
            }
        }
    }

    public static void addPlayerChatError(Player player, Component error) {
        MutableComponent chat = Component.literal((String)"");
        MutableComponent prefix = Component.literal((String)"[").append((Component)Component.translatable((String)"multiblock.evilcraft.colossalbloodchest.error.prefix")).append((Component)Component.literal((String)"]: ")).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"multiblock.evilcraft.colossalbloodchest.error.prefix.info"))));
        chat.append((Component)prefix);
        chat.append(error);
        player.sendSystemMessage((Component)chat);
    }
}

