/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class LeavesPileFeature
extends Feature<Configuration> {
    public LeavesPileFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        boolean canPlace = false;
        for (int x = -4; x <= 4; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -4; z <= 4; ++z) {
                    if (!level.getBlockState(pos.offset(x, y, z)).is(BlockTags.LOGS)) continue;
                    canPlace = true;
                }
            }
        }
        if (!canPlace) {
            return false;
        }
        BlockPos.MutableBlockPos placePos = new BlockPos.MutableBlockPos();
        for (int x = -4; x <= 4; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -4; z <= 4; ++z) {
                    if (x * x + z * z > 16 || !level.getBlockState(pos.offset(x, y, z)).is(BlockTags.DIRT) || !level.getBlockState(pos.offset(x, y + 1, z)).isAir() || !random.nextBoolean()) continue;
                    placePos.setWithOffset((Vec3i)pos, x, y + 1, z);
                    BlockState pileState = ((Configuration)context.config()).pile().getState(random, (BlockPos)placePos);
                    if (pileState.hasProperty((Property)BlockStateProperties.LAYERS)) {
                        pileState = (BlockState)pileState.setValue((Property)BlockStateProperties.LAYERS, (Comparable)Integer.valueOf(random.nextInt(1, 5)));
                    }
                    level.setBlock((BlockPos)placePos, pileState, 3);
                }
            }
        }
        return true;
    }

    public record Configuration(BlockStateProvider pile) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("pile").forGetter(Configuration::pile)).apply((Applicative)instance, Configuration::new));
    }
}

