/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity;

import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.TangledHatred;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorPhase;
import cn.leolezury.eternalstarlight.common.entity.projectile.LunarSpore;
import cn.leolezury.eternalstarlight.common.particle.ESExplosionParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TangledHatredSporePhase
extends BehaviorPhase<TangledHatred> {
    public static final int ID = 2;

    public TangledHatredSporePhase() {
        super(2, 1, 100, 450);
    }

    @Override
    public boolean canStart(TangledHatred entity, boolean cooldownOver) {
        return cooldownOver && entity.getTarget() != null;
    }

    @Override
    public void onStart(TangledHatred entity) {
    }

    @Override
    public void tick(TangledHatred entity) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int segment = entity.getBehaviorTicks() / 40;
            if (entity.getBehaviorTicks() == segment * 40 + 15 && entity.chain.segments().size() > segment) {
                int j;
                Vec3 base = entity.chain.segments().get(segment).getMiddlePosition();
                entity.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value());
                for (j = 0; j < 10; ++j) {
                    Vec3 vec3 = base.offsetRandom(entity.getRandom(), 5.0f);
                    for (int m = 0; m < serverLevel.players().size(); ++m) {
                        ServerPlayer serverPlayer = (ServerPlayer)serverLevel.players().get(m);
                        serverLevel.sendParticles(serverPlayer, (ParticleOptions)ESExplosionParticleOptions.LUNAR, true, vec3.x, vec3.y, vec3.z, 3, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                for (j = 0; j < 10; ++j) {
                    LunarSpore spore = new LunarSpore(entity.level(), (LivingEntity)entity, base.x, base.y, base.z);
                    Vec3 shoot = new Vec3((double)entity.getRandom().nextFloat() - 0.5, ((double)entity.getRandom().nextFloat() + 0.5) * 2.0, (double)entity.getRandom().nextFloat() - 0.5);
                    spore.setDeltaMovement(shoot.normalize().scale(1.2));
                    serverLevel.addFreshEntity((Entity)spore);
                }
            }
        }
    }

    @Override
    public boolean canContinue(TangledHatred entity) {
        return true;
    }

    @Override
    public void onStop(TangledHatred entity) {
    }
}

