/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESBoss;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.TangledHatredPart;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.TangledHatredSmokePhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.TangledHatredSporePhase;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorManager;
import cn.leolezury.eternalstarlight.common.particle.ESExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.Chain;
import cn.leolezury.eternalstarlight.common.util.ESBookUtil;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TangledHatred
extends ESBoss {
    private static final String TAG_CHAIN = "chain";
    protected static final EntityDataAccessor<CompoundTag> CHAIN = SynchedEntityData.defineId(TangledHatred.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    public Chain chain;
    public Chain oldChain;
    public final List<TangledHatredPart> parts = new ArrayList<TangledHatredPart>();
    private Vec3 targetPos = null;
    private Vec3 currentTargetPos = null;
    private int ticksToNextMeleeAttack;
    private final BehaviorManager<TangledHatred> behaviorManager = new BehaviorManager<TangledHatred>(this, List.of(new TangledHatredSmokePhase(), new TangledHatredSporePhase()));

    public Chain getSyncedChain() {
        return Chain.load((CompoundTag)this.getEntityData().get(CHAIN));
    }

    public void setSyncedChain(Chain chain) {
        CompoundTag tag = new CompoundTag();
        chain.save(tag);
        this.getEntityData().set(CHAIN, (Object)tag);
    }

    public TangledHatred(EntityType<? extends TangledHatred> type, Level level) {
        super(type, level);
        this.chain = this.createChain();
        this.oldChain = this.createChain();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, ESConfig.INSTANCE.mobsConfig.tangledHatred.maxHealth()).add(Attributes.ARMOR, ESConfig.INSTANCE.mobsConfig.tangledHatred.armor()).add(Attributes.ATTACK_DAMAGE, 5.0 * ESConfig.INSTANCE.mobsConfig.tangledHatred.attackDamageScale()).add(Attributes.FOLLOW_RANGE, ESConfig.INSTANCE.mobsConfig.tangledHatred.followRange()).add(Attributes.MOVEMENT_SPEED, 0.0);
    }

    private Chain createChain() {
        Chain c = new Chain(this.position(), 18, 1.5625f);
        float lastPitch = 0.0f;
        float lastYaw = 0.0f;
        Vec3 lastLowerPos = this.position();
        for (int i = 0; i < c.segments().size(); ++i) {
            Chain.Segment segment = c.segments().get(i);
            segment.setPitch(lastPitch);
            segment.setYaw(lastYaw);
            lastPitch += 7.5f;
            lastYaw += 5.0f;
            segment.setUpperPosition(lastLowerPos);
            lastLowerPos = segment.getLowerPosition();
        }
        Vec3 offset = this.position().subtract(lastLowerPos);
        for (Chain.Segment segment : c.segments()) {
            segment.setLowerPosition(segment.getLowerPosition().add(offset));
        }
        return c;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        if (this.chain == null) {
            this.chain = this.createChain();
        }
        CompoundTag tag = new CompoundTag();
        this.chain.save(tag);
        builder.define(CHAIN, (Object)tag);
    }

    protected void registerGoals() {
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{TangledHatred.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public void setDeltaMovement(Vec3 vec3) {
        super.setDeltaMovement(new Vec3(0.0, vec3.y < 0.0 ? vec3.y : 0.0, 0.0));
    }

    public void startSeenByPlayer(ServerPlayer serverPlayer) {
        super.startSeenByPlayer(serverPlayer);
        ESBookUtil.unlock(serverPlayer, EternalStarlight.id("tangled_hatred"));
    }

    public boolean doHurtTarget(Entity entity) {
        boolean flag = super.doHurtTarget(entity);
        if (flag && !this.level().isClientSide) {
            this.ticksToNextMeleeAttack = 40;
            this.chain.getEndPos().ifPresent(vec3 -> ((ServerLevel)entity.level()).sendParticles((ParticleOptions)ESExplosionParticleOptions.LUNAR, vec3.x, vec3.y, vec3.z, 3, 0.1, 0.1, 0.1, 0.0));
        }
        return flag;
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        Entity entity;
        if (source.getEntity() != null && source.getEntity().getType().is(ESTags.EntityTypes.LUNAR_MONSTROSITY_ALLYS)) {
            return false;
        }
        boolean flag = super.hurt(source, amount * (this.isOnFire() ? 1.6f : 1.0f));
        if (flag && this.getBehaviorState() == 1 && (entity = source.getDirectEntity()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            entity2.hurtMarked = true;
            entity2.setDeltaMovement(entity2.position().subtract(this.position()).normalize().scale(1.5));
        }
        return flag;
    }

    public boolean isAlliedTo(Entity entity) {
        return super.isAlliedTo(entity) || entity.getType().is(ESTags.EntityTypes.LUNAR_MONSTROSITY_ALLYS);
    }

    public Optional<Vec3> calculateAttackTargetPos() {
        LivingEntity target = this.getTarget();
        if (target != null && this.getBehaviorState() == 2) {
            return Optional.of(target.position().add(0.0, (double)(target.getBbHeight() * 6.0f), 0.0));
        }
        if (target != null && this.ticksToNextMeleeAttack == 0) {
            return Optional.of(target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0));
        }
        return Optional.empty();
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            Object targetPitch2;
            if (!this.isNoAi() && this.isAlive()) {
                this.behaviorManager.tick();
            }
            LivingEntity target = this.getTarget();
            if (this.ticksToNextMeleeAttack > 0) {
                --this.ticksToNextMeleeAttack;
            }
            if (this.targetPos != null) {
                if (this.currentTargetPos == null) {
                    this.currentTargetPos = this.position();
                }
            } else {
                this.targetPos = this.position().offsetRandom(this.getRandom(), 10.0f);
            }
            if (this.chain.getEndPos().isPresent()) {
                Vec3 endPos = this.chain.getEndPos().get();
                float targetPitch2 = ESMathUtil.positionToPitch(this.position(), this.targetPos);
                float targetYaw = ESMathUtil.positionToYaw(this.position(), this.targetPos);
                float currentPitch = ESMathUtil.positionToPitch(this.position(), endPos);
                float currentYaw = ESMathUtil.positionToYaw(this.position(), endPos);
                float speed = 0.3f;
                float turnSpeed = 0.5f;
                float pitch = Mth.approachDegrees((float)currentPitch, (float)targetPitch2, (float)turnSpeed);
                float yaw = Mth.approachDegrees((float)currentYaw, (float)targetYaw, (float)turnSpeed);
                float radius = Mth.approach((float)((float)endPos.distanceTo(this.position())), (float)((float)this.targetPos.distanceTo(this.position())), (float)speed);
                this.currentTargetPos = ESMathUtil.rotationToPosition(this.position(), radius, pitch, yaw);
            }
            if (target != null) {
                this.calculateAttackTargetPos().ifPresent(vec3 -> {
                    this.targetPos = vec3;
                });
            }
            if (target == null && this.tickCount % 60 == 0) {
                this.targetPos = this.position().offsetRandom(this.getRandom(), 10.0f);
                if (this.targetPos.y < this.position().y) {
                    this.targetPos = new Vec3(this.targetPos.x, this.position().y() + (double)this.getRandom().nextInt(5, 15), this.targetPos.z);
                }
            }
            if (target != null && this.ticksToNextMeleeAttack == 0 && target.getBoundingBox().contains(this.chain.getEndPos().orElse(this.position().add(0.0, (double)this.getBbHeight(), 0.0)))) {
                this.doHurtTarget((Entity)target);
            }
            if (this.currentTargetPos != null) {
                this.chain.update(this.currentTargetPos, this.position(), 3.0f);
            }
            if ((targetPitch2 = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)targetPitch2;
                for (Chain.Segment segment : this.chain.segments()) {
                    if (!this.isDeadOrDying() && this.level().getBlockState(BlockPos.containing((Position)segment.getLowerPosition())).isAir() && this.level().getBlockState(BlockPos.containing((Position)segment.getMiddlePosition())).isAir() && this.level().getBlockState(BlockPos.containing((Position)segment.getUpperPosition())).isAir()) continue;
                    Vec3 base = segment.getMiddlePosition();
                    for (int j = 0; j < 2; ++j) {
                        Vec3 vec32 = base.offsetRandom(this.getRandom(), 2.0f);
                        for (int m = 0; m < serverLevel.players().size(); ++m) {
                            ServerPlayer serverPlayer = (ServerPlayer)serverLevel.players().get(m);
                            serverLevel.sendParticles(serverPlayer, (ParticleOptions)ESExplosionParticleOptions.LUNAR, true, vec32.x, vec32.y, vec32.z, 3, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
            int numSegments = this.chain.segments().size();
            ArrayList<TangledHatredPart> partsToRemove = new ArrayList<TangledHatredPart>();
            for (TangledHatredPart part : this.parts) {
                if (!part.isRemoved() && part.getParent() == this) continue;
                partsToRemove.add(part);
            }
            for (TangledHatredPart part : partsToRemove) {
                this.parts.remove((Object)part);
            }
            if (this.parts.size() != numSegments) {
                for (TangledHatredPart part : this.parts) {
                    part.discard();
                }
                this.parts.clear();
                for (int i = 0; i < numSegments; ++i) {
                    TangledHatredPart part = new TangledHatredPart(ESEntities.TANGLED_HATRED_PART.get(), this.level());
                    part.setPos(this.chain.segments().get(i).getMiddlePosition());
                    part.setParent(this);
                    this.level().addFreshEntity((Entity)part);
                    this.parts.add(part);
                }
            }
            if (this.parts.size() == numSegments) {
                for (int i = 0; i < numSegments; ++i) {
                    TangledHatredPart part = this.parts.get(i);
                    part.setPos(this.chain.segments().get(i).getMiddlePosition());
                }
            }
            this.setSyncedChain(this.chain);
        } else {
            this.oldChain = this.chain;
            if (!this.getSyncedChain().segments().isEmpty()) {
                this.chain = this.getSyncedChain();
            }
        }
    }

    @Override
    public boolean shouldPlayBossMusic() {
        return false;
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        if (compoundTag.contains(TAG_CHAIN, 10)) {
            this.chain = Chain.load(compoundTag.getCompound(TAG_CHAIN));
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        CompoundTag chainTag = new CompoundTag();
        this.chain.save(chainTag);
        compoundTag.put(TAG_CHAIN, (Tag)chainTag);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return ESSoundEvents.TANGLED_HATRED_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return ESSoundEvents.TANGLED_HATRED_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return ESSoundEvents.TANGLED_HATRED_HURT.get();
    }
}

