/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity;

import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosity;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorPhase;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.vfx.ScreenShakeVfx;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class LunarMonstrositySoulPhase
extends BehaviorPhase<LunarMonstrosity> {
    public static final int ID = 8;

    public LunarMonstrositySoulPhase() {
        super(8, 1, 100, 0);
    }

    @Override
    public boolean canStart(LunarMonstrosity entity, boolean cooldownOver) {
        return false;
    }

    @Override
    public void onStart(LunarMonstrosity entity) {
    }

    @Override
    public void tick(LunarMonstrosity entity) {
        if (entity.getBehaviorTicks() == 70) {
            entity.playSound(ESSoundEvents.LUNAR_MONSTROSITY_ROAR.get(), 0.5f, 1.0f);
            entity.knockbackNearbyEntities(5.0f, 2.5f, false);
            Level level = entity.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ScreenShakeVfx.createInstance((ResourceKey<Level>)entity.level().dimension(), entity.position(), 30.0f, 30, 0.15f, 0.24f, 4.0f, 5.0f).send(serverLevel);
            }
        }
    }

    @Override
    public boolean canContinue(LunarMonstrosity entity) {
        return true;
    }

    @Override
    public void onStop(LunarMonstrosity entity) {
    }
}

