/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.command;

import cn.leolezury.eternalstarlight.common.data.ESDimensions;
import cn.leolezury.eternalstarlight.common.registry.ESWeathers;
import cn.leolezury.eternalstarlight.common.util.ESWeatherUtil;
import cn.leolezury.eternalstarlight.common.weather.AbstractWeather;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.IntProvider;

public class ESWeatherCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandBuildContext commandBuildContext) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"weather").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"weather", (ArgumentType)ResourceArgument.resource((CommandBuildContext)commandBuildContext, ESWeathers.REGISTRY_KEY)).executes(commandContext -> ESWeatherCommand.setWeather((CommandSourceStack)commandContext.getSource(), (AbstractWeather)ResourceArgument.getResource((CommandContext)commandContext, (String)"weather", ESWeathers.REGISTRY_KEY).value(), -1))).then(Commands.argument((String)"duration", (ArgumentType)TimeArgument.time((int)1)).executes(commandContext -> ESWeatherCommand.setWeather((CommandSourceStack)commandContext.getSource(), (AbstractWeather)ResourceArgument.getResource((CommandContext)commandContext, (String)"weather", ESWeathers.REGISTRY_KEY).value(), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"duration")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"clear").executes(commandContext -> ESWeatherCommand.setClear((CommandSourceStack)commandContext.getSource(), -1))).then(Commands.argument((String)"duration", (ArgumentType)TimeArgument.time((int)1)).executes(commandContext -> ESWeatherCommand.setClear((CommandSourceStack)commandContext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"duration")))));
    }

    private static int getDuration(CommandSourceStack commandSourceStack, int i, IntProvider intProvider) {
        return i == -1 ? intProvider.sample(commandSourceStack.getLevel().getRandom()) : i;
    }

    private static int setWeather(CommandSourceStack commandSourceStack, AbstractWeather weather, int duration) {
        int trueDuration = ESWeatherCommand.getDuration(commandSourceStack, duration, weather.weatherProperties().duration());
        if (trueDuration > 0 && commandSourceStack.getLevel().dimension() == ESDimensions.STARLIGHT_KEY) {
            ESWeatherUtil.getOrCreateWeathers(commandSourceStack.getLevel()).setActiveWeather(weather, trueDuration);
            commandSourceStack.sendSuccess(() -> Component.translatable((String)"commands.eternal_starlight.weather.set", (Object[])new Object[]{weather.getDescription()}), true);
        } else {
            commandSourceStack.sendFailure((Component)Component.translatable((String)"commands.eternal_starlight.weather.fail", (Object[])new Object[]{weather.getDescription()}));
        }
        return duration;
    }

    private static int setClear(CommandSourceStack commandSourceStack, int duration) {
        int trueDuration = ESWeatherCommand.getDuration(commandSourceStack, duration, ServerLevel.RAIN_DELAY);
        if (trueDuration > 0 && commandSourceStack.getLevel().dimension() == ESDimensions.STARLIGHT_KEY) {
            ESWeatherUtil.getOrCreateWeathers(commandSourceStack.getLevel()).clearAllWeathers(trueDuration);
            commandSourceStack.sendSuccess(() -> Component.translatable((String)"commands.eternal_starlight.weather.clear"), true);
        } else {
            commandSourceStack.sendFailure((Component)Component.translatable((String)"commands.eternal_starlight.weather.clear_fail"));
        }
        return duration;
    }
}

