/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.entity.LunarThornModel;
import cn.leolezury.eternalstarlight.common.entity.attack.LunarThorn;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LunarThornRenderer
extends EntityRenderer<LunarThorn> {
    private static final ResourceLocation ENTITY_TEXTURE = EternalStarlight.id("textures/entity/lunar_thorn.png");
    private static final ResourceLocation GLOW_TEXTURE = EternalStarlight.id("textures/entity/lunar_thorn_glow.png");
    private final LunarThornModel<LunarThorn> model;

    public LunarThornRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new LunarThornModel(context.bakeLayer(LunarThornModel.LAYER_LOCATION));
    }

    public void render(LunarThorn entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        float yRot = -Mth.rotLerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot());
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - yRot));
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(0.0f, -1.5f, 0.0f);
        this.model.scale(Math.max(Mth.lerp((float)partialTicks, (float)entity.oldClientScale, (float)entity.clientScale), 0.0f));
        RenderType renderType = this.model.renderType(this.getTextureLocation(entity));
        VertexConsumer vertexConsumer = bufferSource.getBuffer(renderType);
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        RenderType glowRenderType = RenderType.entityTranslucentEmissive((ResourceLocation)GLOW_TEXTURE);
        VertexConsumer glowVertexConsumer = bufferSource.getBuffer(glowRenderType);
        this.model.renderToBuffer(poseStack, glowVertexConsumer, 0xF000F0, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((Entity)entity, yaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(LunarThorn entity) {
        return ENTITY_TEXTURE;
    }
}

