/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.blockentity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.block.LunarVineBlock;
import cn.leolezury.eternalstarlight.common.block.entity.LunarVineBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LunarVineRenderer
implements BlockEntityRenderer<LunarVineBlockEntity> {
    private final VineModel vineModel;
    private final FlowerModel flowerModel;
    private static final ResourceLocation VINE_TEXTURE = EternalStarlight.id("textures/entity/block_lunar_vine.png");
    private static final ResourceLocation FLOWER_TEXTURE = EternalStarlight.id("textures/entity/block_lunar_vine_flower.png");

    public LunarVineRenderer(BlockEntityRendererProvider.Context context) {
        this.vineModel = new VineModel(context.bakeLayer(VineModel.LAYER_LOCATION));
        this.flowerModel = new FlowerModel(context.bakeLayer(FlowerModel.LAYER_LOCATION));
    }

    public void render(LunarVineBlockEntity vine, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int light, int overlay) {
        stack.pushPose();
        stack.scale(-1.0f, -1.0f, 1.0f);
        stack.translate(-0.5f, -1.5f, 0.5f);
        stack.mulPose(Axis.YP.rotationDegrees(((Direction)vine.getBlockState().getValue((Property)LunarVineBlock.FACING)).toYRot()));
        if (vine.getLevel() != null) {
            BlockPos attachPos = vine.getBlockPos().relative((Direction)vine.getBlockState().getValue((Property)LunarVineBlock.FACING));
            boolean upperSturdy = vine.getLevel().getBlockState(attachPos.above()).isFaceSturdy((BlockGetter)vine.getLevel(), attachPos.above(), ((Direction)vine.getBlockState().getValue((Property)LunarVineBlock.FACING)).getOpposite());
            boolean lowerSturdy = vine.getLevel().getBlockState(attachPos.below()).isFaceSturdy((BlockGetter)vine.getLevel(), attachPos.below(), ((Direction)vine.getBlockState().getValue((Property)LunarVineBlock.FACING)).getOpposite());
            this.vineModel.applyVisibility(upperSturdy && vine.getLevel().isEmptyBlock(vine.getBlockPos().above()), lowerSturdy && vine.getLevel().isEmptyBlock(vine.getBlockPos().below()));
        }
        this.vineModel.renderToBuffer(stack, bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)VINE_TEXTURE)), light, overlay);
        for (LunarVineBlockEntity.Flower flower : vine.getOrCreateFlowers()) {
            stack.pushPose();
            stack.translate(flower.pos().x, flower.pos().y, flower.pos().z);
            this.flowerModel.root.xRot = flower.xRot() * ((float)Math.PI / 180);
            this.flowerModel.root.yRot = flower.yRot() * ((float)Math.PI / 180);
            this.flowerModel.renderToBuffer(stack, bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)FLOWER_TEXTURE)), light, overlay);
            stack.popPose();
        }
        stack.popPose();
    }

    public static final class VineModel
    extends Model {
        public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("block_lunar_vine"), "main");
        public final ModelPart root;
        public final ModelPart upperVine;
        public final ModelPart lowerVine;

        public VineModel(ModelPart root) {
            super(RenderType::entityCutoutNoCull);
            this.root = root.getChild("root");
            this.upperVine = root.getChild("root").getChild("upper_vine");
            this.lowerVine = root.getChild("root").getChild("lower_vine");
        }

        public static LayerDefinition createLayer() {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.getRoot();
            PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
            root.addOrReplaceChild("vine1", CubeListBuilder.create().texOffs(0, 21).addBox(-8.0f, 0.0f, 0.0f, 16.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-16.0f, (float)8.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
            root.addOrReplaceChild("vine2", CubeListBuilder.create().texOffs(0, 14).addBox(-8.0f, 0.0f, 0.0f, 16.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)8.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
            root.addOrReplaceChild("vine3", CubeListBuilder.create().texOffs(0, 7).addBox(-8.0f, 0.0f, 0.0f, 16.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)8.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
            root.addOrReplaceChild("vine4", CubeListBuilder.create().texOffs(32, 0).addBox(-8.0f, 0.0f, 0.0f, 16.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)8.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
            root.addOrReplaceChild("upper_vine", CubeListBuilder.create().texOffs(0, 28).addBox(-8.0f, -3.0f, 0.0f, 16.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-19.0f, (float)8.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
            root.addOrReplaceChild("lower_vine", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, 0.0f, 0.0f, 16.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)8.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
            return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
        }

        public void applyVisibility(boolean upper, boolean lower) {
            this.upperVine.visible = upper;
            this.lowerVine.visible = lower;
        }

        public void renderToBuffer(PoseStack stack, VertexConsumer consumer, int light, int overlay, int color) {
            this.root.render(stack, consumer, light, overlay, color);
        }
    }

    public static final class FlowerModel
    extends Model {
        public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("block_lunar_vine_flower"), "main");
        public final ModelPart root;

        public FlowerModel(ModelPart root) {
            super(RenderType::entityCutoutNoCull);
            this.root = root.getChild("root");
        }

        public static LayerDefinition createLayer() {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.getRoot();
            PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
            PartDefinition stem = root.addOrReplaceChild("stem", CubeListBuilder.create().texOffs(4, 2).addBox(0.0f, -5.0f, -0.5f, 0.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.0f, -6.0f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            stem.addOrReplaceChild("stem_rotated", CubeListBuilder.create().texOffs(4, 2).addBox(0.0f, -5.0f, -0.5f, 0.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
            PartDefinition petal1 = root.addOrReplaceChild("petal1", CubeListBuilder.create().texOffs(0, 1).addBox(0.0f, -2.0f, -1.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
            petal1.addOrReplaceChild("upper_petal", CubeListBuilder.create().texOffs(0, 3).addBox(0.0f, -2.0f, -1.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
            PartDefinition petal2_rotated = root.addOrReplaceChild("petal2_rotated", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
            PartDefinition petal2 = petal2_rotated.addOrReplaceChild("petal2", CubeListBuilder.create().texOffs(0, 1).addBox(0.0f, -2.0f, -1.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
            petal2.addOrReplaceChild("upper_petal2", CubeListBuilder.create().texOffs(0, 3).addBox(0.0f, -2.0f, -1.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
            PartDefinition petal3_rotated = root.addOrReplaceChild("petal3_rotated", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
            PartDefinition petal3 = petal3_rotated.addOrReplaceChild("petal3", CubeListBuilder.create().texOffs(0, 1).addBox(0.0f, -2.0f, -1.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
            petal3.addOrReplaceChild("upper_petal3", CubeListBuilder.create().texOffs(0, 3).addBox(0.0f, -2.0f, -1.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
            PartDefinition petal4_rotated = root.addOrReplaceChild("petal4_rotated", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
            PartDefinition petal4 = petal4_rotated.addOrReplaceChild("petal4", CubeListBuilder.create().texOffs(0, 1).addBox(0.0f, -2.0f, -1.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
            petal4.addOrReplaceChild("upper_petal4", CubeListBuilder.create().texOffs(0, 3).addBox(0.0f, -2.0f, -1.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
            return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
        }

        public void renderToBuffer(PoseStack stack, VertexConsumer consumer, int light, int overlay, int color) {
            this.root.render(stack, consumer, light, overlay, color);
        }
    }
}

